;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	https://www.wudsn.com/productions/atari800/hawkeyetunetro/hawkeyetunetro.zip
;
; 	@com.wudsn.ide.lng.outputfileextension=.xex
;	@com.wudsn.ide.lng.outputfoldermode=SOURCE_FOLDER

	icl "HawkeyeTunetro-Globals.asm"

cnt	= $14
p1	= $80
p2	= $82
p3	= $84
p4	= $86
p5	= $88

x1	= $90
x2	= $91
x3	= $92
x4	= $93

vbi_zp	= $a0

addresses	= globals.addresses
addresses_size	= $cc0
addresses_offset = addresses_size/3
addresses_end	= addresses+addresses_size	;Word

lookup		=   globals.lookup

	.if .not .def makefile
	.echo "Including raster program loader for test"
	icl "HawkeyeTunetro-Raster-Program-Loader"
	.endif

	org $2000		;Exomizer default entry point
	jmp main

;===============================================================

	icl "HawkeyeTunetro-Raster-Picture.asm"

;===============================================================

	.proc main
	jsr init
	jsr effects
	jmp exit

;===============================================================

	.proc init
sync	lda vcount
	cmp #3
	bcs sync		;wait 1 frame

	sei			;stop all IRQ interrupts
	mva #$00 nmien		;stop all NMI interrupts
	sta dmactl

	.proc init_charset

	lda chbas
	cmp #>globals.charset_ram
	beq charset_ok
	ldx #0
loop
:4	mva globals.charset_rom+#*$100,x globals.charset_ram+#*$100,x
	inx
	bne loop
charset_ok
	.endp

	mva #$fe portb

	ldx #<sound.module	;Low byte of RMT module to X reg
	ldy #>sound.module	;High byte of RMT module to Y reg
	lda #0			;Starting song line 0-255 to A reg
	jsr sound.init

	jsr screens.picture_screen.init_once
	jsr screens.main_screen.text.init_once
	jsr screens.main_screen.frame.score.init_digits

	jsr screens.main_screen.init

	mwa #nmi $fffa
	mwa #$40 nmien

	rts
	.endp

;===============================================================

	.proc exit
	mva #$00 nmien
	sta dmactl
	tax
	sta:rne hposp0,x+

	mva #$ff portb		;ROM switch on
	jmp $e474
	.endp

;===============================================================

	.proc nmi

	bit nmist
	bmi dli

	.proc vbi
	sta nmist
	pha
	txa
	pha
	tya
	pha

	lda #$c0
	sta nmien
	jsr sound.play
	inc cnt
	sne
	inc cnt-1
	
screen_ptr = *+1
	jsr $ffff

	pla
	tay
	pla
	tax
	pla
	rti
	.endp

;===============================================================

	.proc dli
	jmp (vdslst)
	.endp		;End of dli

;===============================================================

	.endp		;End of nmi

	.macro m_wait
	lda #:1
	jsr wait
	.endm

	.proc wait		;IN: <A>=number of frames
	clc
	adc cnt
loop	cmp cnt
	bne loop
	rts
	.endp

;===============================================================

	.proc sound
STEREOMODE = 0			;4 => compile RMTplayer for mono 4 tracks with dual mono modification
zp	= 203			;13 bytes of zero pages
init	= player		;Play 1 step
play	= player+3		;<A>=song number 0...255, <X>=lo byte of module, <Y>=hi byte of module
stop	= player+9	        ;All sounds off

track_line_count = $01		;JAC!

	icl "../msx/RMT-Relocator.mac"		;Include relocator

	m_align_page
	.ds $400				;use by RMT player via ORG player-$xyz.
player
	icl "../msx/RMT-Player.asm"		;Include RMT player routine

	icl "../msx/Hawkeye-Stripped-Features.asm"
module
	rmt_relocator '../msx/Hawkeye-Stripped.rmt' module
	.endp

;===============================================================

	.proc screens

fade_delay = 1

	.local fade_luma
	length = .len fade_luma
	.byte 0,0,2,0
	.byte 2,2,4,2
	.byte 4,4,6,4
	.byte 6,6,8,6
	.byte 8,8,10,8
	.byte 10,10,12,10
	.byte 12,12,14,12
	.byte 14,14,14,14
	.endl

;===============================================================

	icl "HawkeyeTunetro-Picture-Screen.asm"

;===============================================================

	.proc system

	.proc clear_pages
	lda #0
	tay
loop	sta (p1),y
	iny
	bne loop
	inc p1+1
	dex
	bne loop
	rts
	.endp
	
	.endp

;===============================================================

	icl "HawkeyeTunetro-Main-Screen.asm"

;===============================================================

	.endp			;End of screens
;===============================================================

	icl "HawkeyeTunetro-Effects.asm"

;===============================================================
	.endp			;End of main

	m_info main


	opt f-

	run main
