;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=HawkeyeTunetro.asm

	.proc text			;Text screen

	.proc init_once			;Called once
	mwa #text_lines print_next_text_lines.print_next_text_line.text_line_ptr
	rts
	.endp

	.proc init			;Called once when returning from another screen
	lda #0
	sta color1
	sta color2
	rts
	.endp

	.proc print_next_text_lines
	lda #0
	ldx #[.len text_sm.output]-1
clear_loop
	sta text_sm.output,x
	dex
	bpl clear_loop

	sta text_length

	mwa #text_sm.output p1
	jsr print_next_text_line
	mwa #text_sm.output+40 p1
	jsr print_next_text_line
	mwa #text_sm.output+80 p1
	jsr print_next_text_line
	lda text_sm.output+80
	beq stop
	rts

stop	.byte 2

	.proc print_next_text_line
	ldy #$ff
print_loop
	iny
text_line_ptr = *+1
	lda $ffff,y
	cmp #line_end
	beq line_ended
	cmp #section_end
	beq section_ended
	cmp #text_end
	beq text_ended
	sta (p1),y
	jmp print_loop

section_ended
line_ended
	sta text_marker
	cpy text_length
	scc
	sty text_length

	tya
	sec		;Skip line terminator
	adc text_line_ptr
	sta text_line_ptr
	scc
	inc text_line_ptr+1
	rts

text_ended
	sta text_marker
	mwa #text_lines text_line_ptr
	rts
	
	.endp		;End of print_next_text_line

	.endp		;End of print_next_text_lines

	m_assert_same_4k text_sm

	.proc fade_in			;IN: <A>=color_index (0,1)
	tay
	ldx #0
loop	mva fade_luma,x color1,y
	lda #fade_delay
	jsr wait
	inx
	cpx #.len fade_luma-1
	bne loop
	rts 
	.endp


	.proc fade_out			;IN: <A>=color_index (0,1)
	tay
	ldx #.len fade_luma-1
loop	mva fade_luma,x color1,y
	lda #fade_delay
	jsr wait
	dex
	bpl loop
	rts 
	.endp

	.proc dli
	pha
	mva color1 colpf1
	mva #0 colpf2
	mwa #dli2 vdslst
	lda color2
	beq no_output
	lda #$02
	bne do_output
no_output
	lda #$f0
do_output
	sta text_dl.output
	sta text_dl.output+1
	ora #$80
	sta text_dl.output+2
	pla
	rti
	.endp

	.proc dli2
	pha
	mva color2 colpf1
	sta hitclr
	mwa #dli3 vdslst
	pla
	rti
	.endp

	.proc dli3
	pha
	lda m0pf		;Read missle collisions with the playfield
	ora m1pf
	ora m2pf
	ora m3pf
	sta mxpf	
	mwa #frame.dli vdslst
	pla
	rti
	.endp

	m_align_page

	.local text_dl
:6	.byte $70
	.byte $42,a(text_sm)
	.byte $70,$02,$82		;With DLI
:1	.byte $70
output	.byte $02,$02
	.byte $82			;With DLI
:2	.byte $70
	.byte $81,a(dl.frame_end)	;With DLI for frame
	.endl
	
	m_assert_same_1k text_dl

line_end = $fd
section_end = $fe
text_end = $ff

text_marker .byte 0
text_length .byte 0
color1	.byte 0
color2	.byte 4
mxpf	.byte 0				;ORed missle collisions

	.local text_sm
	.byte "Hawkeye Song                            "
	.byte "Original by SMT                         "
	.byte "Atari Version by Buddy76cd              "
	.local output
	.byte "                                        "
	.byte "                                        "
	.byte "                                        "
	.endl
	.endl

	.local text_lines
	.byte "Code by JAC!",line_end
	.byte "34 years late :-)",line_end
	.byte "8-bit greetings too ...",line_end

	.byte "A.B.B.U.C.",line_end
	.byte "Agenda",line_end
	.byte "Altair",line_end

	.byte "Arsenic",line_end
	.byte "atariBSDM",line_end
	.byte "Atari Oldschoolers",line_end

	.byte "Dekadence",line_end
	.byte "Desire",line_end
	.byte "F#ready",line_end
	
	.byte "Flush",line_end
	.byte "g0blinish",line_end
	.byte "Genesis",line_end

	.byte "Lamers",line_end
	.byte "Mad Team",line_end
	.byte "MEC",line_end

	.byte "Mystic Bytes",line_end
	.byte "New generation",line_end
	.byte "Noice",line_end

	.byte "PPS",line_end
	.byte "Suspect",line_end
	.byte "Tristesse",line_end

	.byte "Personal kudos also ...",line_end
	.byte "0xf",line_end
	.byte "Acid Maker",line_end 

	.byte "AdamK",line_end
	.byte "Bewu",line_end
	.byte "Felice",line_end
	
	.byte "Gorgh",line_end
	.byte "Grey",line_end
	.byte "Heaven",line_end

	.byte "Miker",line_end
	.byte "Piter",line_end
	.byte "Rocky",line_end
	
	.byte "Scorpio",line_end
	.byte "Svoy",line_end
	.byte "Trish",line_end

	.byte "Wiecz0r",line_end
	.byte "trix",line_end
	.byte "xxl",line_end

	.byte "Enyjoy the demo",line_end
	.byte "or use a joystick",line_end
	.byte "to play yourself.", section_end

	.byte "This demo would",line_end
	.byte "not have been",line_end
	.byte "possible...",line_end

	.byte "without Grey",line_end
	.byte "who always",line_end
	.byte "pushes us...",line_end

	.byte "Thanks for",line_end
	.byte "keeping the",line_end
	.byte "scene alive ",64,64,64,line_end

	.byte "Now grab beer",line_end
	.byte "and enjoy the party.",line_end
	.byte "See you in Winter!", text_end

	.endl
	
	.endp			;End of text