;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=Hawkeye-SLF-Test.asm
;	@com.wudsn.ide.asm.mainsourcefile=HawkeyeTunetro.asm

;==========================================================

	.proc slf

	.enum motion_type
	waiting = 0
	standing = 1
	running = 2
	.ende

	.enum direction_type
	front = 0
	left = 1
	right = 2
	.ende

xpos_min_limit = $30
xpos_max_limit = xpos_min_limit+$a0-12

	.var stick .byte
	.var fire_button .byte

;===============================================================

	.proc init_limits

	mva #xpos_min_limit slf_state.xpos_min
	mva #xpos_max_limit slf_state.xpos_max
	rts
	.endp

	.proc init_position		;IN: <X>=xpos, <Y>=ypos
	jsr init_motion_waiting
	mva #0 slf_state.running_phase
	stx slf_state.xpos
	sty slf_state.ypos
	sty slf_state.ypos_old
	rts
	.endp

	.proc init_motion_waiting
	mva #motion_type.waiting slf_state.motion
	mva #direction_type.front slf_state.direction
	rts
	.endp
;===============================================================

	.proc read_controller		;IN: stick, fire_button

	lda slf_state.controller_active
	sne
	rts

	.proc check_user_idle
	lda stick
	and #$0f
	cmp #$0f
	bne user_motion
	lda fire_pressed
	bne no_user_motion
user_motion
	mva #0 slf_state.demo_mode	;Stop demo mode if user moves
	sta slf_state.user_idle_counter	;Start idle counter
	sta slf_state.user_idle_counter+1
	jmp done

no_user_motion
	inw slf_state.user_idle_counter
	lda slf_state.user_idle_counter+1
	cmp #2
	bne no_user_idle_long
	jsr demo.init_demo_mode		;Enter demo mode after inactivity

no_user_idle_long
done
	.endp

	lda slf_state.demo_mode
	beq no_demo_mode

	jsr demo.animate_demo_action

no_demo_mode
	lda fire_button
	beq fire_pressed

	lda slf_weapon.slf_weapon_state.active
	bne weapon_active

	lda stick
	lsr
	lsr
	lsr
	bcc move_left
	lsr
	bcc move_right

	lda slf_state.motion
	cmp #motion_type.waiting
	beq still_waiting
	
	mva #motion_type.standing slf_state.motion
	mva #0 slf_state.running_phase

still_waiting
weapon_active
	rts

	.proc fire_pressed
	lda slf_state.motion
	cmp #motion_type.waiting
	beq still_waiting
	lda slf_weapon.slf_weapon_state.active
	bne already_active

	mva #motion_type.standing slf_state.motion	
	jsr slf_weapon.fire_weapon
already_active
still_waiting
	rts
	.endp

	.proc move_up_down
	ldy slf_state.ypos
	lda stick
	lsr
	bcs no_up
	cpy #slf_state.ypos_min
	beq no_up
	dey
	sty slf_state.ypos
	rts

no_up	lsr
	bcs no_down
	cpy #slf_state.ypos_max
	beq no_down
	iny
	sty slf_state.ypos

no_down	rts
	.endp


	.proc move_left
	ldx slf_state.xpos
	cpx slf_state.xpos_min
	seq
	dex
	stx slf_state.xpos
	lda #direction_type.left
	jmp move_dir
	.endp

	.proc move_right
	ldx slf_state.xpos
	cpx slf_state.xpos_max
	seq
	inx
	stx slf_state.xpos
	lda #direction_type.right
	jmp move_dir
	.endp

	.proc move_dir
	sta slf_state.direction
	mva #motion_type.running slf_state.motion

	jsr move_up_down

	lda $14
	and #1
	sne
	rts

	lda slf_state.running_phase
	add #1
	cmp #pmg.running_size
	sne
	lda #0
	sta slf_state.running_phase
	rts
	.endp

	.endp

;===============================================================

	.proc demo

	.proc init_demo_mode
	mva #1 slf_state.demo_mode
	mwa #0 slf_state.user_idle_counter
	mva #0 slf_state.demo_duration
	rts
	.endp

	.proc init_demo_action	;IN: <A>=duration in frames, <X>=action_index
	sta slf_state.demo_duration
	stx slf_state.demo_action
repeat	txa
	asl
	asl
	tax
	mwa actions.action_addresses,x action_init_adr
	mwa actions.action_addresses+2,x animate_demo_action.action_animate_adr
action_init_adr = *+1
	jmp $ffff
	bcs repeat
	.endp


	.proc animate_demo_action
	lda slf_state.demo_duration
	bne duration_active

	lda random
	and #3
	tax

	lda random
	clc
	adc #50
	scc
	lda #$ff
	jmp init_demo_action

duration_active
action_animate_adr = *+1
	jsr $ffff

	.proc animate_fire_button
	mva #1 fire_button
	lda slf_state.fire_duration
	bne fire_active
	lda random
	cmp #253
	bcc no_fire_active
	lda random
	and #127
	ora #1
	sta slf_state.fire_duration

fire_active
	dec slf_state.fire_duration
	mva #0 fire_button
no_fire_active
	.endp

	lda slf_state.demo_duration
	seq
	dec slf_state.demo_duration
	rts
	.endp

	.proc actions

quarantine = 20

	.enum action_type
	stand_still = 0
	run_left = 1
	run_right = 2
	.ende

	.macro m_action
	.word :1.init, :1.animate
	.endm

	.local action_addresses
	m_action stand_still
	m_action run_left
	m_action run_right
	m_action stand_still
	m_action stand_still
	m_action run_right
	m_action run_left
	m_action stand_still
	.endl

;---------------------------------------------------------------

	.proc stand_still

	.proc init
	lsr slf_state.demo_duration
	clc
	rts
	.endp

	.proc animate
	mva #15 stick
	rts
	.endp

	.endp

;---------------------------------------------------------------

	.proc run_left

	.proc init
	lda slf_state.xpos
	cmp slf_state.xpos_min
	bcs ok

	ldx #actions.action_type.run_right
	sec
	rts

ok
	.if .def frame
	lda #0
	jsr frame.eyes.set_eye_active
	.endif

	clc
	rts

	.endp

	.proc animate
	lda slf_state.xpos
	sec
	sbc #quarantine
	cmp slf_state.xpos_min
	bcs no_edge
	lda slf_state.demo_duration
	ldx #actions.action_type.run_right
	jsr init_demo_action
	rts
no_edge
	mva #11 stick
	rts
	.endp

	.endp
;---------------------------------------------------------------

	.proc run_right

	.proc init
	
	.if .def frame
	lda #1
	jsr frame.eyes.set_eye_active
	.endif

	clc
	rts
	.endp
	
	.proc animate
	lda slf_state.xpos
;	clc
;	adc #quarantine	;No quarantine on the right
	cmp slf_state.xpos_max
	bcc no_edge
	lda slf_state.demo_duration
	ldx #actions.action_type.run_left
	jsr init_demo_action
	rts
no_edge
	mva #7 stick
	rts
	.endp

	.endp

;---------------------------------------------------------------
	.endp			;End of actions

	.endp			;End of demo

;===============================================================


	.proc print_slf		;IN: slf_state.direction, slf_state.motion
	
	ldx slf_state.direction

	lda slf_state.motion
	cmp #motion_type.waiting
	beq waiting
	cmp #motion_type.standing
	beq standing
	cmp #motion_type.running
	beq running
	.byte 2

waiting
	mva #pmg.waiting_chest print_slf_sprites.chest_sprite
	mva #pmg.waiting_legs  print_slf_sprites.legs_sprite
	jmp print_slf_sprites

standing
	lda slf_weapon.slf_weapon_state.weapon
	beq no_weapon
	sub #slf_weapon.weapon_type.gun
	asl
no_weapon
	add #pmg.shooting_chest_first
	add pmg.dir_first,x
	ldy slf_weapon.slf_weapon_state.active_phase
	beq not_shooting
	cpy #16
	bcs not_shooting
	adc #1
not_shooting
	sta print_slf_sprites.chest_sprite
	lda #pmg.standing_legs
	add pmg.dir_first,x
	sta print_slf_sprites.legs_sprite
	jmp print_slf_sprites

running
	ldy slf_state.running_phase
	lda pmg.chest_sequence,y
	add #pmg.running_chest_first
	add pmg.dir_first,x
	sta print_slf_sprites.chest_sprite

	tya
	add #pmg.running_legs_first
	add pmg.dir_first,x
	sta print_slf_sprites.legs_sprite
	jmp print_slf_sprites

	.proc print_slf_sprites
	.var chest_sprite .byte
	.var legs_sprite .byte

	ldy slf_state.ypos_old
	cpy slf_state.ypos
	beq no_clear
clear
	ldx #pmg.empty
	jsr print_slf_sprite
	lda slf_state.ypos_old
	add #pmg.slf_height
	tay
	ldx #pmg.empty
	jsr print_slf_sprite
no_clear
	ldy slf_state.ypos
	sty slf_state.ypos_old
	ldx chest_sprite
	jsr print_slf_sprite

	lda slf_state.ypos
	add #pmg.slf_height
	tay
	ldx legs_sprite
	jmp print_slf_sprite

	.proc print_slf_sprite		;IN: <X>=sprint_numner, <Y>=ypos
	mva pmg.addresses.lo,x p1
	mva pmg.addresses.hi,x p1+1
 
	adw p1 #pmg.slf_height p2
	adw p2 #pmg.slf_height p3
	adw p3 #pmg.slf_height p4

	tya
	clc
	adc #pmg.slf_height-1
	tax
	ldy #pmg.slf_height-1
loop
p1 = *+1
	mva $ffff,y pm+$400,x
p2 = *+1
	mva $ffff,y pm+$600,x
p3 = *+1
	mva $ffff,y pm+$500,x
p4 = *+1
	mva $ffff,y pm+$700,x
	dex
	dey
	bpl loop
	rts
	.endp			;End of print_slf_sprite
	.endp			;End of print_slf_sprites
	
	.endp			;End of print_slf

	.proc set_slf_hpos
	lda slf_state.display_active
	beq no_display
	lda slf_state.xpos
no_display
	sta $d000
	sta $d001
	add #8
	sta $d002
	sta $d003
	rts
	.endp


;===============================================================

	.local slf_state
display_active		.byte 0
controller_active	.byte 0
demo_mode		.byte 0
user_idle_counter	.word 0

demo_xpos_min		.byte 0
demo_duration		.byte 0
demo_direction		.byte 0
demo_action		.byte 0
fire_duration		.byte 0

xpos_min		.byte 0
xpos_max		.byte 0
xpos			.byte 0
ypos_min = $60
ypos_max = $bb
ypos			.byte 0
ypos_old		.byte 0
motion			.byte 0 ;0=standing;1=running;2=shooting
direction		.byte 0 ;0=front;1=left;2=right
running_phase		.byte 0
	.endl

	.local pmg
sprites_per_line = 34
lines 		= 2
sprites	 	= lines*sprites_per_line
block_size	= 84
slf_height	= 21

empty			= 33

waiting_chest		= 0
waiting_legs		= waiting_chest+pmg.sprites_per_line

standing_legs		= 32

running_size		= 14
running_chest_first	= 1
running_legs_first	= 9

shooting_chest_first	= 23

	ins "../gfx/game/Hawkeye-SLF.pm"

dir_first
	.byte 0,sprites_per_line*1,sprites_per_line*0

chest_sequence
	.byte 0,1,2,3,4,5,6,7,6,5,4,3,2,1

	.local addresses
lo	.rept sprites
	.byte <[pmg+block_size*#]
	.endr

hi	.rept sprites
	.byte >[pmg+block_size*#]
	.endr
	.endl

	.endl

	.endp			;End of slf

