;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=Hawkeye-SLF-Test.asm

	.proc slf_weapon

	.enum weapon_type
	none = 0
	gun = 1
	heavy1 = 2
	heavy2 = 3
	heavy3 = 4
	.ende

;===============================================================

	.proc init_weapons
	lda #0
	sta slf_weapon_state.weapon_level+weapon_type.none
	sta slf_weapon_state.weapon_level+weapon_type.gun
	sta slf_weapon_state.weapon_level+weapon_type.heavy1
	sta slf_weapon_state.weapon_level+weapon_type.heavy2
	sta slf_weapon_state.weapon_level+weapon_type.heavy3
	lda #weapon_type.none
	jsr init_weapon
	
	rts
	.endp

	.proc init_weapon
	mvx #0 slf_weapon_state.active
	jsr select_weapon
	rts
	.endp

	.proc select_weapon		;IN: <A>=weapon
	sta slf_weapon_state.weapon
	.if .def frame
	jsr frame.weapons.print_weapon
	jsr frame.weapons.print_belt
	.endif
	rts
	.endp
	
	.proc select_random_weapon
reselect
	lda random
	and #3
	add #weapon_type.gun
	tax
	lda slf_weapon_state.weapon_level,x
	beq reselect
	txa
	jmp select_weapon
	.endp

	.proc set_weapon_level		;IN: <X>=weapon, <A>=weapon_level
	sta slf_weapon_state.weapon_level,x
	cpx slf_weapon_state.weapon	;Update current weapon?
	bne no_update
	.if .def frame
	jsr frame.weapons.print_belt
	.endif
no_update
	rts
	.endp

;===============================================================

	.proc fire_weapon		;OUT: C=1 if it was fired, C=0 if there is no ammo
	ldx slf_weapon_state.weapon

	lda slf_weapon_state.weapon_level,x
	beq no_ammo
	cpx #weapon_type.gun+1		;Empty and gun don't count down
	bcc no_limit
	dec slf_weapon_state.weapon_level,x
no_limit
	.if .def frame
	jsr frame.weapons.print_belt
	.endif

	ldx slf_weapon_state.weapon
	lda slf.slf_state.xpos
	mvy slf.slf_state.direction slf_weapon_state.direction
	cpy #slf.direction_type.right
	beq right
	add slf_weapon_definition.xoffset.left,x
	jmp set_xpos
right
	add slf_weapon_definition.xoffset.right,x
set_xpos
	sta slf_weapon_state.xpos

	lda slf.slf_state.ypos
	add slf_weapon_definition.yoffset,x
	sta slf_weapon_state.ypos
	mva #1 slf_weapon_state.active
	mva #0 slf_weapon_state.active_phase
	sec
	rts

no_ammo
	clc
	rts
	.endp

;===============================================================

	.proc animate_weapon
	lda slf_weapon_state.active
	beq not_active
	inc slf_weapon_state.active_phase

	ldx slf_weapon_state.direction
	lda slf_weapon_state.xpos
	ldy slf_weapon_state.weapon
	cpx #slf.direction_type.left
	beq move_left
	cpx #slf.direction_type.right
	beq move_right
	.byte 2

not_active
	rts
	
	.proc move_left
	sub slf_weapon_definition.speed,y
	cmp #slf_weapon_state.xpos_min
	beq deactivate
	bcc deactivate
	sta slf_weapon_state.xpos
	rts
	.endp

	.proc move_right
	add slf_weapon_definition.speed,y
	cmp #slf_weapon_state.xpos_max
	bcs deactivate
	sta slf_weapon_state.xpos
	rts
	.endp

	.proc deactivate
	jsr clear_weapon
	mva #0 slf_weapon_state.active
	rts
	.endp
	
	.endp			;End of animate_weapon

	.proc print_weapon
	lda slf_weapon_state.active
	beq not_active
	ldy slf_weapon_state.ypos
	lda #$33
	sta pm+$300,y
	sta pm+$302,y
	lda #$ff
	sta pm+$301,y
not_active
	rts
	.endp			;End of print_weapon

	.proc clear_weapon
	ldy slf_weapon_state.ypos
	lda #$00
	sta pm+$300,y
	sta pm+$301,y
	sta pm+$302,y
	rts
	.endp			;End of clear_weapon

	.proc set_weapon_hpos
	lda slf_weapon_state.xpos
	sta $d006
	sta $d007
	add #2
	sta $d005
	sta $d004
	rts
	.endp

	.proc play_weapon_sound
	lda slf_weapon_state.active
	bne active
;	lda #0
;	sta $d201
	rts

active	lda slf_weapon_state.active_phase
	add #32
	sta $d200
	mva #$c8 $d201
	rts
	.endp			;End of play_weapon_sound

;===============================================================

	.local slf_weapon_definition

	.local xoffset
	.local left
	.byte 0,-2,6,8,-1
	.endl
	.local right
	.byte 0,10,9,0,10
	.endl
	.endl

yoffset	.byte 0,16,16,8,15
speed	.byte 0,4,6,8,10
	
	.endl

	.local slf_weapon_state

max_weapon_level = 12
weapon_level .byte 0,0,0,0,0	;0 is no weapon, level of gun (1) is umlimited

weapon			.byte 0
weapon_phase		.byte 0 ;0 or 1

active			.byte 0
active_phase		.byte 0
xpos_min = $28
xpos_max = $d4
xpos			.byte 0
ypos			.byte 0
ypos_old		.byte 0
direction		.byte 0

	.endl

	.endp		;End of slf_weapon
