;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=HawkeyeTunetro-Raster-Program-Loader.asm


	.proc raster_program, globals.raster_program

byt2	= $00

; The names of the shadow registers are used in the raster program, heaven knows why...
color0	= colpf0
color1	= colpf1
color2	= colpf2
color3	= colpf3
colbak	= colbk

	lda #0
	sta colpf3
	
	lda #$03
	sta sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	mva #$ff sizem
	sta grafm
	mva #$20 hposm0
	mva #$28 hposm1
	mva #$d0 hposm2
	mva #$d8 hposm3
	mva #$02 gractl
	lda #$14
	sta prior

loop	lda vcount		;synchronization for the first screen line
	cmp #$02
	bne loop

	mva #%00111110 dmactl	;set new screen width
	mwa #globals.picture_dl dlptr

	.proc init
	icl "../gfx/generator/output.png.rp.ini"
	.endp

;--- wait 18 cycles
	jsr _rts
	inc byt3

;--- set global offset (23 cycles)
	jsr _rts
	cmp byt3\ pha:pla

;--- empty line
	jsr wait54cycle
	inc byt2

	.proc main

	.macro m_delay_2_cycles	;1 bytes
	nop
	.endm

	.macro m_delay_3_cycles	;2 bytes
	cmp byt2;
	.endm

	.macro m_delay_4_cycles	;2 bytes
	nop
	nop
	.endm

	.macro m_delay_5_cycles	;2 bytes
	inc byt2;
	.endm

	.macro m_delay_6_cycles	;3 bytes
	nop
	nop
	nop
	.endm

	.macro m_delay_7_cycles	;3 bytes
	inc byt2;
	nop
	.endm

	.macro m_delay_8_cycles	;4 bytes
	nop
	nop
	nop
	nop
	.endm

	.macro m_delay_9_cycles	;4 bytes
	inc byt2;
	nop
	nop
	.endm

	.macro m_delay_11_cycles ;6 bytes
	m_delay_5_cycles	;2 bytes	
	m_delay_6_cycles	;4 bytes
	.endm

;	Regular expressions used to compress the rp
;
;	\ \R
;	\R
;
;	\tcmp byt2; on zero page so 3 cycles
;	\tm_delay_3_cycles
;
;	\tnop\R\tnop\R\tnop\R\tnop
;	\tMdelay_8_cycles
;	
;	\tm_delay.*\R\tm_delay.*\R

;	icl "../gfx/generator/output.png.rp"
	icl "../gfx/generator/output.png.rp.packed"

	.endp
	rts

wait54cycle
	:2 inc byt2
wait44cycle
	inc byt3
	nop
wait36cycle
	inc byt3
	jsr _rts
wait18cycle
	inc byt3
_rts	rts

byt3	.byte $00 	;Also end marker
	.endp

	m_info raster_program

