;
;	>>> Hawkeye Tunetro Post Loader by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	The post loader is loaded after the exomizer sfx segment.

	icl "HawkeyeTunetro-Globals.asm"

	org $1f00

color	= $80

	.proc loader

show_loading_screen
	clc			;Ensure the loading screen is displayed for at least 3*256 frames = 15 seconds
	lda rtclok+1
	adc rtclok
	cmp #3
	bcc show_loading_screen

	mva #$00 nmien
	mwa #sysvbv vvblki	;Disable NMIs from "HawkeyeTunetro-Atari50.asm"
	mwa #xitvbv vvblkd
	mva #$40 nmien

	jsr fade_down
	
	mva #1 coldst		;Because we will kill DOS
;	jsr copy_charset

	lda #25
	jsr wait
	mva #$2e sdmctl
	mwa #dl sdlstl
	lda #1
	jsr wait
	mva #$ff $2009		;Patch EXOMIZER lda #$ff:sta $d301
	rts

	.proc fade_down
fade_loop
	ldx #9
	ldy #0
color_loop
	lda color0,x
	and #$0f
	beq store
	ldy #1
	lda color0,x
	pha
	and #$f0
	sta color
	pla
	and #$0f
	sec
	sbc #1
	ora color
store	sta color0,x
	dex
	bpl color_loop
	lda #2
	jsr wait
	cpy #1
	beq fade_loop
	rts
	.endp

;	.proc copy_charset
;	ldx #0
;loop
;:4	mva globals.charset_rom+#*$100,x globals.charset_ram+#*$100,x
;	inx
;	bne loop
;	mva #>globals.charset_ram chbas
;	rts
;	.endp

	.proc wait
	clc
	adc rtclok+2
loop	cmp rtclok+2
	bne loop
	rts
	.endp

	.local dl
:14	.byte $70
	.byte $42,a(sm)
	.byte $41,a(dl)
	.endl
	
	.local sm
	.byte "Good code flickers while decrunching :-)"
	.endl
	
	.endp

	ini loader