;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=HawkeyeTunetro.asm

	.proc picture_screen

	.proc init_once			;Called once

	jsr init_addresses
	jsr collect_addresses

	lda #0
	jsr set_colors
	rts
	.endp
	
	.proc init_addresses
	mwa #addresses+addresses_offset*0 p3
	mwa #addresses+addresses_offset*1 p4
	mwa #addresses+addresses_offset*2 p5
	rts
	.endp
	
	.proc vbi
 	mva >raster_picture.pmg pmbase		;missiles and players data address
	mva #$03 gractl		;enable players and missiles

	jsr globals.raster_program
	
	lda #$00
	sta colbk
	sta color0
	sta color1
	sta color2
	sta color3
	rts
	.endp

;===============================================================

	.proc collect_addresses		;Run only once!

	mwa #globals.raster_program p1
	jsr collect_section_addresses
	mwa p3 addresses_end
	rts

	.proc collect_section_addresses	;IN: p1=raster program, p2=addresses

	.enum register
	a = 0
	x = 3
	y = 6
	.ende

	ldy #0
next	jsr peek
	ldx #register.a
	cmp #opcode.lda_imm
	beq ld_axy
	ldx #register.x
	cmp #opcode.ldx_imm
	beq ld_axy
	ldx #register.y
	cmp #opcode.ldy_imm
	beq ld_axy

	ldx #register.a
	cmp #opcode.sta_abs
	beq st_axy_abs
	ldx #register.x
	cmp #opcode.stx_abs
	beq st_axy_abs
	ldx #register.y
	cmp #opcode.sty_abs
	beq st_axy_abs

	cmp #opcode.nop
	beq skip_0_bytes
	cmp #opcode.cmp_imm
	beq skip_1_byte
	cmp #opcode.cmp_zp
	beq skip_1_byte
	cmp #opcode.inc_zp
	beq skip_1_byte
	cmp #opcode.bne
	beq skip_1_byte
	cmp #opcode.jsr
	beq skip_2_bytes
	cmp #opcode.rts
	beq skip_0_bytes
	cmp #opcode.inc_abs
	beq skip_2_bytes
	cmp #opcode.cmp_abs
	beq skip_2_bytes

	cmp #$48
	beq skip_0_bytes
	cmp #$68
	beq skip_0_bytes
	cmp #opcode.lda_abs
	beq skip_2_bytes
	cmp #opcode.brk			;End marker
	beq done
	.byte 2				;Unkown opcode

ld_axy	mwa p1 register_address,x	;Save address where the operand of the LD? # operation was
	jsr peek
	sta register_address+2,x
	jmp skip_0_bytes

st_axy_abs
	jsr peek			;Relevant address range of color registers?
	cmp #<colpm0
	bcc skip_1_byte
	cmp #<[colbk+1]
	bcs skip_1_byte
	jsr peek			;Check high byte of sta abs
	cmp #>colpm0
	bne skip_0_bytes		;No GTIA

	lda register_address,x		;Store original source operand address
	jsr poke_lo
	lda register_address+1,x
	jsr poke_hi
	lda register_address+2,x
	jsr poke_value
	jmp skip_0_bytes


skip_2_bytes
	jsr peek
skip_1_byte
	jsr peek
skip_0_bytes
	jmp next

done	rts

	.proc peek
	lda (p1),y
	inw p1
	rts
	.endp
	

	.proc poke_lo
	sta (p3),y
	inw p3
	rts
	.endp

	.proc poke_hi
	sta (p4),y
	inw p4
	rts
	.endp

	.proc poke_value
	sta (p5),y
	inw p5
	rts
	.endp

	.local register_address	;Last address where lda/ldy/ldy #$nn was found and value that was found
	.byte a(0),0,a(0),0,a(0),0
	.endl
	.endp

	.endp
	
;===============================================================

	.proc fade_in
	ldx #0
loop	stx color0
	jsr set_colors
	inx
	cpx #8
	bne loop
	rts 
	.endp			;End of collect addresses

	.proc fade_out
	ldx #7
loop	stx color0
	jsr set_colors
	dex
	bpl loop
	rts 
	.endp

	.proc set_colors	;IN: color0=luma (0..7)
	txa:pha:tya:pha

	lda color0
	asl
	eor #$0e
	sta luma

	ldx #0
init	txa
	and #$f0
	sta chroma
	txa
	and #$0f
	sec
luma = *+1
	sbc #$00
	bcc black
chroma = *+1
	ora #$00
	.byte $2c
black	lda #0
	sta lookup,x
	inx
	bne init

	mwa #addresses+addresses_offset*0 lo_ptr
	mwa #addresses+addresses_offset*1 hi_ptr
	mwa #addresses+addresses_offset*2 value_ptr
	mva addresses_end lo_end
	mva addresses_end+1 hi_end
	ldy #0
loop
hi_ptr = *+1
	mva $ffff,y ptr+1
value_ptr = *+1
	ldx $ffff,y
	lda lookup,x
lo_ptr = *+1
	ldx $ffff,y
ptr = *+1
	sta $ff00,x
	iny
	bne no_inc
	inc lo_ptr+1
	inc hi_ptr+1
	inc value_ptr+1
no_inc

;	.byte 2

lo_end = *+1
	cpy #$00
	bne loop
	lda lo_ptr+1
hi_end = *+1
	cmp #$00
	bne loop
	
	pla:tay:pla:tax
	rts
	.endp

	.endp			;End of picture_screen