;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=HawkeyeTunetro.asm

	.proc main_screen

pm	= globals.pm

	.proc init		;Main init

	jsr text.init
	jsr frame.init
	jsr game.init

	mwa #vbi nmi.vbi.screen_ptr
	mwa #text.text_dl dl.dl_adr

	rts
	.endp

	.proc vbi		;Main VBI

	mva #%00111110 dmactl
	mwa #dl dlptr
	mwa #text.dli vdslst
	mva #>globals.charset_ram chbase

	jsr frame.set_colors

	mva #>pm pmbase

	lda #0
	sta hposp0
	sta hposp1
	sta hposp2
	sta hposp3
	sta hposm0
	sta hposm1
	sta hposm2
	sta hposm3

	sta sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	sta sizem

	jsr frame.vbi
	jsr game.vbi.immediate

	mva #$21 prior
	mva #3 gractl

; Future DLIs
	jsr frame.eyes.dli

wait0	lda vcount
;	sta colbk
	cmp #$1c
	bne wait0

	jsr frame.weapons.dli

wait1	lda vcount
;	sta colbk
	cmp #$24
	bne wait1
	mva #0 colbk

	jsr frame.ammo.dli

wait2	lda vcount
;	sta colbk
	cmp #$28
	bne wait2
	mva #0 colbk

	jsr frame.power.dli

wait3	lda vcount
;	sta colbk
	cmp #$2b
	bne wait3
	mva #0 colbk

	jsr game.dli
	jsr game.vbi.deferred
	
	rts

	.endp			;End of vbi


	.local dl			;Main DL
	.byte $70,$70,$70
	.byte $4e, a(frame.sm.top)
:62	.byte $0e
dl_adr = *+1
	.byte $81,a($ffff)		;With DLI

frame_end
	.byte $4e, a(frame.sm.bottom)
:6	.byte $0e
	.byte $41, a(dl)
	.endl

	m_assert_same_1k dl

;===============================================================

	.echo "Starting frame"
	icl "HawkeyeTunetro-Frame.asm"
	icl "HawkeyeTunetro-SLF.asm"
	icl "HawkeyeTunetro-SLF-Weapon.asm"

;===============================================================

	icl "HawkeyeTunetro-Text.asm"

	icl "HawkeyeTunetro-Game.asm"
	
	.endp				;End of main_screen
