;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=HawkeyeTunetro.asm

	.proc frame			;Frame screen

	.proc init
	mwa #pm p1
	ldx #8
	jsr system.clear_pages

	lda #$00
	sta frame_state.chroma
	sta frame_state.color1
	sta frame_state.color2
	sta frame_state.color3

	jsr eyes.init

	jsr score.print_digits
	jsr weapons.init
	jsr ammo.init
	jsr power.init
	rts
	.endp


	.proc fade

	.proc fade_in
	mva #0 x1
loop	ldx x1
	cpx #.len luma_offset
	beq done
	lda luma_offset,x
	jsr set_luma
	m_wait 2
	inc x1
	jmp loop
done	rts
	.endp

	.proc fade_out
	mva #0 power.power_active

	mva #[.len luma_offset-1] x1
loop	ldx x1
	lda luma_offset,x
	jsr set_luma

	lda weapons.color1
	jsr fade_color
	sta weapons.color1

	lda weapons.color2
	jsr fade_color
	sta weapons.color2

	lda ammo.ammo_count
	and #15
	jsr fade_color
	sta ammo.ammo_count

	ldx #.len power.level_color-1
power_loop
	lda power.level_color,x
	jsr fade_color
	sta power.level_color,x
	dex
	bpl power_loop

	m_wait 2
	dec x1
	bpl loop
done	mva #0 weapons.weapons_active
	rts
	.endp

	.proc fade_color		;Fade color to maximum of frame_state.luma
	pha
	and #$f0
	sta chroma
	pla
	and #$0f
	cmp frame_state.luma
	bcc still_bright
	lda frame_state.luma
	beq no_chroma
still_bright
chroma = *+1
	ora #$00
no_chroma
	rts
	.endp

	.local luma_offset
	.byte 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,30,31
	.byte 32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51,52,53,54,55
	.byte 55,54,53,52,51,50,49,48,47,46,45,44,43,42,41,40,39,38,37,36,35,34,33,32
	.endl

	.endp

	.proc set_luma		;IN: <A>=luma (0 to 2*fade_luma.length)

	sec
	sbc #fade_luma.length
	sta luma_ptr
	ldx #2
loop	lda luma_offset,x
	clc
luma_ptr = *+1
	adc #0
	bpl positive
	lda #0
	jmp set_color
positive
	cmp #fade_luma.length
	scc
	lda #fade_luma.length-1
set_color
	tay
	lda fade_luma,y
	seq
	ora frame_state.chroma
	sta frame_state.color1,x
	dex
	bpl loop
	
	lda frame_state.color3
	and #15
	sta frame_state.luma
	rts

luma_offset	.byte 2*4,4*4,6*4

	.endp
	
	.proc set_colors
	mva frame_state.color1 colpf0
	mva frame_state.color2 colpf1
	mva frame_state.color3 colpf2
	rts
	.endp

	.proc vbi

	jsr eyes.vbi
	jsr ammo.vbi
	jsr power.vbi
	rts
	.endp

	.proc dli			;DLI at screen bottom
	pha
;	mva #$37 colbk
	jsr set_colors
	pla
	rti
	.endp

	.local frame_state
chroma	.byte $00
luma	.byte $00		;Max luma

color1	.byte $00
color2	.byte $00
color3	.byte $00
	.endl

;===============================================================

	.proc eyes		;Hawkeyes

eyes_active	.byte $00
eye_active	.byte $00
eye_flash	.byte $00

	.proc init
	ldx #.len eyes.left.pmg.p0-1
loop	mva eyes.left.pmg.p0,x pm+$400+eyes.ypos,x
	mva eyes.left.pmg.p1,x pm+$500+eyes.ypos,x
	mva eyes.right.pmg.p2,x pm+$600+eyes.ypos,x
	mva eyes.right.pmg.p3,x pm+$700+eyes.ypos,x
	dex
	bpl loop
	
	mva #0 eyes_active
	mva #0 eyes.left.flash
	sta eyes.right.flash 
	rts

	.endp

	.proc vbi

	jsr animate			;Set frame colors by default

;	lda eyes_active
;	beq not_active
;
;	lda eye_flash
;	bne no_test
;	lda random
;	cmp #3
;	bcs no_test
;	lda random
;	and #1
;	jsr set_eye_active
;no_test
;not_active
	rts

	.endp

	.proc set_eye_active
	sta eye_active
	mva #1 eye_flash
	rts
	.endp

	.proc animate
	lda frame_state.color2	;Set frame colors for both eyes
	sta eyes.left.color1
	sta eyes.right.color1
	lda frame_state.color3
	sta eyes.left.color2
	sta eyes.right.color2

	lda eye_flash
	beq no_flash		;Do no animate if zero
	and #127
	lsr
	cmp #tab_size*2
	bcc set_color

	lda #0
	beq no_reverse
set_color			;Set flash colors for active eye
	cmp #tab_size
	bcc no_reverse
	eor #$ff
	adc #tab_size*2-1
no_reverse
	tax
	ldy eye_active
	jsr set_eye_color

	inc eye_flash
no_flash
	rts

	.proc set_eye_color		;IN: <X>=color index, 0 is default; <Y>=eye (0,1)
	lda offset,y
	tay
	lda frame_state.chroma
	and chroma_tab,x
	pha
	ora luma1_tab,x
	sta eyes.left.color1,y
	pla
	ora luma2_tab,x
	sta eyes.left.color2,y
	rts

offset	.byte left.color1-left.color1, right.color1-left.color1
	.endp

	tab_size = .len chroma_tab

	.local chroma_tab
	.byte $f0,$f0,$f0,$f0,$00,$00,$00,$00,$00,$00,$00,$00,$00
	.endl

	.local luma1_tab
	.byte $08,$0a,$0c,$0e,$0e,$0c,$0a,$08,$06,$04,$02,$00,$00
	.endl
	.local luma2_tab
	.byte $0c,$0c,$0c,$0e,$0e,$0c,$0a,$08,$06,$04,$02,$00,$00
	.endl

	.endp				;End of animate

	.proc dli
	pha
	mva #eyes.left.xpos hposp0
	sta hposp1
	mva eyes.left.color1 colpm0
	mva eyes.left.color2 colpm1

	mva #eyes.right.xpos hposp2
	sta hposp3
	mva eyes.right.color1 colpm2
	mva eyes.right.color2 colpm3
	pla
	rts
	.endp

ypos	= $31
	.local left
xpos	= $35

flash	.byte 0

color1	.byte $00
color2	.byte $00

	.local pmg
	.local p0
	.byte %00100000
	.byte %01000000
	.byte %11001000
	.byte %01011100
	.byte %01111100
	.byte %00110000
	.byte %00001000
	.endl
	.local p1
	.byte %00000000
	.byte %10000000
	.byte %00000000
	.byte %10000000
	.byte %00000000
	.byte %01001000
	.byte %00110000
	.endl
	.endl

	.endl
	
	.local right
xpos	= $c3

flash	.byte 0

color1	.byte $00
color2	.byte $00
	.local pmg
	.local p2
	.byte %00000100
	.byte %00000010
	.byte %00010011
	.byte %00111010
	.byte %00111110
	.byte %00001100
	.byte %00010000
	.endl
	.local p3
	.byte %00000000
	.byte %00000001
	.byte %00000000
	.byte %00000001
	.byte %00000000
	.byte %00010010
	.byte %00001100
	.endl
	.endl

	.endl

	.endp			;End of eyes

;===============================================================

	.proc score		;Frame score

	.proc init_digits
	lda #0
	.rept [.len digits]
	sta digits+#
	.endr
	rts
	.endp
	
	.proc print_digits

	mva #0 x1
	mwa #frame.sm+4*320+15 p1
loop	ldx x1
	cpx #[.len digits]
	beq done
	lda digits,x
	asl
	asl
	asl
	tax
	ldy #40*0
	mva charset+0,x (p1),y
	ldy #40*1
	mva charset+1,x (p1),y
	ldy #40*2
	mva charset+2,x (p1),y
	ldy #40*3
	mva charset+3,x (p1),y
	ldy #40*4
	mva charset+4,x (p1),y
	ldy #40*5
	mva charset+5,x (p1),y
	ldy #40*6
	mva charset+6,x (p1),y
	ldy #<[40*7]
	inc p1+1
	mva charset+7,x (p1),y
	dec p1+1
	inc x1
	inc p1
	bne loop
done	rts
	.endp
	
	.proc count_up
	ldx #.len digits-1
loop	inc digits,x
	lda digits,x
	cmp #10
	bne done
	mva #0 digits,x
	dex
	bpl loop
done	jsr print_digits
	rts
	.endp

	.local digits
	.byte 0,0,0,0,0
	.endl

	.local charset
	ins "../gfx/frame/Hawkeye-Frame-Numbers.chr"
	.endl

	.endp				;End of score

;===============================================================
	.proc weapons
weapon_count = 5
xpos	= $54
ypos	= $39

ypos_belt	= ypos+11

weapons_active	.byte 0


color1	.byte $00
color2	.byte $00

	.proc init
	mva #0 weapons_active

	mva #$02 color1
	mva #$04 color2
	rts
	.endp

	.proc set_weapons_active
	mva #1 weapons_active
	mva #0 ammo.ammo_count
	rts
	.endp

	.proc dli
	pha
	lda #xpos
	sta hposp0
	sta hposp1
	lda #xpos+8
	sta hposp2
	sta hposp3
	
	lda color1
	sta colpm0
	sta colpm2
	lda color2
	sta colpm1
	sta colpm3
	pla
	rts
	.endp

	.proc print_weapon		;IN: slf_weapon_state.weapon
	ldx slf_weapon.slf_weapon_state.weapon
	ldy pmg.offset,x
	ldx #pmg.weapon_height-1
loop	mva pmg+pmg.height*0,y pm+$400+ypos,x
	mva pmg+pmg.height*1,y pm+$500+ypos,x
	mva pmg+pmg.height*2,y pm+$600+ypos,x
	mva pmg+pmg.height*3,y pm+$700+ypos,x
	dey
	dex
	bpl loop
	rts

	.local pmg

weapon_height = 9
height	= weapon_count*weapon_height

	ins "../gfx/frame/Hawkeye-Frame-Weapons.pm"

offset	.byte [weapon_height*1]-1,[weapon_height*2]-1,[weapon_height*3]-1,[weapon_height*4]-1,[weapon_height*5]-1
	.endl

	.endp
	
	.proc print_belt		;IN: weapon_active, weapon_level
	ldx slf_weapon.slf_weapon_state.weapon
	ldy slf_weapon.slf_weapon_state.weapon_level,x
	ldx #1
loop	mva pmg.p0,y pm+$400+ypos_belt,x
	mva pmg.p1,y pm+$500+ypos_belt,x
	mva pmg.p2,y pm+$600+ypos_belt,x
	mva pmg.p3,y pm+$700+ypos_belt,x
	dex
	bpl loop
	rts
	
	.local pmg	
p0	.byte $00,$00,$40,$40,$50,$50,$54,$54,$55,$55,$55,$55,$55
p1	.byte $00,$80,$80,$a0,$a0,$a8,$a8,$aa,$aa,$aa,$aa,$aa,$aa
p2	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$40,$40,$50
p3	.byte $00,$00,$00,$00,$00,$00,$00,$00,$00,$80,$80,$a0,$a0
	.endl
	
	.endp
	
	.endp				;End of weapons

;===============================================================

	.proc ammo			;Ammunition meter

xpos	= $46
ypos	= $4a

ammo_count	.byte 0

	.local ammo_color
	.byte $00,$00,$00
	.endl

	.proc init

	lda #%11000000
	ldx #2
loop	sta pm+$400+ypos,x
	sta pm+$500+ypos,x
	sta pm+$600+ypos,x
	dex
	bpl loop
	rts
	.endp

	.proc vbi
	ldx #.len ammo_color-1
loop
	lda weapons.weapons_active
	beq set_color
	lda slf_weapon.slf_weapon_state.weapon_level+2,x
	beq set_color
	lda ammo_count
	and #31
	cmp #16
	scc
	eor #31
set_color
	sta ammo_color,x
	dex
	bpl loop
	inc ammo_count
	rts
	.endp

	.proc dli
	pha
	mva #xpos+0 hposp0
	mva #xpos+3 hposp1
	mva #xpos+6 hposp2

	mva ammo_color+0 colpm0
	mva ammo_color+1 colpm1
	mva ammo_color+2 colpm2
	pla
	rts
	.endp

	.endp
;===============================================================

	.proc power			;Power meter

xpos	= $99
ypos	= $52

max_level = 6

max_phase_cnt = $300

power_active .byte 0
level	.byte 0
phase_step .word 0
phase_cnt .word 0	;>=$80 flashes
flash_cnt .byte 0

	.local level_xpos
	.byte xpos,xpos+4,xpos+8,xpos+12,xpos+16,xpos+20,xpos+24
	.endl

	.local level_color_presets
	.byte $36,$36,$fa,$fa,$c8,$c8,$c7
	.endl

	.local level_color
	.byte $00,$00,$00,$00,$00,$00,$00
	.endl

	.local level_pm1
	.byte %11000000,%11001100,%11001100,%11001100,%11001100,%11001100,%11001100
	.endl

	.local level_pm2
	.byte %00000000,%00000000,%11000000,%11001100,%11001100,%11001100,%11001100
	.endl

	.local level_pm3
	.byte %00000000,%00000000,%00000000,%00000000,%11000000,%11001100,%11001100
	.endl

flash_xpos	.byte $00
flash_color	.byte $00

	.proc init
	ldy #2
	lda #%11000000
	sta:rpl pm+$400+ypos,y-

	ldx #.len level_color_presets
	mva:rpl level_color_presets,x level_color,x-

	mva #0 power_active
	mva #-1 level
	lda #0
	jsr set_phase_cnt
	mwa #0 phase_step
	jsr print_level
	rts
	.endp

	.proc set_phase_cnt		;IN: <A>=>phase_count
	sta phase_cnt+1
	lda #0
	sta phase_cnt
	sta flash_cnt
	rts
	.endp

	.proc print_level
	ldx level
	spl
	ldx #0
	ldy #2
loop	mva level_pm1,x pm+$500+ypos,y
	mva level_pm2,x pm+$600+ypos,y
	mva level_pm3,x pm+$700+ypos,y
	dey
	bpl loop
	rts
	.endp

	.proc vbi
	lda power_active
	beq not_active
	ldx level
	bmi empty
	lda level_xpos,x
	sta flash_xpos

	lda phase_cnt+1
	beq low
	lda level_color,x
	jmp not_low
low	lda flash_cnt
	and #31
	cmp #16
	scc
	eor #31
	inc flash_cnt
not_low	sta flash_color
	
	adw phase_cnt phase_step

	lda phase_step
	ora phase_step+1
	beq no_change

	lda phase_cnt+1
	bpl no_decrement_level
	lda #>max_phase_cnt
	jsr set_phase_cnt
	dec level
	bmi empty
	jsr print_level
no_decrement_level

no_change
empty
	rts
not_active
	sta flash_color
	rts
	.endp

	.proc dli
	pha
	mva #1 prior
	mva flash_xpos hposp0
	mva flash_color colpm0
	mva #xpos+0 hposp1
	mva level_color+0 colpm1
	mva #xpos+8 hposp2
	mva level_color+2 colpm2
	mva #xpos+16 hposp3
	mva level_color+4 colpm3
	pla
	rts
	.endp
	
	.endp				;End of power

;	m_align $400
	.local sm
top	ins "../gfx/frame/Hawkeye-Frame.pic",+0,8*320-40		;Leave out last line for JMP with DLI
bottom	ins "../gfx/frame/Hawkeye-Frame.pic",+[24*320+40],1*320-40	;Leave out first line for JMP with DLI
	.endl

	m_assert_same_4k sm
	.endp				;End of frame
