;
;	>>> Hawkeye Tunetro by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE
;
;	@com.wudsn.ide.asm.mainsourcefile=HawkeyeTunetro.asm

	.proc effects

	.macro m_delay_patterns
	lda #:1
	jsr synchronization.delay_patterns
	.endm

;test	jsr fade_picture_screen.fade_in
;	jsr keyboard.wait_for_key_pressed
;	jsr fade_picture_screen.fade_out
;	jsr keyboard.wait_for_key_pressed
;	jmp test

	jsr fade_main_screen.fade_prelude
	jmp after_prelude

effect_loop
	jsr fade_main_screen.fade_in
after_prelude
	jsr fade_main_screen.fade_text_section
	jsr fade_main_screen.fade_out
	jsr fade_picture_screen.fade_in
	lda #4
	jsr keyboard.delay_patterns_or_key_pressed
	jsr fade_picture_screen.fade_out
	jmp effect_loop

;==========================================================


;==========================================================


	.proc fade_main_screen
	
	.proc fade_prelude

	m_wait 220
	
	lda #0
	jsr screens.main_screen.text.fade_in

	lda #$05	;$0b
	jsr synchronization.wait_for_pattern

	mva #$60 screens.main_screen.frame.frame_state.chroma
	jsr screens.main_screen.frame.fade.fade_in

	lda #$07	;13
	jsr synchronization.wait_for_pattern
	
	jsr fade_game.fade_prelude
	rts
	.endp

	.proc fade_in
	jsr screens.main_screen.init

	lda #0
	jsr screens.main_screen.text.fade_in
	lda #1
	jsr keyboard.delay_patterns_or_key_pressed
repeat	lda random
	and #$f0
	beq repeat
	cmp screens.main_screen.frame.frame_state.chroma
	beq repeat
	sta screens.main_screen.frame.frame_state.chroma
	jsr screens.main_screen.frame.fade.fade_in
	jsr fade_game.fade_in
	rts
	.endp

	.proc fade_out

slf_in_motion
	lda screens.main_screen.slf.slf_state.motion
	cmp #screens.main_screen.slf.motion_type.standing
	bne slf_in_motion
	mva #0 screens.main_screen.slf.slf_state.controller_active

weapon_in_motion
	lda screens.main_screen.slf_weapon.slf_weapon_state.active
	bne weapon_in_motion

	jsr screens.main_screen.slf.init_motion_waiting
	m_wait 50

	jsr fade_game.fade_slf.fade_out
	m_delay_patterns 1
	jsr screens.main_screen.frame.fade.fade_out
	m_delay_patterns 1
	lda #0
	jsr screens.main_screen.text.fade_out
	m_delay_patterns 1
	rts
	.endp

;==========================================================

	.proc fade_text_section
	jsr screens.main_screen.text.print_next_text_lines

;Set limit for SLF to run left
	lda screens.main_screen.text.text_length
	asl
	asl
	add #screens.main_screen.slf.xpos_min_limit+8
	sta screens.main_screen.slf.slf_state.xpos_min

;       Ensure SFL is not too far left
wait_run_away
	lda screens.main_screen.slf.slf_state.xpos
	cmp screens.main_screen.slf.slf_state.xpos_min
	bcc wait_run_away
	lda #1
	jsr screens.main_screen.text.fade_in

wait_for_hit
	lda screens.main_screen.slf_weapon.slf_weapon_state.active
	bne keep_weapon
	lda cnt
	bne keep_weapon
	jsr screens.main_screen.slf_weapon.select_random_weapon
keep_weapon
	lda screens.main_screen.text.mxpf
	beq wait_for_hit

	jsr screens.main_screen.frame.score.count_up
	lda #1
	jsr screens.main_screen.text.fade_out
	
	jsr screens.main_screen.slf_weapon.select_random_weapon

	jsr fade_game.recharge_weapons_if_needed
	lda screens.main_screen.text.text_marker
	cmp #screens.main_screen.text.line_end
	beq fade_text_section
	rts
	.endp

;==========================================================

	.proc fade_game

	.proc fade_prelude	;Dramatic first round

	mva #173 screens.main_screen.slf.slf_state.xpos
	jsr fade_slf.fade_in_and_out

	mva #56 screens.main_screen.slf.slf_state.xpos
	jsr fade_slf.fade_in_and_out
	
	mva #100 screens.main_screen.slf.slf_state.xpos
	jsr fade_slf.fade_in_and_out
	jmp fade_in
	.endp

	.proc fade_in		;Fast fade in after first round

	mva #160 screens.main_screen.slf.slf_state.xpos
	jsr fade_slf.fade_in

	m_delay_patterns 1

	lda #$18
	jsr power_up
	m_wait 50
	lda #10
	ldx #2
	jsr charge_weapons

	jsr screens.main_screen.slf.demo.init_demo_mode
	mva #1 screens.main_screen.slf.slf_state.controller_active
	mwa #-1 screens.main_screen.frame.power.phase_step
	rts
	.endp

	.proc fade_slf
count	= 10

	.proc fade_in_and_out
	jsr fade_in	
	m_delay_patterns 1
	jsr fade_out
	rts
	.endp

	.proc fade_in
	ldx #count
loop
	mva #1 screens.main_screen.slf.slf_state.display_active
	m_wait 1
	mva #0 screens.main_screen.slf.slf_state.display_active
	txa
	asl
	jsr wait
	dex
	bne loop 
	mva #1 screens.main_screen.slf.slf_state.display_active
	rts
	.endp

	.proc fade_out
	ldx #1
loop
	mva #0 screens.main_screen.slf.slf_state.display_active
	txa
	asl
	jsr wait
	mva #1 screens.main_screen.slf.slf_state.display_active
	m_wait 1
	inx
	cpx #count
	bne loop 
	mva #0 screens.main_screen.slf.slf_state.display_active
	rts
	.endp
	
	.endp

;==========================================================

	.proc power_up			;IN: <A>=speed, default 3
	sta screens.main_screen.frame.power.phase_step
	mva #0 screens.main_screen.frame.power.phase_step+1
	mva #1 screens.main_screen.frame.power.power_active
	ldx #0
loop
	stx screens.main_screen.frame.power.level
	lda #0
	jsr screens.main_screen.frame.power.set_phase_cnt
	jsr screens.main_screen.frame.power.print_level

wait	lda screens.main_screen.frame.power.phase_cnt+1
	cmp #>screens.main_screen.frame.power.max_phase_cnt
	bne wait

	inx
	cpx #screens.main_screen.frame.power.max_level+1
	bne loop

	mwa #0 screens.main_screen.frame.power.phase_step
	rts
	.endp

;==========================================================

	.proc charge_weapons	;IN: <A>=delay1 (50), <X>=delay2 (5)
weapon = x1
weapon_level = x2
delay1	= x3
delay2	= x4
	sta delay1
	stx delay2
	jsr screens.main_screen.frame.weapons.set_weapons_active
	mva #1 weapon
loop_weapon
	lda weapon
	cmp #screens.main_screen.frame.weapons.weapon_count
	beq weapon_done
	jsr screens.main_screen.slf_weapon.select_weapon
	lda delay1
	jsr wait
	mva #0 weapon_level
loop_weapon_level
	ldx weapon
	lda weapon_level
	cmp #screens.main_screen.slf_weapon.slf_weapon_state.max_weapon_level+1
	beq weapon_level_done
	jsr screens.main_screen.slf_weapon.set_weapon_level
	lda delay2
	jsr wait
	inc weapon_level
	jmp loop_weapon_level

weapon_level_done
;	lda delay1
;	cmp #51
;	bcc no_delay3
;	m_delay_patterns 1
;no_delay3
	inc weapon
	jmp loop_weapon

weapon_done
	lda #1
	jsr screens.main_screen.slf_weapon.select_weapon
	rts
	.endp

;==========================================================

	.proc recharge_weapons_if_needed
;	Recharge?
	lda screens.main_screen.slf_weapon.slf_weapon_state.weapon_level+screens.main_screen.slf_weapon.weapon_type.heavy1
	ora screens.main_screen.slf_weapon.slf_weapon_state.weapon_level+screens.main_screen.slf_weapon.weapon_type.heavy1
	ora screens.main_screen.slf_weapon.slf_weapon_state.weapon_level+screens.main_screen.slf_weapon.weapon_type.heavy1
	bne no_recharge

;	Not while we're running
	lda screens.main_screen.slf.slf_state.motion
	bne in_motion

	mva #0 screens.main_screen.slf.slf_state.controller_active
	
	lda #10
	ldx #2
	jsr charge_weapons
	mva #1 screens.main_screen.slf.slf_state.controller_active
in_motion
no_recharge
	rts
	.endp
	
	.endp			;End of fade_game

	.endp			;End of fade_main_screen
;==========================================================

	.proc fade_picture_screen

	.proc fade_in
	mwa #screens.picture_screen.vbi nmi.vbi.screen_ptr
	jsr screens.picture_screen.fade_in
	rts
	.endp

	.proc fade_out
	jsr screens.picture_screen.fade_out
	rts
	.endp
	.endp

;==========================================================

	.proc keyboard

	.proc delay_patterns_or_key_pressed	;IN: <A>=patterns
	tax
loop	ldy sound.track_line_count
wait	jsr check_key
	beq stop
	cpy sound.track_line_count
	beq wait
	dex
	bne loop

stop	jsr wait_for_key_released
	rts
	.endp

	.proc wait_for_key_pressed
loop	jsr check_key
	bne loop
	rts
	.endp

	.proc wait_for_key_released
loop	jsr check_key
	beq loop
	rts
	.endp

	.proc check_key		; OUT: Z=0 is pressed, Z=1 is not pressed
	lda trig0		; FIRE #0
	and trig1		; FIRE #1
	beq stop

	lda consol		; START/OPTION/SELECCT
	and #7
	cmp #7
	beq skip
	lda #0
	beq stop
skip
	lda skctl		; ANY REGULAR KEY
	and #$04
	beq stop

	lda skctl		; ANY SHIFT/CONTROL KEY
	and #$08
	beq stop
stop	rts
	.endp
	
	.endp			;End of keyboard

;==========================================================

	.proc synchronization

	.proc wait_for_pattern	;IN: <A>=number of pattern
wait	cmp sound.track_line_count
	bne wait
	rts
	.endp

	.proc delay_patterns	;IN: <A>=number of patterns
	sta delay_cnt
loop	lda sound.track_line_count
wait	cmp sound.track_line_count
	beq wait
	dec delay_cnt
	bne loop
	rts
delay_cnt	.byte 0
	.endp
	
	.endp


	.endp			;End of effects	
