;
;	>>> Hawkeye Tunetro Atari 50 Logo by JAC! <<<
;
;	(c) 2022 by JAC! for  Silly Venture 2k22 SE

	icl "HawkeyeTunetro-Kernel-Equates.asm"

	org $a000

fade_delay = 2

color	= $80

pm	 = $9c00

	.proc loader
	jsr screen.fade_down
	jsr screen.init
	jsr screen.fade_up
	lda #25
	jsr wait
	mva #1 screen.vbi.heart_flag
	mva #0 soundr			;No SIO noise from here on
	rts

;===============================================================

	.proc screen
	
	.proc init
	mwa #dl sdlstl
	mva #$2d sdmctl
	lda #1
	jsr wait
	mva #3 sizep0
	sta sizep1
	sta sizep2
	sta sizep3
	mva #$40 hposp0
	mva #$40+$20*1 hposp1
	mva #$40+$20*2 hposp2
	mva #$40+$20*3 hposp3

	mva #$11 gprior
	mva #3 gractl
	lda #0
	sta pcolor0
	sta pcolor1
	sta pcolor2
	sta pcolor3
	sta color0
	sta color1
	sta color2
	sta color3

	lda #$ff
	
black_offset1 = $08
	ldx #$22
fill_pm1
	sta pm+$200+black_offset1,x
	sta pm+$200+black_offset1+$80*1,x
	sta pm+$200+black_offset1+$80*2,x
	sta pm+$200+black_offset1+$80*3,x
	dex
	bpl fill_pm1

black_offset2 = $68
	ldx #$17
fill_pm2
	sta pm+$200+black_offset2,x
	sta pm+$200+black_offset2+$80*1,x
	sta pm+$200+black_offset2+$80*2,x
	sta pm+$200+black_offset2+$80*3,x

	dex
	bpl fill_pm2

	mva #>pm pmbase
	
	mva #$00 nmien
	mwa #vbi.immediate vvblki
	mwa #vbi.deferred  vvblkd
	mva #$40 nmien 
	rts
	.endp

	.proc vbi
heart_flag = *+1
	.proc immediate
	lda #0
	beq no_heart

heart_cnt = *+1
	lda #0
	and #31
	cmp #16
	bne no16
	mvx #8 consol
	mvx #0 consol
no16
	bcc less
	eor #31
less	ora #$30
	sta color3
	sta colpf3		;In case CRITIC=1

	inc heart_cnt
no_heart
	jmp sysvbv
	.endp
	
	.proc deferred
	lda color3
	lsr
	lsr
	lsr
	and #1
pm_flag = *+1
	cmp #1
	beq no_heart
	sta pm_flag
	cmp #1
	beq big_heart

pm_m 	    = pm+$180+$44
heart_hpos0 = $95
heart_hpos1 = heart_hpos0-4
	opt r+

little_heart
	mva #$00 sizem
	mva #%00000000 pm_m+0
	mva #%00000000 pm_m+1
	mva #%00000000 pm_m+10
	mva #%00000000 pm_m+11
	mva #%00000000 pm_m+12
	mva #%00000000 pm_m+13
	mva #%00000000 pm_m+2
	mva #%00010000 pm_m+9
	mva #%00111000 pm_m+8
	mva #%01101100 pm_m+3
	mva #%01111100 pm_m+7
	mva #%11111110 pm_m+4
	mva #%11111110 pm_m+5
	mva #%11111110 pm_m+6
	mva #heart_hpos0+2*0 hposm3
	mva #heart_hpos0+2*1 hposm2
	mva #heart_hpos0+2*2 hposm1
	mva #heart_hpos0+2*3 hposm0
no_heart
	jmp xitvbv

big_heart
	mva #$55 sizem
	mva #heart_hpos1+4*0 hposm3
	mva #heart_hpos1+4*1 hposm2
	mva #heart_hpos1+4*2 hposm1
	mva #heart_hpos1+4*3 hposm0
	mva #%00010000 pm_m+12
	mva #%00010000 pm_m+13
	mva #%00111000 pm_m+10
	mva #%00111000 pm_m+11
	mva #%01101100 pm_m+0
	mva #%01101100 pm_m+1
	mva #%01111100 pm_m+8
	mva #%01111100 pm_m+9
	mva #%11111110 pm_m+2
	mva #%11111110 pm_m+3
	mva #%11111110 pm_m+4
	mva #%11111110 pm_m+5
	mva #%11111110 pm_m+6
	mva #%11111110 pm_m+7
	jmp xitvbv
	.endp			;End of deferred

	
	.endp			;End of vbi

	.proc fade_up
	ldx #0
loop	mva colors.color0,x color0
	mva colors.color1,x color1
	mva colors.color2,x color2
	lda #fade_delay*2
	jsr wait
	inx
	cpx #.len colors.color0
	bne loop
	rts

	.local colors
	.local color0
	.byte $00,$02,$04,$06,$08,$0a,$0c,$0e,$fe,$fc,$fa,$f8,$f6
	.endl
	.local color1
	.byte $00,$02,$04,$06,$08,$0a,$0c,$0e,$0e,$0e,$0e,$0e,$0e
	.endl
	.local color2
	.byte $00,$02,$04,$06,$08,$0a,$0c,$0e,$fe,$fc,$fa,$fa,$fa
	.endl
	.endl
	.endp

	.proc fade_down
fade_loop
	ldy #0
	ldx #9
color_loop
	lda color0,x
	and #$0f
	beq store
	ldy #1
	lda color0,x
	pha
	and #$f0
	sta color
	pla
	and #$0f
	sec
	sbc #1
	ora color
store	sta color0,x
	dex
	bpl color_loop
	lda #fade_delay
	jsr wait
	tya
	bne fade_loop
	.endp
	
	.endp			;End of screen

;===============================================================

	.proc wait
	clc
	adc rtclok+2
loop	cmp rtclok+2
	bne loop
	rts
	.endp

;===============================================================

;	.align $400

	.local dl
:1	.byte $70
	.byte $4f,a(sm.logo_atari)
:69	.byte $0f
	.byte $30
	.byte $4e,a(sm.logo_50)
:114	.byte $0e
:1	.byte $30
	.byte $4f,a(sm.logo_atari+32*70)
:1	.byte $0f,$0f,$0f,$0f,$0f,$0f,$0f,$00
	.byte $0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$00
	.byte $0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f,$00
	.byte $0f,$0f,$0f,$0f,$0f,$0f,$0f,$0f
	.byte $41,a(dl)
	.endl
	
	.local sm

;	.align $1000
	.local logo_atari
	ins "../gfx/atari50/logo-atari.pic"
	.endl

	.align $1000
	.local logo_50
	ins "../gfx/atari50/logo-50.pic"
	.endl

	.endl

	m_info sm

	.endp

	ini loader

	m_info loader