package com.wudsn.productions.atari800.badapplehd;

import java.util.Map;
import java.util.TreeMap;
import java.util.Map.Entry;

public final class TileSet {
    private int bytesPerTile;
    private Map<Tile, Integer> usedTiles;

    public TileSet(int bytesPerTile) {
	this.bytesPerTile = bytesPerTile;
	usedTiles = new TreeMap<Tile, Integer>();
	Tile emptyTile = new Tile(new byte[bytesPerTile], 0, bytesPerTile);
	usedTiles.put(emptyTile, Integer.valueOf(0));
    }

    /**
     * Copy constructor for backtracking.
     * 
     * @param tileSet
     *            The source tile set, not <code>null</code>.
     */
    public TileSet(TileSet tileSet) {

	this(tileSet.bytesPerTile);
	usedTiles.putAll(tileSet.usedTiles);
    }

    public int getBytesPerTile() {
	return bytesPerTile;
    }

    public int getSize() {
	return usedTiles.size();
    }

    public int addTile(Tile tile) {
	if (tile == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'tile' must not be null.");
	}
	Integer tileNumber = usedTiles.get(tile);
	if (tileNumber == null) {
	    tileNumber = Integer.valueOf(usedTiles.size());
	    usedTiles.put(tile, tileNumber);
	}
	return tileNumber.intValue();
    }

    public void addTiles(TileSet tileSet) {
	if (tileSet == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'tileSet' must not be null.");
	}
	for (Tile tile : tileSet.usedTiles.keySet()) {
	    addTile(tile);
	}
    }

    public int getTileNumber(Tile tile) {
	if (tile == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'tile' must not be null.");
	}
	Integer tileNumber = usedTiles.get(tile);
	if (tileNumber == null) {
	    throw new IllegalArgumentException("Tile is not in this tile set");
	}
	return tileNumber.intValue();
    }

    public byte[] getTilesAsBytes() {
	// Convert tile graphics to charsets.
	int usedTileCount = getSize();
	byte[] result = new byte[usedTileCount * bytesPerTile];
	for (Entry<Tile, Integer> entry : usedTiles.entrySet()) {
	    Tile tile = entry.getKey();
	    Integer tileNumber = entry.getValue();
	    System.arraycopy(tile.content, 0, result, tileNumber.intValue()
		    * bytesPerTile, bytesPerTile);
	}
	return result;
    }

}