package com.wudsn.productions.atari800.badapplehd;

public final class Tile implements Comparable<Tile> {
    public final byte[] content;

    public Tile(byte[] source, int offset, int size) {
	content = new byte[size];
	System.arraycopy(source, offset, content, 0, size);
    }

    @Override
    public int compareTo(Tile o) {
	if (content.length != o.content.length) {
	    throw new RuntimeException(
		    "Cannot compare tiles with different sizes");
	}
	for (int i = 0; i < content.length; i++) {
	    if (content[i] > o.content[i]) {
		return +1;
	    }
	    if (content[i] < o.content[i]) {
		return -1;
	    }
	}
	return 0;

    }
}