package com.wudsn.productions.atari800.badapplehd;

public final class Page {
    public final int sm;
    public final int chrtab;
    public final int chr;

    public byte[] lastScreenMemory;
    public int[] lastTileSetTable;

    public Page(int sm, int chrtab, int chr) {
	this.sm = sm;
	this.chrtab = chrtab;
	this.chr = chr;
	lastScreenMemory = null;
	lastTileSetTable = null;
    }

    public static Page createPageWithOffset(Page page, int offset) {
	if (page == null) {
	    throw new IllegalArgumentException(
		    "Parameter page must not be null.");
	}
	Page result = new Page(page.sm + offset, page.chrtab + offset, page.chr
		+ offset);
	return result;
    }

}