package com.wudsn.productions.atari800.badapplehd;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FrameSequence {
    public final Screen screen;
    public final Sound sound;
    public final List<Frame> frames;

    public FrameSequence(Screen screen, Sound sound) {
	if (screen == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'screen' must not be null.");
	}
	this.screen = screen;
	this.sound=sound;
	frames = new ArrayList<Frame>();
    }

    public void readFrom(DataInputStream screenDataInputStream, DataInputStream soundDataInputStream, int maxFrames)
	    throws IOException {
	try {
	    while (getSize() < maxFrames) {
		Frame frame = new Frame(this);
		frame.readFrom(screenDataInputStream, soundDataInputStream);
		addFrame(frame);

	    } // While
	} catch (EOFException eof) {

	    // OK
	} catch (IOException ex) {
	    throw ex;
	}
    }

    public void addFrame(Frame frame) {
	if (frame == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'frame' must not be null.");
	}
	frames.add(frame);
    }

    public int getSize() {
	return frames.size();
    }

}