package com.wudsn.gfx.avi;

import java.io.PrintStream;

public final class Log {
    private PrintStream os;
    private boolean details;

    public static Log create(PrintStream os, boolean details) {
	if (os == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'os' must not be null.");
	}
	Log instance = new Log();
	instance.os = os;
	instance.details = details;
	return instance;
    }

    public void printString(String key, String value) {
	os.print(key);
	os.print("=");
	os.print(value);
	os.print(" ");
    }

    public void printLong(String key, long value) {
	os.print(key);
	os.print("=");
	os.print(value);
	os.print(" ");
    }

    public void printLongHex(String key, long value) {
	os.print(key);
	os.print("=$");
	os.print(Long.toHexString(value));
	os.print("=");
	os.print(value);
	os.print(" ");
    }

    public void println() {
	os.println();
    }

    public void log(String message) {
	os.print(message);
	os.println();
    }

    public void logDetails(String message) {
	if (details) {
	    os.print(message);
	    os.println();
	}
    }
}
