package com.wudsn.gfx.avi;

import java.io.IOException;

import com.wudsn.gfx.avi.AVIReader.AVIHeader;
import com.wudsn.gfx.avi.AVIReader.CHUNK;

public class AVIFrameConverter {

    protected Log log;
    protected String outputFilePath;

    protected int frameCountSkip;
    protected int videoFrameCount;

    public AVIFrameConverter() {
    }

    /**
     * Initialize the consumer.
     * 
     * @param log
     *            The log, not <code>null</code>.
     * @param aviHeader
     *            The AVI header, not <code>null</code>.
     * @return The media audio chunk size, a positive integer.
     */
    public int init(Log log, AVIHeader aviHeader) {
	if (log == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'log' must not be null.");
	}
	if (aviHeader == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'aviHeader' must not be null.");
	}
	this.log = log;

	frameCountSkip = 0;

	return Integer.MAX_VALUE;
    }

    /**
     * Open the output file(s).
     * 
     * @param outputFilePath
     *            The output file path, not <code>null</code>.
     * @throws IOException
     *             If one of the output files cannot be opened.
     */
    public void open(String outputFilePath) throws IOException {
	if (outputFilePath == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'outputFilePath' must not be null.");
	}
	this.outputFilePath = outputFilePath;
    }

    public void close() {

    }

    /**
     * @throws IOException
     *             If case of an I/O error.
     */
    public void saveHeaders() throws IOException {
    }

    /**
     * @param imageChunksCount
     * @param imageChunk
     * @param audioChunksCount
     * @param audioChunk
     * @throws IOException
     *             If case of an I/O error.
     */
    public void consume(int imageChunksCount, CHUNK imageChunk,
	    int audioChunksCount, CHUNK audioChunk) throws IOException {
	if (imageChunk == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'imageChunk' must not be null.");
	}
	if (audioChunk == null) {
	    throw new IllegalArgumentException(
		    "Parameter 'audioChunk' must not be null.");
	}
    }

    public void logSummary() {

    }

}