#include <stdlib.h>
#include <time.h>
#include <SDL.h>
#include "c64pal.h"

// copy argc parser from /home/daniel/Dropbox/c64work/sid/sidid
#define SAVE 1
#define ZOOM 1
#define OLDDITHER 1
#define PIXX 320
#define PIXY 200
#define FPS 800
#define PIXS PIXX*PIXY
#define PIHX (PIXX/2)
#define PIHY (PIXY/2)
#define SCREENX (PIXX*ZOOM)
#define SCREENY (PIXY*ZOOM)
#define SCREEN_BPP 32
#define FPSms (1000/FPS)
#define SQR(X) ((X)*(X))
#define COLSIZ8 1000
#define COLSIZ4 500
#define SCRSIZ 1000
#define BMPSIZ 8000

#define FT_EOF 0
#define FT_NXT 1
#define FT_AUD 2
#define FT_COL 3
#define FT_VBM 4
#define FT_VSC 5
#define FT_VCH 6
#define FT_VCL 7

SDL_Surface *screen;
SDL_Event event;
uint8_t RGBM=0xff;   //-r [RGBMASK]
uint8_t FRAMEDIV=1;  //-f [FPS]
uint8_t DITHER=0;    //-d [DTHRESH]
uint8_t MCOL=1;      //-h for hires
uint8_t MONO=0;      //-m [MONOCO]
int YMUL=1;          //-y [YMULT]
int USEPEPTO=0;      //-p

int DTHRESH=256;    //
uint8_t MONOCO=0x80; //

int VIDX=160;
int VIDY=200;
int quit = 0;
int fr = 0;
int frameticks,startticks;
uint32_t pixbuf[PIXX*PIXY];
uint8_t framebuf[PIXX*PIXY*3]; //use PIXX instead of VIDX so
uint8_t nibblebuf[PIXX*PIXY];  //that MCOL can be an option
uint8_t c64bmp[BMPSIZ+1];
uint8_t c64scr[SCRSIZ+1];
uint8_t c64col[COLSIZ8+1];
uint8_t c64colp[COLSIZ4+1]; //packed color ram
uint8_t c64bmpo[BMPSIZ+1];
uint8_t c64scro[SCRSIZ+1];
uint8_t c64colo[COLSIZ4+1];
uint8_t outbuf[65536];

char movmagic[]="CV64PAL0";
uint16_t audsiz=312;
uint8_t audcyc=63;
uint8_t audcmp=0;
uint8_t regd011=0x3b;
uint8_t regd016;
uint8_t regd020=0;
uint8_t regd021=0;
uint8_t oldd021=0;
uint8_t vidlace=0;

uint16_t outbufptr;
char movie[256];
char audio[256];
FILE *f;
FILE *faud;
#if SAVE
char mov64[256];
FILE *fout;
#endif
int movfound = 0;
int isavi = 0;
int64_t leftread,movlen,movbeg,filesize,faudsize;
int readdone = 0;
char id[5];
uint32_t len;
uint8_t destpalyuv[16][3];
int error;
int pixcnt[16];
int pixcol[16];

uint8_t destpal[16][3];
/*
={ // colodore
  {0x00,0x00,0x00},{0xff,0xff,0xff},{0x81,0x33,0x38},{0x75,0xce,0xc8},
  {0x8e,0x3c,0x97},{0x56,0xac,0x4d},{0x2e,0x2c,0x9b},{0xed,0xf1,0x71},
  {0x8e,0x50,0x29},{0x55,0x38,0x00},{0xc4,0x6c,0x71},{0x4a,0x4a,0x4a},
  {0x7b,0x7b,0x7b},{0xa9,0xff,0x9f},{0x70,0x6d,0xeb},{0xb2,0xb2,0xb2}};
*/  
uint32_t screenpal[16];
/*
={ // colodore
  0x000000,0xffffff,0x813338,0x75cec8,0x8e3c97,0x56ac4d,0x2e2c9b,0xedf171,
  0x8e5029,0x553800,0xc46c71,0x4a4a4a,0x7b7b7b,0xa9ff9f,0x706deb,0xb2b2b2};
*/  
int dither2x2[4] = { 0, 32, 32,  0 };
int dither8x8[64] = {
     0, 32,  8, 40,  2, 34, 10, 42,   /* 8x8 Bayer ordered dithering  */
    48, 16, 56, 24, 50, 18, 58, 26,   /* pattern.  Each input pixel   */
    12, 44,  4, 36, 14, 46,  6, 38,   /* is scaled to the 0..63 range */
    60, 28, 52, 20, 62, 30, 54, 22,   /* before looking in this table */
     3, 35, 11, 43,  1, 33,  9, 41,   /* to determine the action.     */
    51, 19, 59, 27, 49, 17, 57, 25,
    15, 47,  7, 39, 13, 45,  5, 37,
    63, 31, 55, 23, 61, 29, 53, 21 };


void rgb2yuv(uint8_t r,uint8_t g,uint8_t b,uint8_t *y,uint8_t *cb,uint8_t *cr) {
  r&=RGBM;
  g&=RGBM;
  b&=RGBM;
  *y =(uint8_t)( 0.257*(double)r+0.504*(double)g+0.098*(double)b+ 16);
  *cb=(uint8_t)(-0.148*(double)r-0.291*(double)g+0.439*(double)b+128);
  *cr=(uint8_t)( 0.439*(double)r-0.368*(double)g-0.071*(double)b+128);
}

uint32_t inline __attribute__((always_inline)) getdist(uint8_t y1,uint8_t y2,uint8_t v1,uint8_t v2,uint8_t u1,uint8_t u2) {
  return(YMUL*SQR(y1-y2)+SQR(u1-u2)+SQR(v1-v2));
};

uint8_t find16(uint16_t px,uint16_t py,uint8_t r,uint8_t g,uint8_t b) {
  uint8_t y,u,v,my2,mv2,mu2,x,fnd=0,fnd2=0,colp;
  uint32_t tmpdist,fnddist=0xffffffff,fnddist2=0xffffffff;
  rgb2yuv(r,g,b,&y,&u,&v);
  for(x=0;x<16;x++) {
    tmpdist=getdist(destpalyuv[x][0],y,destpalyuv[x][1],u,destpalyuv[x][2],v);
#if OLDDITHER
    if (tmpdist<fnddist) { fnddist2=fnddist;fnd2=fnd;fnddist=tmpdist;fnd=x; } else
    if (tmpdist<fnddist2) { fnddist2=tmpdist;fnd2=x; };
#else   
    if (tmpdist<fnddist) { fnddist=tmpdist;fnd=x; };
#endif    
  }
  if (fnddist<DTHRESH) { fnddist2=0;fnd2=fnd; };
  if (DITHER) {
#if OLDDITHER==0
    for(x=0;x<16;x++) {
      rgb2yuv((destpal[x][0]+destpal[fnd][0])/2,(destpal[x][1]+destpal[fnd][1])/2,(destpal[x][2]+destpal[fnd][2])/2,&my2,&mu2,&mv2);
      tmpdist=getdist(my2,y,mu2,u,mv2,v);
      if (tmpdist<fnddist2) { fnddist2=tmpdist;fnd2=x; };
    };
#endif    
    rgb2yuv((destpal[fnd2][0]+destpal[fnd][0])/2,(destpal[fnd2][1]+destpal[fnd][1])/2,(destpal[fnd2][2]+destpal[fnd][2])/2,&my2,&mu2,&mv2);
    colp=(getdist(destpalyuv[fnd][0],y,destpalyuv[fnd][1],u,destpalyuv[fnd][2],v)<getdist(my2,y,mu2,u,mv2,v))?0:1;
    return(((((py&1)^(px&1))<colp)?fnd2:fnd));
  } else return(fnd);
}

void getid() {
  fread(&id,4,1,f);
  id[4]=0;
};

uint32_t getlen() {
  uint32_t l;
  fread(&l,4,1,f);
  return(l);
};

void findmovchunk() {
  movfound=0;isavi=1;
  getid(); if (strcmp(id,"RIFF")!=0) isavi=0;
  getid();
  getid(); if (strncmp(id,"AVI",3)!=0) isavi=0;
  if (isavi) {
    do {
      getid();
      if (strcmp(id,"LIST")==0) {
        len=getlen();
        getid();
        if (strcmp(id,"movi")==0) {
          movfound=1;
          movbeg=ftell(f);
          movlen=len-4;
        } else fseek(f,len-4,SEEK_CUR);
      } else if (strcmp(id,"JUNK")==0) {
        len=getlen();
        fseek(f,len,SEEK_CUR);
      } else {
        printf("findmov: Unknown Chunk %s @0x%lx\n",id,ftell(f));
        len=getlen();
        fseek(f,len,SEEK_CUR);
      };
      if (ftell(f)>=filesize) { movfound=1;isavi=0; };
    } while (!movfound);
  } else printf("unsupported file id %s\n",id);
  if (isavi) leftread=movlen; else leftread=0;
};

void getchunkhdr() {
  getid();len=getlen();
  if (strcmp(id,"RIFF")!=0) {leftread-=len+8; if (leftread<1) readdone=1;};
};

int loadframe() {
  int lok=1;
  getchunkhdr();
  if (strcmp(id,"ix00")==0) { fseek(f,len,SEEK_CUR); getchunkhdr(); };
  if (strcmp(id,"idx1")==0) { fseek(f,len,SEEK_CUR); getchunkhdr(); };
  if (strcmp(id,"RIFF")==0) {
    fseek(f,-8L,SEEK_CUR); findmovchunk();
    if (leftread<1) return(0);
    readdone=0;getchunkhdr();
  };
  if (readdone) return(0);
  if (strcmp(id,"00dc")!=0) {
    lok=0; printf("loadframe: Unknown Chunk %s @0x%lx\n",id,ftell(f));
  };
  if (len!=(VIDX*VIDY*3)) { 
    if (len==0) { // frame len 0, frame == last frame
      return(1);
    } else {
      lok=0; printf("frame size %i not supported @0x%lx\n",len,ftell(f)); 
    };
  };
  if (lok) {
    fread(&framebuf,VIDX*VIDY*3,1,f);
  } else { readdone=1; };
  return (lok);
};

int comparescreens(unsigned char * picbuf, unsigned char * oldbuf, int psiz) {
  void pb(uint8_t b) { 
    outbuf[outbufptr++]=b; 
  }
  void pw(uint16_t w) { 
    outbuf[outbufptr++]=w; 
    outbuf[outbufptr++]=w>>8; 
  }

  int i,state=0,diffstart;
  uint16_t cnt=0,tmp;
  outbufptr=0;
  for (i=0;i<psiz;++i) {
    switch (state) {
      case 0: // count equal bytes until difference
        if (picbuf[i]==oldbuf[i]) ++cnt; else {
          if (cnt<128) {
            if (cnt) pb(cnt|0x80);     // x bytes are equal
          } else {
            pb(0x80);pw(cnt); // x bytes are equal
          };
          cnt=1;state=1;
          diffstart=i;
        };
        break;
      case 1: // count different bytes until equality
        if (picbuf[i]!=oldbuf[i]) ++cnt; else {
          if (picbuf[i+1]==oldbuf[i+1]) { // dont stop until 2 bytes equality
            if (cnt<128) {
              pb(cnt);
              for (tmp=0;tmp<cnt;tmp++) pb(picbuf[diffstart+tmp]);
            } else {
              pb(0x00);pw(cnt);
              for (tmp=0;tmp<cnt;tmp++) pb(picbuf[diffstart+tmp]);
            };
            cnt=1;state=0;
          } else ++cnt;
        }
        break;
    }
  }
  if (state==1) { // flush diff bytes
    if (cnt<128) {
      pb(cnt);
      for (tmp=0;tmp<cnt;tmp++) pb(picbuf[diffstart+tmp]);
    } else {
      pb(0x00);pw(cnt);
      for (tmp=0;tmp<cnt;tmp++) pb(picbuf[diffstart+tmp]);
    };
  };
  return(outbufptr);
}

void render_screen() {
  int x,y;

  if (SDL_LockSurface(screen)<0) return;
  for(y=0;y<SCREENY;y++) for(x=0;x<SCREENX;x++) {
     ((unsigned int*)screen->pixels)[y*SCREENX+x]=pixbuf[(y/ZOOM)*PIXX+(x/ZOOM)];
   }
  if (SDL_MUSTLOCK(screen)) SDL_UnlockSurface(screen);  
  SDL_Flip(screen);
}

void abortsdlerr() {
  printf("?%s  ERROR\n", SDL_GetError());
  exit(1);
}

void frame_begin() {
  startticks=SDL_GetTicks();
}

void frame_end() {
  char tmpstr[128];
  int realfps;

  frameticks=SDL_GetTicks()-startticks;
  if (frameticks < FPSms) {
    realfps=FPS;
//    SDL_Delay(FPSms-frameticks);
  } else realfps=1000/frameticks;
  snprintf(tmpstr,128,"%4d FPS %12li %12" PRId64,realfps,ftell(f),leftread);
  SDL_WM_SetCaption( tmpstr, NULL );
}

void dosort() {
#if 0 //sorting network - fastest but results are not identical with bubble sort
  int tmp;
#define SWAP(x,y) if (pixcnt[x] < pixcnt[y]) { tmp = pixcnt[x]; pixcnt[x] = pixcnt[y]; pixcnt[y] = tmp; tmp = pixcol[x]; pixcol[x] = pixcol[y]; pixcol[y] = tmp; }
  SWAP( 0, 1);SWAP( 2, 3);SWAP( 4, 5);SWAP( 6, 7);SWAP( 8, 9);SWAP(10,11);SWAP(12,13);SWAP(14,15); 
  SWAP( 0, 2);SWAP( 4, 6);SWAP( 8,10);SWAP(12,14);SWAP( 1, 3);SWAP( 5, 7);SWAP( 9,11);SWAP(13,15);
  SWAP( 0, 4);SWAP( 8,12);SWAP( 1, 5);SWAP( 9,13);SWAP( 2, 6);SWAP(10,14);SWAP( 3, 7);SWAP(11,15); 
  SWAP( 0, 8);SWAP( 1, 9);SWAP( 2,10);SWAP( 3,11);SWAP( 4,12);SWAP( 5,13);SWAP( 6,14);SWAP( 7,15); 
  SWAP( 5,10);SWAP( 6, 9);SWAP( 3,12);SWAP(13,14);SWAP( 7,11);SWAP( 1, 2);SWAP( 4, 8); 
  SWAP( 1, 4);SWAP( 7,13);SWAP( 2, 8);SWAP(11,14); 
  SWAP( 2, 4);SWAP( 5, 6);SWAP( 9,10);SWAP(11,13);SWAP( 3, 8);SWAP( 7,12);
  SWAP( 6, 8);SWAP(10,12);SWAP( 3, 5);SWAP( 7, 9); 
  SWAP( 3, 4);SWAP( 5, 6);SWAP( 7, 8);SWAP( 9,10);SWAP(11,12);SWAP( 6, 7);SWAP( 8, 9);
#endif
#if 1 //insertion sort - faster than bubblesort - same result
  int i,j,swp;
  for (i=1;i<16;++i) {
    for (j=i;(j>0)&&(pixcnt[j-1]<pixcnt[j]);--j) {
      swp=pixcnt[j-1];pixcnt[j-1]=pixcnt[j];pixcnt[j]=swp;
      swp=pixcol[j-1];pixcol[j-1]=pixcol[j];pixcol[j]=swp;
    };
  };
#endif
#if 0
  int i,n,newn,swp;
  n=16;
  do {
    newn=0;
    for (i=1;i<n;i++) {
      if (pixcnt[i-1]<pixcnt[i]) {
        swp=pixcnt[i-1];
        pixcnt[i-1]=pixcnt[i];
        pixcnt[i]=swp;
        swp=pixcol[i-1];
        pixcol[i-1]=pixcol[i];
        pixcol[i]=swp;
        newn=i;
      };
    };
    n=newn;
  } while (n!=0);
#endif
};

void convpixelc64() {
  int x,y;
  memset(&c64bmp,0,BMPSIZ);
  if (MCOL) {
    for (y=0;y<200;y++) {
      for (x=0;x<160;x++) {
        c64bmp[(320*(y>>3)+(y&7))+((x*2)&0x1f8)]|=((nibblebuf[y*VIDX+x]&3)<<(6-((x&3)*2)));
      }
    }
    for (x=0;x<COLSIZ4;x++) {
      c64colp[x]=((c64col[x*2]&15)<<4)|(c64col[x*2+1]&15);
    };
  } else {
    for (y=0;y<200;y++) {
      for (x=0;x<320;x++) {
        if (nibblebuf[y*320+x]&1) c64bmp[(320*(y>>3)+(y&7))+(x&0x1f8)]|=(1<<(7-(x&7)));
      }
    }
  };
}

void write_byte(char b) {
#if SAVE  
  fwrite(&b,1,1,fout);
#endif
};

void write_word(uint16_t b) {
#if SAVE  
  fwrite(&b,2,1,fout);
#endif  
};

void write_audio() {
#if SAVE  
  int i=0,j=0;
  memset(outbuf,0,audsiz);
  if (ftell(faud)<faudsize) i=fread(outbuf,audsiz,1,faud);
  for (i=0;i<audsiz;i++) j|=outbuf[i];
  if (j>0) {
    write_byte(FT_AUD);
    fwrite(&outbuf,audsiz,1,fout);
  };
#endif
};

void write_packed() {
#if SAVE
  int i;
  i=comparescreens(c64bmp,c64bmpo,BMPSIZ);
  if (i) {
    write_byte(FT_VBM);
    write_word(i);
    fwrite(&outbuf,i,1,fout);
  };
  memcpy(c64bmpo,c64bmp,BMPSIZ);

  i=comparescreens(c64scr,c64scro,SCRSIZ);
  if (i) {
    write_byte(FT_VSC);
    write_word(i);
    fwrite(&outbuf,i,1,fout);
  };
  memcpy(c64scro,c64scr,SCRSIZ);
  if (MCOL) {
    i=comparescreens(c64colp,c64colo,COLSIZ4);
    if (i) {
      write_byte(FT_VCL);
      write_word(i);
      fwrite(&outbuf,i,1,fout);
    };
    memcpy(c64colo,c64colp,COLSIZ4);
    if (regd021!=oldd021) {
      write_byte(FT_COL);
      write_byte(1);
      write_byte(regd021<<4);
      write_byte(0);
      oldd021=regd021;
    };
  };
#endif
};

void convert_screen() {
  int cx,cy,mx,x,y,r,g,b,i,pp,pc,c1,c2,c3=0,cb=0,col;
  uint32_t d1,d2,d3,db,dcol;

  if (!readdone) {
    if (loadframe()) {
      if (MCOL) {
        mx=4;
        for(i=0;i<16;i++) pixcnt[i]=0;
        for(i=0;i<16;i++) pixcol[i]=i;
        for (y=0;y<VIDY;y++) {
          for (x=0;x<VIDX;x++) {
            b=framebuf[(y*VIDX+x)*3+0];
            g=framebuf[(y*VIDX+x)*3+1];
            r=framebuf[(y*VIDX+x)*3+2];
            pc=find16(x,y,r,g,b); //1,0=nodither
            nibblebuf[y*VIDX+x]=pc;
            pixcnt[pc]++;
          }
        }
        dosort();
        regd021=cb=pixcol[0];
      } else {
        mx=8;
        for (y=0;y<VIDY;y++) {
          for (x=0;x<VIDX;x++) {
            b=framebuf[(y*VIDX+x)*3+0];
            g=framebuf[(y*VIDX+x)*3+1];
            r=framebuf[(y*VIDX+x)*3+2];
            if (MONO) nibblebuf[y*VIDX+x]=g>MONOCO;
            else nibblebuf[y*VIDX+x]=find16(x,y,r,g,b); //1,0=nodither
          }
        }
      };

      for (y=0;y<25;y++) {
        for (x=0;x<40;x++) {
          if (MONO) {
            c1=1;c2=0;
          } else {
            for(i=0;i<16;i++) pixcnt[i]=0;
            for(i=0;i<16;i++) pixcol[i]=i;
            for (cy=0;cy<8;cy++) {
              for (cx=0;cx<mx;cx++) {
                pixcnt[nibblebuf[((y*8)+cy)*VIDX+((x*mx)+cx)]]++;
              };
            };
            dosort();
            c1=pixcol[0];c2=pixcol[1];
            if (MCOL) {
              c3=pixcol[2];
              if (c1==cb) c1=pixcol[3];
              if (c2==cb) c2=pixcol[3];
              if (c3==cb) c3=pixcol[3];
            };
          };
          c64scr[(y*40)+x]=(c1<<4)|c2;
          c64col[(y*40)+x]=c3;
          for (cy=0;cy<8;cy++) {
            for (cx=0;cx<mx;cx++) {
              pp=((y*8)+cy)*VIDX+((x*mx)+cx);
              pc=nibblebuf[pp];
              d1=getdist(destpalyuv[pc][0],destpalyuv[c1][0],
                         destpalyuv[pc][1],destpalyuv[c1][1],
                         destpalyuv[pc][2],destpalyuv[c1][2]);
              d2=getdist(destpalyuv[pc][0],destpalyuv[c2][0],
                         destpalyuv[pc][1],destpalyuv[c2][1],
                         destpalyuv[pc][2],destpalyuv[c2][2]);
              if (MCOL) {
                d3=getdist(destpalyuv[pc][0],destpalyuv[c3][0],
                           destpalyuv[pc][1],destpalyuv[c3][1],
                           destpalyuv[pc][2],destpalyuv[c3][2]);
                db=getdist(destpalyuv[pc][0],destpalyuv[cb][0],
                           destpalyuv[pc][1],destpalyuv[cb][1],
                           destpalyuv[pc][2],destpalyuv[cb][2]);
                col=0;dcol=db;
                if (d1<dcol) { col=1;dcol=d1; };
                if (d2<dcol) { col=2;dcol=d2; };
                if (d3<dcol) { col=3;dcol=d3; };
                nibblebuf[pp]=col;
              } else  nibblebuf[pp]=(d1<d2)?1:0;
            };
          };
        };
      };
      convpixelc64();
#if SAVE
      write_packed();
#endif
    }
  }
  if (readdone) quit = 1;
}

void draw_screen() {
  int y,x,pc;
  uint8_t ca[4];
  for (y=0;y<PIXY;y++) {
    for (x=0;x<PIXX;x++) {
      if (MCOL) {
        ca[0]=regd021 & 15;
        ca[1]=(c64scr[(y>>3)*40+(x>>3)]>>4)&15;
        ca[2]=c64scr[(y>>3)*40+(x>>3)]&15;
        ca[3]=c64col[(y>>3)*40+(x>>3)]&15;
        pixbuf[y*PIXX+x]=screenpal[ca[(nibblebuf[y*VIDX+(x>>1)]&3)]];
      } else {
        pc=c64scr[(y>>3)*40+(x>>3)];
        pixbuf[y*PIXX+x]=screenpal[nibblebuf[y*VIDX+x]?(pc>>4):(pc&0xf)];
      };
    }
  }
};

void event_handler() {
  while(SDL_PollEvent(&event)) {
    switch (event.type) {
      case SDL_QUIT:
        quit = 1;break;
      case SDL_KEYDOWN:
        switch (event.key.keysym.sym) {
          case SDLK_ESCAPE:
          case SDLK_RETURN:
            quit = 1;break;
        }
        break;
    }
  }
}

void appinit() {
  int x,y,i,j;
  if(SDL_Init(SDL_INIT_VIDEO|SDL_INIT_AUDIO)<0) abortsdlerr();
  if((screen=SDL_SetVideoMode(SCREENX,SCREENY,SCREEN_BPP,SDL_HWSURFACE|SDL_DOUBLEBUF|SDL_HWACCEL))==NULL) abortsdlerr();
  for (x=0;x<PIXX;x++) for (y=0;y<PIXY;y++) pixbuf[PIXX*y+x]=0;
  faud=fopen(audio,"rb");
  if (faud==NULL) {
    printf("error opening audio file \"%s\"\n",audio);
    exit(-1);
  };
  f=fopen(movie,"rb");
  if (f==NULL) {
    printf("error opening video file \"%s\"\n",movie);
    exit(-1);
  };
  fseek(faud,0L,SEEK_END);faudsize=ftell(faud);rewind(faud);
  fseek(f,0L,SEEK_END);filesize=ftell(f);rewind(f);
  findmovchunk();
  if (USEPEPTO) {
    for (i=0;i<16;i++) for (j=0;j<3;j++) destpal[i][j]=pal_pepto[i][j];
  } else {
    for (i=0;i<16;i++) for (j=0;j<3;j++) destpal[i][j]=pal_colodore[i][j];
  };
  for (i=0;i<16;i++) screenpal[i]=(destpal[i][0]<<16)|(destpal[i][1]<<8)|destpal[i][2];
  for (i=0;i<16;i++)
    rgb2yuv(destpal[i][0],destpal[i][1],destpal[i][2],&destpalyuv[i][0],&destpalyuv[i][1],&destpalyuv[i][2]);
  for (i=0;i<16;i++) rgb2yuv(destpal[i][0],destpal[i][1],destpal[i][2],&destpalyuv[i][0],&destpalyuv[i][1],&destpalyuv[i][2]);
  memset(&c64bmp ,0,BMPSIZ+1);
  memset(&c64bmpo,0,BMPSIZ+1);
  memset(&c64scr ,0,SCRSIZ+1);
  memset(&c64scro,0,SCRSIZ+1);
  memset(&c64col ,0,COLSIZ8+1);
  memset(&c64colp,0,COLSIZ4+1);
  memset(&c64colo,0,COLSIZ4+1);
  regd016=MCOL?0x18:0x08;

#if SAVE  
  fout=fopen(mov64,"wb");
  fwrite(&movmagic,8,1,fout);
  fwrite(&audsiz,2,1,fout);  //312 bytes / audio frame
  fwrite(&audcyc,1,1,fout);  //63 cycles / audio sample
  fwrite(&audcmp,1,1,fout);  //8bit audio
  fwrite(&regd011,1,1,fout); //d011 Y-scroll=3, 25 Rows, Display On, Bitmap Mode
  fwrite(&regd016,1,1,fout); //d016 X-scroll=0, 40 Cols, no multicolor
  fwrite(&regd020,1,1,fout); //d020
  fwrite(&vidlace,1,1,fout); //interlace
#endif
}

void appdone() {
  fclose(f);
  fclose(faud);
#if SAVE  
  fclose(fout);
#endif
  SDL_Quit();
}

void parseargs(int argc, char *argv[]) {
  int c;
  if(argc<4) {
    printf("insane's video converter\nusage: vidconv rawvidfile.avi rawaudfile.sb outfile.v64 [options]\n\n");
    printf("Options:\n");
    printf("  -d THRESHOLD  enable dither, high threshold (4096) = low dithering effect\n");
    printf("  -y YMULT      sets Y-component multiplicator (YUV color space)\n");
    printf("  -h            use hires (default is multicolor)\n");
    printf("  -m CUTOFF     use hires monochrome, cutoff=white color\n");
    printf("  -p            use pepto palette instead of colodore\n");
    exit(-1);
  }
  for (c = 4; c < argc; c++) {
    if (argv[c][0] == '-') {
      switch(argv[c][1]) {
        case 'p':
          USEPEPTO = 1;
          break;
        case 'd':
          if ((c+1)<argc) {
            DITHER = 1;
            DTHRESH = atol(argv[++c]);
          };
          break;
        case 'y':
          if ((c+1)<argc) {
            YMUL = atol(argv[++c]);
          };
          break;
        case 'm':
          if ((c+1)<argc) {
            MONOCO = atol(argv[++c]);
            VIDX=320;VIDY=200;
            MCOL=0;
            MONO=1;
          };
          break;
        case 'h':
          VIDX=320;VIDY=200;
          MCOL=0;
          MONO=0;
          break;
        default:
          printf("unknown option: %s\n",argv[c]);
          exit(-1);
          break;
      };
    } else {
      printf("unknown parameter: %s\n",argv[c]);
      exit(-1);
    };
  };
  strncpy(movie,argv[1],255);
  strncpy(audio,argv[2],255);
  strncpy(mov64,argv[3],255);
};

int main(int argc, char *argv[]) {
  parseargs(argc,argv);
  appinit();
  while(!quit) {
    frame_begin();

    write_audio();
    if ((++fr)>=FRAMEDIV) {
      fr=0;
      convert_screen();
    };
    write_byte(FT_NXT);

    draw_screen();
    render_screen();
    event_handler();
    frame_end();
  }
  write_byte(FT_EOF);
  appdone();
  return 0;
}
/* vim: set noet ts=2 sw=2 :*/
