rem Convert video file into RAW AVI, WAV and WAV into SB (signed byte)

set FRAME_RATE=50.00

if %BASE_DIR%!==! (
  echo ERROR: BASE_DIR not set
  goto :eof
)

if %2!==! (
  echo USAGE: convert_step1.bat VIDEO_FILE_PATH OUTPUT_FILE_PATH_PREFIX
  goto :eof
)

setlocal
set path=%BASE_DIR%\build;%PATH%

set SOURCE1=%1
set SOURCE2=%2
set SOURCE3=%3

set OUTPUT=%4

echo Converting videos.
call :convert_video %SOURCE1% %OUTPUT%-1
call :convert_video %SOURCE2% %OUTPUT%-2
call :convert_video %SOURCE3% %OUTPUT%-3

set FILES=%TEMP%\files.lst
echo file '%OUTPUT%-1-raw.avi' >%FILES%
echo file '%OUTPUT%-2-raw.avi' >>%FILES%
echo file '%OUTPUT%-3-raw.avi' >>%FILES%

echo Merging %FILES% to single AVI.
type %FILES%
ffmpeg -loglevel error -y -f concat -safe 0 -i %FILES% -c copy %OUTPUT%-raw.avi
if not %ERRORLEVEL% == 0 goto :converter_error

set SPEED_FIX=speed 1.009
call :convert_audios %BASE_DIR%\%RELEASE%-Altirra.wav 1

set SPEED_FIX=speed 0.990
call :convert_audios %BASE_DIR%\%RELEASE%.wav 1

rem call %BASE_DIR%\BadAppleHD-Test.bat
rem exit
goto :eof

:convert_audios
set TARGET=%1
set TARGET_CHANNELS=%2
echo Converting audios
set OPTION=
call :convert_audio %OUTPUT%-1
set OPTION=%SPEED_FIX%
call :convert_audio %OUTPUT%-2
set OPTION=
call :convert_audio %OUTPUT%-3

sox -v 1.5 %OUTPUT%-1.wav %OUTPUT%-2.wav -v 1.5 %OUTPUT%-3.wav %OUTPUT%.wav channels 1
copy /B %OUTPUT%-1.sb+%OUTPUT%-2.sb+%OUTPUT%-3.sb %OUTPUT%.sb

sox -v 0.6 audio\Loader.wav -b 16 %OUTPUT%-Loader.wav channels 1
sox %OUTPUT%-Loader.wav %OUTPUT%.wav %TARGET% channels %TARGET_CHANNELS%
goto :eof

:convert_video
set SOURCE=%1
set OUTPUT_PART=%2
echo Converting video %SOURCE% to raw AVI %OUTPUT_PART%.
ffmpeg -loglevel error -y -i %SOURCE% -vcodec rawvideo -filter:v "scale=384:232" -pix_fmt bgr24 -r %FRAME_RATE% -ar 44100 %OUTPUT_PART%-raw.avi
if not %ERRORLEVEL% == 0 goto :converter_error

echo Converting audio to raw WAV.
ffmpeg -loglevel error -y -i %OUTPUT_PART%-raw.avi -vn %OUTPUT_PART%-tmp.wav
if not %ERRORLEVEL% == 0 goto :converter_error
goto :eof

:convert_audio
set OUTPUT_PART=%1

echo Converting WAV to Signed Byte.
for /f %%v in ('sox %OUTPUT_PART%-tmp.wav -n stat -v 2^>^&1') do set vol=%%v
if not %ERRORLEVEL% == 0 goto :converter_error
if %vol%!==Rough! (
  set vol=0
)

sox -D -v %vol% %OUTPUT_PART%-tmp.wav -r 44100 %OUTPUT_PART%.wav %OPTION%

if not %ERRORLEVEL% == 0 goto :converter_error
sox -D %OUTPUT_PART%.wav -D -c 1 -r 15639 %OUTPUT_PART%.sb
if not %ERRORLEVEL% == 0 goto :converter_error
goto :eof

:converter_error
echo ERROR: Conversion failed.
exit 1
