;
;	"Bad Apple HD by JAC! - 2017-03-17 Draft"
;

rows	= 29

zp	= $90
page	= zp

chr_rom	= $e000

sm1	= $4a70	; $570 bytes for 29 rows
chrtab1	= $4fe0 ; 32 byte, <rows> bytes used
chr1	= $5000 ; up to 4*$400

sm2	= sm1+$2000
chrtab2	= chrtab1+$2000
chr2	= chr1+$2000

	icl "../../BadAppleHD-Kernel-Equates.asm"

	opt h+
	org $2000
	
	jmp main		;Jump table used by TileStreamPacker
	jmp play_frame
	
	.byte "Bad Apple HD by JAC! - 2017-07-27 V0.6",0,155

	.local dl

	.local dl1
	.byte $70,$80
	.byte $c2,a(sm1)
	.rept rows-2
	.byte $82
	.endr
	.byte $02
	.byte $41,a(dl1)
	.endl
	
	.local dl2
	.byte $70,$80
	.byte $c2,a(sm2)
	.rept rows-2
	.byte $82
	.endr
	.byte $02
	.byte $41,a(dl2)
	.endl
	.endl

	.local text1
;	       0123456789012345678901234567890123456789
	.byte "       Insert tape and press play.      " 
	.endl
	.local text2
	.byte "           Then press any key.          "
	.endl

;---------------------------------------------------------------
	icl "..\..\BadAppleHD-Tape.asm"

	.proc sync
	lda 20
wait	cmp 20
	beq wait
	rts
	.endp

;---------------------------------------------------------------

	.proc nmi

	.proc vbi

	.proc vbi1
	mwa #dl.dl1 sdlstl
	mwa #dli.dli1 vdslst
	mva #<chrtab1 dli.dli1.line
	jmp sysvbv
	.endp

	.proc vbi2
	mwa #dl.dl2 sdlstl
	mwa #dli.dli2 vdslst
	mva #<chrtab2 dli.dli2.line
	jmp sysvbv
	.endp

	.endp		;End of vbi

	.proc dli
	.proc dli1
	pha
line = *+1
	lda chrtab1
	sta wsync
	sta chbase
	lda line
;	sta $d01a
	inc line
	pla
	rti
	.endp

	.proc dli2
	pha
line = *+1
	lda chrtab2
	sta wsync
	sta chbase
	lda line
;	sta $d01a
	inc line
	pla
	rti
	.endp

	.endp		;End of dli

	.endp

;---------------------------------------------------------------

	.proc main
	
	jsr motor.off	;Stop cassette motor

	jsr sync
	
	mva #1 page	;Start of page 2, so page 1 is what is loaded first
	mwa #nmi.vbi.vbi2 vvblki
	mva #$23 sdmctl
	mva #$c0 nmien

	lda #0		;Main colors
	sta 709
	lda #$34
	sta 704		;Mask color
	lda #14
	sta 710
	lda #$78
	sta 712

	lda #$24	;Mask position and pattern
	sta hposp0
	lda #220
	sta hposm0
	lda #$03
	sta grafp0
	sta grafm

	ldx #0
init_chrtab
	lda #>chr1
	sta chrtab1,x
	lda #>chr2
	sta chrtab2,x
	inx
	cpx #rows
	bne init_chrtab

	.proc init_chr
	ldy #4
	ldx #0
loop
from	lda chr_rom,x
to1	sta chr1,x
to2	sta chr2,x
	inx
	bne loop
	inc from+2
	inc to1+2
	inc to2+2
	dey
	bne loop
	.endp

	ldx #39
init_text
	mva text1,x sm2+484,x
	mva text2,x sm2+580,x
	dex
	bpl init_text

	mva #$ff 764
no_key	cmp 764
	beq no_key

	jsr motor.on	;Start cassette motor

	jsr sync
	lda #0
	sta 18
	sta 19
	sta 20
	rts
	.endp
	
	ini main

	.proc play_frame
wait	lda $d40b
	sta $d01a
	cmp #$9a
	bne wait
	sta wsync
	sta wsync
	inc page
	lda #0
	sta 18
	sta 19
	sta 20
no_wait
	lda page
	and #1
	lsr
	bcs use_page2
	lda #<nmi.vbi.vbi1
	ldx #>nmi.vbi.vbi1
	bne set_page

use_page2
	lda #<nmi.vbi.vbi2
	ldx #>nmi.vbi.vbi2

set_page
	sta vvblki
	stx vvblki+1

	rts
	.endp

	opt h-
	ins "../../video/step3/BadAppleHD-xex.bin"

	opt h+
	org $2800
	.proc stop
	mva #8 710
	jmp stop
	.endp

	run stop
