;
;	>> BadAppleHD - ROM Version with XEX Loader by JAC! <<
;
;	Turns out the Atari is too slow to actually copy the data.
;
;	For 1 MB Maxflash with 128 banks of 8k each. Last updated 2015-08-06.
;	You can choose cartmapper "42 - MaxFlash 1M / 8Mbit -older (bank127)
;	or "MaxFlash 1M / 8Mbit - new (bank0)" in Altirra. Both will work with this.
;
;	Assumes that you have you emulator registered for the ".rom" file extension
;	or have configured the following start parameters:
;	"${runnerExecutablePath} /singleinstance ${outputFilePath} /cartmapper 42"
;
;	Assemble and then via "BadAppleHD-ROM-XEX.bat".
;
;	@com.wudsn.ide.asm.outputfileextension=.rom

start_ram	= $1000

;CARTCS	= $bffa 			;Start address vector, used if CARTFG has CARTFG_START_CART bit set
;CART	= $bffc				;Flag, must be zero for modules
;CARTFG	= $bffd				;Flags or-ed together, indicating how to start the module.
;CARTAD	= $bffe				;Initialization address vector

CARTFG_DIAGNOSTIC_CART = $80		;Flag value: Directly jump via CARTAD during RESET.
CARTFG_START_CART = $04			;Flag value: Jump via CARTAD and then via CARTCS.
CARTFG_BOOT = $01			;Flag value: Boot peripherals, then start the module.


	opt h-				;Disable Atari COM/XEX file headers

;===============================================================
;	Bank 0 is the startup bank on newer
;	Atarimax Maxflash 1MB cartridges only.
;	See bank 127 for the compatibility code for the older models.

	org $a000			;Bank 0
	opt f+				;Activate fill mode
	lmb #0				;Load memory bank 0

	.proc bank_0			;Powerup code for new Atarmax 1 MB cartridges

	.proc init_rom			;Cartridge initalization
	rts				;Parts that shall be execute before booting
	.endp

	.proc start_rom			;Cartridge start, RAM, graphics 0 and IOCB no 0 for the editor (E:) are ready

	ldx #0
copy
	.rept [.len[starter]+$ff]/$100
	lda starter_rom+#*$100,x
	sta start_ram+#*$100,x
	.endr
	inx
	bne copy
	jmp start_ram

starter_rom
	.proc starter,start_ram
	icl "BadAppleHD-ROM-XEX-Main.asm"
	.endp
	
	.endp

;----------------------------------------------------------------

	org $bff4			;Powerup code for old Atarmax 1 MB cartridges

	.proc powerup
	lda $d500			;Dummy, will never be excuted, see bank 127
	jmp start_rom			;Continuation from bank 127				
	.endp

	org $bffa			;Cartridge control block
	.word start_rom			;CARTCS
	.byte 0				;CART
	.byte CARTFG_START_CART		;CARTFG
	.word init_rom			;CARTAD
	.endp				;End of bank_0

	opt f-				;Dectivate fill mode, so ORG can be changed again

;===============================================================

	org $a000			;126 banks for testing
	opt f+
	ins '..\xex\BadAppleHD-XEX.xex',+2,126*$2000	;Skip inital $ff,$ff
	opt f-

;===============================================================
;	Special startup on bank 127 because older
;	Atarimax Maxflash 1MB cartridges have start bank 127
;	Newer cartridges have start bank 0, but you should keep
;	this code for compatibility with older hardware.

	org $a000			;Bank 127
	opt f+				;Activate fill mode
	lmb #127			;Load memory bank 127

	.proc bank_127			;Powerup code for old Atarmax 1 MB cartridges

	org $bff3

	.proc init_rom			;Cartridge initalization
	rts				;Only the minimum of the OS initialization is complete, you don't want to code here normally.
	.endp

	.proc powerup
	lda $d500			;Activate bank 0
	jmp *				;Dummy, will never be excuted, see bank 0
	.endp

	org $bffa			;Cartridge control block
	.word powerup			;CARTCS
	.byte 0				;CART
	.byte CARTFG_START_CART 	;CARTFG
	.word init_rom			;CARTAD

	.endp				;End of bank127
	opt f-				;Deactivate fill mode