@echo off
setlocal

set START_MODE=%1
call Make-Settings.bat

cd %BASE_DIR%
call :make_version intro\BadAppleHD-Intro.avi video\BadAppleHD.mkv outro\BadAppleHD-Outro.avi BadAppleHD

goto :eof

:make_version
set SOURCE1=%1
set SOURCE2=%2
set SOURCE3=%3
set STEP1_OUTPUT=video\step1\%4
set STEP2_OUTPUT=video\step2\%4
set STEP3_OUTPUT=video\step3\%4

if %START_MODE%!==START_ROM_FAST! (
  goto :fast
)

rem Convert video file into RAW AVI, WAV and WAV into SB (signed byte)
call build\convert_step1.bat %SOURCE1% %SOURCE2% %SOURCE3% %STEP1_OUTPUT%


rem Copy Java classes if in development mode
set CP=%BASE_DIR%\bin
if exist %PROJECT_DIR% (
  rmdir /s /q %CP%
  mkdir %CP%
  xcopy /s /i /q %PROJECT_DIR%\bin %CP%
)

rem Convert RAW AVI to tile stream
java -cp %CP% %CONVERTER_MAIN% %STEP1_OUTPUT%-raw.avi %STEP2_OUTPUT% %CONVERTER_CLASS%
if not %ERRORLEVEL% == 0 goto :converter_error

rem Convert tile stream to binary chunks
java -cp %CP% %PACKER_MAIN% %STEP2_OUTPUT%.hdr %STEP2_OUTPUT%.til %STEP1_OUTPUT%.sb %STEP3_OUTPUT%
if not %ERRORLEVEL% == 0 goto :packer_error

rem Combine ROM control and ROM data into one file
copy /B/Y %STEP3_OUTPUT%-rom-control.bin+%STEP3_OUTPUT%-rom.bin %STEP3_OUTPUT%-Data.bin

:fast

%MADS% %RELEASE%.asm -d:DEBUG=0 -o:%RELEASE%.rom -p -t:%RELEASE%.lab -l:%RELEASE%.lst
if ERRORLEVEL 1 goto :mads_error

java -jar .\build\AtariROMMaker.jar -load:BadAppleHD.rom -convertToCAR:1 -save:%RELEASE%.car
if ERRORLEVEL 1 goto :rom_maker_error

copy /B/Y %RELEASE%.car studio\%RELEASE%.tcd

java -jar .\build\TheCartStudio.jar -open:studio\%RELEASE%.tcw -addEntries:studio\%RELEASE%.tcd\%RELEASE%.car -addEntries:%STEP3_OUTPUT%-Data.bin -save  -exportToCarImage:%RELEASE%.car -exportToAtrImage:video\step4\%RELEASE%.atr
if ERRORLEVEL 1 goto :studio_error
del /Q %RELEASE%.txt

:run

if %START_MODE%!==START_ROM! (
  call BadAppleHD-Test.bat
)
if %START_MODE%!==START_ROM_FAST! (
  call BadAppleHD-Test.bat
)
goto :eof

:converter_error
echo ERROR: Converter errors occurred. Check error messages above.
goto :eof

:packer_error
echo ERROR: Packer errors occurred. Check error messages above.
goto :eof

:mads_error
echo ERROR: MADS compilation errors occurred. Check error messages above.
goto :eof

:rom_maker_error
echo ERROR: AtariROMMaker errors occurred. Check error messages above.
goto :eof

:studio_error
echo ERROR: The!Cart Studio errors occurred. Check error messages above.
goto :eof