;
;	>> BadAppleHD - The!Cart ROM Version by JAC! <<
;
;	@com.wudsn.ide.asm.outputfileextension=.rom

start_ram	= $1000

;CARTCS	= $bffa 			;Start address vector, used if CARTFG has CARTFG_START_CART bit set
;CART	= $bffc				;Flag, must be zero for modules
;CARTFG	= $bffd				;Flags or-ed together, indicating how to start the module.
;CARTAD	= $bffe				;Initialization address vector

CARTFG_DIAGNOSTIC_CART = $80		;Flag value: Directly jump via CARTAD during RESET.
CARTFG_START_CART = $04			;Flag value: Jump via CARTAD and then via CARTCS.
CARTFG_BOOT = $01			;Flag value: Boot peripherals, then start the module.


	opt h-				;Disable Atari COM/XEX file headers

	org $a000			;Bank 0
	opt f+				;Activate fill mode

	.proc bank_0			;Powerup code for new Atarmax 1 MB cartridges

	.byte "Bad Apple HD by JAC! - 2018-10-28 V0.9",0,155

	.proc init_rom			;Cartridge initalization
	rts				;Parts that shall be execute before booting
	.endp

	.proc start_rom			;Cartridge start, RAM, graphics 0 and IOCB no 0 for the editor (E:) are ready
	cld

	ldx #0
copy
	.rept [.len[starter]+$ff]/$100	;Copy every page in parallel for speed and simplicity
	lda starter_rom+#*$100,x
	sta start_ram+#*$100,x
	.endr
	inx
	bne copy
	jmp start_ram

starter_rom
	.proc starter,start_ram
	icl "BadAppleHD-Main.asm"
	.endp
	
	.endp

;----------------------------------------------------------------

	org $bffa			;Cartridge control block
	.word start_rom			;CARTCS
	.byte 0				;CART
	.byte CARTFG_START_CART		;CARTFG
	.word init_rom			;CARTAD
	.endp				;End of bank_0
