
;	@com.wudsn.ide.asm.mainsourcefile=BadAppleHD.asm

red	= $34

frame_mask	= 0

buffer_length = 40
buffer_relevant_length = 3

max_frames = 255

state_undefined	= $2d
state_low 	= $30
state_high	= $31

measure_time_step	= 50

	.proc motor

	.proc on
	lda pactl
	and #~8
	sta pactl
	rts
	.endp

	.proc off
	lda pactl
	ora #8
	sta pactl
	rts

	.endp
	
	.endp		;End of motor

;---------------------------------------------------------------


	.proc tape


active	.byte 0

buffer	.ds buffer_length

noise_frames	.byte 0
low_frames	.byte 0
high_frames	.byte 0

state		.byte 0
previous_state	.byte 0
state_time	.word 0

frame_time	.word 0
frame50_count	.byte 0
frame50_time	.word 0

measure_started	.byte 0
measure_time	.word 0
current_time	.word 0
	
	.proc read_frame
	lda active
	beq not_active
	jsr update_buffer
	jsr analyze_buffer
	jsr analyze_frames
	jsr count_frames
not_active
	rts
	.endp

	.proc init
	
	cld
	mva #0 active

	lda #$80
	ldx #buffer_length-1
clear_buffer
	sta buffer, x
	dex
	bpl clear_buffer

	lda #0
	sta noise_frames
	sta low_frames
	sta high_frames
	
	lda #state_undefined
	sta state
	sta previous_state
	mwa #0 state_time
	
	mwa #0 frame_time
	mva #0 frame50_count
	mwa #0 frame50_time
	mva #0 measure_started
	mwa #0 measure_time
	mwa #0 current_time
	rts

	.endp

;---------------------------------------------------------------

	.proc get_status
	lda skctl
	lsr
	lsr
	lsr
	lsr
	and trig0		;For testing
	rts
	.endp

;---------------------------------------------------------------

	.proc update_buffer
	ldx #buffer_length-1	;Scroll buffer to the right
loop	lda buffer-1,x
	sta buffer,x
	dex
	bne loop

	jsr get_status		;Insert new value as head
	seq
	lda #1
	sta buffer

	rts
	.endp

;---------------------------------------------------------------

	.proc analyze_buffer
	lda buffer
	ldx #buffer_relevant_length-1
loop	ldy buffer+1,x
	bmi noise		;Not yet filled
	cmp buffer+1,x
	bne noise		;Not equal
	dex
	bpl loop
	jmp no_noise 

noise	lda noise_frames
	cmp #max_frames
	seq
	inc noise_frames
	lda #0
	sta low_frames
	sta high_frames
	rts

no_noise
	cmp #0
	bne no_low
	lda low_frames
	cmp #max_frames
	seq
	inc low_frames
	lda #0
	sta noise_frames
	sta high_frames
	rts

no_low
	lda high_frames
	cmp #max_frames
	seq
	inc high_frames
	lda #0
	sta noise_frames
	sta low_frames
	rts
	.endp


;---------------------------------------------------------------
	.proc analyze_frames
	lda low_frames
	bne low
	lda high_frames
	bne high
	lda #state_undefined
	jmp skip

low	lda #state_low
	.byte $2c
high	lda #state_high
	sta state

	ldx previous_state
	cpx #state_undefined
	bne previous_not_undefined
	sta previous_state
	jmp skip

previous_not_undefined
	cmp previous_state
	beq skip

	mwa #0 state_time
	lda measure_started
	beq first_state_changed
	bne next_state_changed

skip	inw state_time
	rts
	.endp

;---------------------------------------------------------------

	.proc first_state_changed
	mva #1 measure_started
	mwa #0 measure_time
	mwa #0 frame_time
	mwa #measure_time_step frame50_time
	mva #measure_time_step frame50_count 
	rts
	.endp

	.proc next_state_changed
	lda state
	sta previous_state
	cmp #state_low
	beq low
	cmp #state_high
	beq high
	.byte 2
low
high
	adw measure_time #measure_time_step
	rts
	.endp

;---------------------------------------------------------------

	.proc count_frames
	lda measure_started
	sne
	rts

	inw frame_time
	dec frame50_count
	bne not_50
	mva #measure_time_step frame50_count
	adw frame50_time #measure_time_step
not_50
	rts
	.endp

;---------------------------------------------------------------

	.proc print_counters
	p1 = $80
	
	mwa savmsc p1

	ldy #0
 	lda #"M"
 	sta (p1),y
 	iny
 	iny
 	lda #" "
 	sta (p1),y
 	
 	ldy #40
 	lda pactl
 	and #8
 	bne motor_is_off
 
 	lda #"O"
 	sta (p1),y
 	iny
 	lda #"N"
 	sta (p1),y
 	iny
 	lda #" "
 	sta (p1),y
 	jmp skip_off  
 
motor_is_off
 	lda #"O"
 	sta (p1),y
 	iny
 	lda #"F"
 	sta (p1),y
 	iny
 	lda #"F"
 	sta (p1),y
skip_off
 
 	adw p1 #120 
 
	ldx #0
	ldy #0
loop	lda buffer,x
	seq
	lda #$54

	sta (p1),y
	iny
	inx
	cpx #buffer_length
	bne loop

	adw p1 #80 

 	ldy #0
 	lda #"N"
 	sta (p1),y
 	ldy #40
 	lda noise_frames
 	jsr screen.print_byte

 	ldy #5
 	lda #"0"
 	sta (p1),y
 	ldy #45
 	lda low_frames
 	jsr screen.print_byte

 	ldy #10
 	lda #"1"
 	sta (p1),y
 	ldy #50
 	lda high_frames
 	jsr screen.print_byte
 
  	ldy #15
 	lda #"S"
 	sta (p1),y
 	ldy #55
 	lda state
 	sec
 	sbc #$20
 	sta (p1),y

 	lda state
 	ldx #red
 	cmp #state_low
 	sne
 	ldx #0
 	cmp #state_high
 	sne
 	ldx #14
 	stx pcolor1
 
  	ldy #20
 	lda #"S"
 	sta (p1),y
 	iny
 	lda #"T"
 	sta (p1),y
 	ldy #60
 	lda state_time
 	ldx state_time+1
	jsr screen.print_word
 	
 	adw p1 #120
 
   	ldy #0
 	lda #"F"
 	sta (p1),y
  	ldy #40
  	lda frame_time
  	ldx frame_time+1
  	jsr screen.print_word

   	ldy #8
 	lda #"F"
 	sta (p1),y
 	iny
 	lda #"5"
 	sta (p1),y
 	iny
 	lda #"0"
 	sta (p1),y

  	ldy #48
  	lda frame50_time
  	ldx frame50_time+1
  	jsr screen.print_word
      
   	ldy #16
 	lda #"M"
 	sta (p1),y
  	ldy #56
  	lda measure_time
  	ldx measure_time+1
  	jsr screen.print_word

	rts
	.endp

	.proc screen

	.proc print_byte	;IN: <A>
	sta binary_8_to_bcd_16.bin
	jsr binary_8_to_bcd_16
	lda binary_8_to_bcd_16.bcd+1
	jsr print_byte_bcd
	lda binary_8_to_bcd_16.bcd+0
	jsr print_byte_bcd
	rts
	.endp

	.proc print_word	;IN: <A>=low, <A>=high
	sta binary_16_to_bcd_24.bin
	stx binary_16_to_bcd_24.bin+1
	jsr binary_16_to_bcd_24
	lda binary_16_to_bcd_24.bcd+2
	jsr print_byte_bcd
	lda binary_16_to_bcd_24.bcd+1
	jsr print_byte_bcd
	lda binary_16_to_bcd_24.bcd+0
	jsr print_byte_bcd
	rts
	.endp

	.proc print_byte_bcd	;IN: <A>
	pha
	lsr
	lsr
	lsr
	lsr
	ora #$10
	sta (p1),y
	iny
	pla
	and #15
	ora #$10
	sta (p1),y
	iny
	rts
	.end

;---------------------------------------------------------------

	.proc binary_8_to_bcd_16	;IN: bin .byte 0, OUT: bcd .byte 0,0

	sed		; Switch to decimal mode
	lda #0		; Ensure the result is clear
	sta bcd+0
	sta bcd+1
	ldx #8		; The number of source bits

loop	asl bin		; Shift out one bit
	lda bcd+0	; And add into result
	adc bcd+0
	sta bcd+0
	lda bcd+1	; propagating any carry
	adc bcd+1
	sta bcd+1
	dex		; And repeat for next bit
	bne loop
	cld		; Back to binary
	rts

bin	.byte 0
bcd	.byte 0,0

	.endp

;---------------------------------------------------------------

	.proc binary_16_to_bcd_24	;IN: bin .byte 0,0, OUT: bcd .byte 0,0,0

	sed		; Switch to decimal mode
	lda #0		; Ensure the result is clear
	sta bcd+0
	sta bcd+1
	sta bcd+2
	ldx #16		; The number of source bits

loop	asl bin		; Shift out one bit
	rol bin+1
	lda bcd+0	; And add into result
	adc bcd+0
	sta bcd+0
	lda bcd+1	; propagating any carry
	adc bcd+1
	sta bcd+1
	lda bcd+2	; propagating any carry
	adc bcd+2
	sta bcd+2
	dex		; And repeat for next bit
	bne loop
	cld		; Back to binary
	rts

bin	.byte 0,0
bcd	.byte 0,0,0,0

	.endp

	.endp

	.endp
