;	@com.wudsn.ide.asm.mainsourcefile=BadAppleHD.asm


.if .not .def DEBUG
 .def DEBUG=1
.endif

rows		= 29

bank_size 	= $2000
control_data_banks = [.filesize "video/step3/BadAppleHD-rom-control.bin"/bank_size]

zp		= $90

frame		= zp

control_ptr	= zp+2
screen_ptr	= zp+4
last_screen_ptr	= zp+6
chrtab_ptr	= zp+8	;32 byte, <rows> bytes used
p1		= zp+10
p2		= zp+12
stop_flag	= zp+14 ;0=not stopped, 1=stopped
loop_flag	= zp+15	;0=first iteration, 1=2nd or later iteration

chrtab		= $a0

chr_rom		= $e000

empty_sm 	= $3000
sm_size		= $570	; $570 bytes for 29 rows

loader_buffer	= $3800

rom_start 	= $8000
rom_end   	= $bfff
bank_step 	= [rom_end+1-rom_start]/bank_size

	icl "BadAppleHD-Kernel-Equates.asm"

;=================================================================

	jmp main

demo_start_bank	.word $0000
data_start_bank	.word $0000
data_bank	.word $0000

	.local dl

	.byte $00,$80

	.byte $c2
lms	.word empty_sm
	.rept rows-1-2
	.byte $82
	.endr

	.if DEBUG=1
	.byte $c2,a(debug_sm)
	.byte $42,a(chrtab)
	.else
	.byte $82,$02
	.endif

	.byte $41,a(dl)
	.endl

;	 text "0123456789012345678901234567890123456789"
	.local text1
	.byte "     Insert the tape and press PLAY.    " 
	.endl
	.local text2
	.byte "           Then press RETURN.           "
	.endl

	.local text3
	.byte "  RESET The!Cart and RESET your Atari.  " 
	.endl
	.local text4
	.byte " Then hold down SHIFT and press RETURN. "
	.endl

	.local debug_sm
	.byte "                                                "
	.endl

;---------------------------------------------------------------

	icl "BadAppleHD-Tape.asm"

	.proc sync
	lda 20
wait	cmp 20
	beq wait
	rts
	.endp

;---------------------------------------------------------------


	.macro m_print_word
	lda :1+1
	jsr debugger.print_hex_byte
	lda :1
	jsr debugger.print_hex_byte
	iny
	.endm
	
	.proc debugger
	
	.proc print_hex_byte	;IN: <A>=value, <Y>=index, OUT: <Y>=<Y>+2
	pha
	and #$0f
	tax
	lda hexbytes,x
	sta debug_sm+5,y
	pla
	lsr
	lsr
	lsr
	lsr
	tax
	lda hexbytes,x
	sta debug_sm+4,y
	iny
	iny
	rts

hexbytes	.byte "0123456789ABCDEF"
	.endp
	
	.endp		;end of debug
;---------------------------------------------------------------

	.proc nmi

	.proc vbi

	mwa #dl  sdlstl
	mwa #dli vdslst

	mva #<chrtab dli.chrtab_ptr
	mva #0 atract
	jmp sysvbv
	.endp		;End of vbi

	.proc dli
	pha
chrtab_ptr = *+1
	lda chrtab
	sta wsync
	sta chbase
	inc chrtab_ptr
	pla
	rti
	.endp		;End of dli

	.endp

;===============================================================

	.proc cartridge

	.enum the_cart_mode	;Special The!Cart mode value used by the studio.
tc_mode_8k		= $01
tc_mode_flexi		= $20
tc_mode_binary_file	= $e0
tc_mode_executable_file = $e1;	
tc_mode_atr_file	= $e2
	.ende
	
	.enum the_cart
primary_bank_lo		= $d5a0
primary_bank_hi		= $d5a1
primary_bank_enable	= $d5a2
secondary_bank_lo	= $d5a3
secondary_bank_hi	= $d5a4
secondary_bank_enable	= $d5a5
mode			= $d5a6
configuration_lock	= $d5af
	.ende

control_bank	.word $0000


;	Init Flexi Mode with banks at $8000 and $a000
	.proc init
	inc critic
	mva #the_cart_mode.tc_mode_flexi the_cart.mode
	lda #1
	sta the_cart.primary_bank_enable
	sta the_cart.secondary_bank_enable
	mva trig3 gintlk
	dec critic
	rts
	.endp

	.proc exit
	inc critic
	lda #0
	sta the_cart.primary_bank_enable
	sta the_cart.secondary_bank_enable
	mva trig3 gintlk
	dec critic
	rts
	.endp

;	Set active bank with <A>=low, <X>=high
;	The <XA> will be active at $8000.
;	The <XA+1> will be active at $a000.
	.proc set_16k_bank
	sta the_cart.secondary_bank_lo
	stx the_cart.secondary_bank_hi
	clc
	adc #1
	scc
	inx
	sta the_cart.primary_bank_lo
	stx the_cart.primary_bank_hi
	rts
	.endp

;
 	.proc init_control
	mwa #rom_start control_ptr
	rts
	.endp

;	Get next control byte from currently active bank
	.proc get_control_byte
	lda control_bank
	ldx control_bank+1
	jsr set_16k_bank
	ldy #0
	lda (control_ptr),y
	tay
	inw control_ptr
	lda control_ptr+1
	cmp #>[rom_end+1]
	bne not_end
	mwa #rom_start control_ptr
	adw control_bank #bank_step 
not_end	
	tya
	rts
	.endp

;	Out: <A>=$00 for same frame, $01 for next bank, $02 for end, $80 for new frame, also sets screen_ptr and chartab_ptr
	.proc get_frame_pointers
	jsr cartridge.get_control_byte
	bpl control_byte
	sta screen_ptr+1
	jsr cartridge.get_control_byte
	sta screen_ptr
	adw screen_ptr #sm_size chrtab_ptr
	lda #$80
control_byte
	rts
	.endp

	.endp

;===============================================================
	.proc screen
	
	.proc init
	mwa #empty_sm dl.lms
	
	ldx #0
init_chrtab
	lda #>chr_rom
	sta chrtab,x
	inx
	cpx #rows
	bne init_chrtab

	rts
	.endp

;---------------------------------------------------------------

	.proc init_colors
	lda #0		;Main colors
	ldx #14
	sta 709		;Hires foreground, black
	sta 704		;Mask color for P0 and M0, black
	stx 710		;Hires background, white
	sta 712		;Border color, black

	lda #$24	;Mask position and pattern
	sta hposp0
	lda #220
	sta hposm0
	lda #$03
	sta grafp0
	sta grafm
	rts
	.endp

	.proc on
	mwa #nmi.vbi vvblki
	mva #$23 sdmctl
	mva #$c0 nmien
	rts
	.endp

	.endp

;===============================================================

	.proc main

;	Remeber start bank for controlled RESET
	mwa cartridge.the_cart.primary_bank_lo demo_start_bank

	jsr wait_key_released	;Debounce
	jsr motor.off		;Stop cassette motor

;	Compute screen pointers
	ldy colcrs
	mva #0 (savmsc),y
	adw savmsc #320 p1
	adw p1 #80 p2

;	Enable cartridge to check if it is not locked
	.proc check_not_locked
	jsr cartridge.init
	lda rom_start	;$8000
	pha
	jsr cartridge.exit
	pla
	bne the_cart_config_not_locked
	ldy #39
init_error_text
	mva text3,y (p1),y
	mva text4,y (p2),y
	dey
	bpl init_error_text
	jmp *

the_cart_config_not_locked
	.endp

	ldy #39
init_text
	mva text1,y (p1),y
	mva text2,y (p2),y
	dey
	bpl init_text

restart
	jsr loader

	jsr screen.init
	jsr sync	
	jsr screen.on

	ldx #0
fade_up txa
	lsr
	lsr
	sta 710
	jsr sync
	inx
	cpx #64
	bne fade_up

	jsr motor.on	;Start cassette motor
	jsr sync
wait_tape
	jsr tape.get_status
	bne wait_tape

	mwa #256 data_start_bank

	mwa data_start_bank cartridge.control_bank	
	adw cartridge.control_bank #control_data_banks data_bank

	jsr cartridge.init
	jsr cartridge.init_control

	jsr cartridge.get_frame_pointers
	mwa screen_ptr last_screen_ptr

	jsr sync

	mwa #0 frame
	sta stop_flag

	.proc play_loop
	mwa screen_ptr dl.lms			;For current frame
	lda data_bank
	ldx data_bank+1
	jsr cartridge.set_16k_bank		;For current frame
	ldy #rows-1
copy_chrtab
	lda (chrtab_ptr),y
	sta chrtab,y
	dey
	bpl copy_chrtab

	.if DEBUG=1
	jsr debug_values
	.endif

	jsr play_frame
;	jsr wait_key

next_bank
	lda skstat
	and #4
	bne no_key_pressed	;Key pressed?
	lda kbcode
	cmp #28			;ESC?
	bne no_cold_start
	
	mva #cartridge.the_cart_mode.tc_mode_8k cartridge.the_cart.mode
	mwa demo_start_bank cartridge.the_cart.primary_bank_lo
	mva #0 cartridge.the_cart.secondary_bank_enable
	jmp coldsv
no_cold_start

no_key_pressed
	lda stop_flag		;Looping the final screen?
	beq not_stopped
	lda 19
	cmp #4			;4*256 frames = 20,48s
	bcc play_loop		;Still stopped

	mva #1 loop_flag
	jmp restart

not_stopped
	jsr cartridge.get_frame_pointers
	cmp #$00
	beq same_frame
	cmp #$02
	beq stop
	cmp #$01
	bne same_bank
	adw data_bank #bank_step
	jmp next_bank
same_bank
same_frame
	mwa screen_ptr last_screen_ptr
	inw frame
	jmp play_loop

stop	jsr motor.off
	inc stop_flag
	lda #0
	sta 20
	sta 19
	jmp play_loop
	.endp

	.endp

	.proc loader
	channel = $10
	length = $384

	lda loop_flag
	bne is_loop
	lda #$ff		;No, loop, clear keyboard state
	.byte $2c
is_loop	lda #$12		;Yes, virtually press RETURN
	sta ch

	ldx #channel
	mva #cio_command.open iccom,x
	mwa #filespec icbal,x
	mwa #4 icax1,x
	mwa #0 icax2,x
	jsr ciov
	bmi load_error

	mva #$00 sdmctl
	sta dmactl
	jsr screen.init_colors

	ldx #channel
	mva #cio_command.get_character iccom,x
	mwa #loader_buffer icbal,x
	
	mwa #length icbll,x
	jsr ciov
	bpl close
	cpy #136
	beq close
	bne load_error
close
	ldx #channel
	mva #cio_command.close iccom,x
	jsr ciov

	mva #3 skctl
	rts

load_error
	lda #0
	sta hposp0
	sta hposm0
	lda vcount
	and random	
	sta colbk
	jmp load_error

filespec
	.byte 'C:',$9b
	.endp

	.proc wait_key
	mva #$ff ch
wait	cmp ch
	beq wait
	rts
	.endp

	.proc wait_key_released
wait	lda skstat
	and #12
	cmp #12
	bne wait
	rts
	.endp

	.proc debug_values
	lda #>chr_rom
	sta chrtab+rows-2
	sta chrtab+rows-1
 	ldy #0
	m_print_word frame
	m_print_word cartridge.control_bank
	m_print_word control_ptr
	m_print_word data_bank
	m_print_word last_screen_ptr
	m_print_word screen_ptr
	m_print_word chrtab_ptr
	rts
	.endp

	.proc play_frame
skip_step = 12;


	.print "Skip step: ",skip_step

wait	jsr sync
	lda pal
	cmp #15
	bne no_ntsc

	inc skip_counter+1
	lda skip_counter+1
	cmp #5
	bcc no_skip
	mva #0 skip_counter+1
	clc
	lda skip_counter
	adc #skip_step
	sta skip_counter
	bcs no_skip
	jsr sync
no_skip

no_ntsc
	rts

skip_counter	.word 0


	.endp
