
	icl "BadAppleHD-Kernel-Equates.asm"


	org $2000
start
	jsr tape.init
	sei
	mva #0 nmien
	mwa #vbi vvblki
	mwa #deferred_vbi vvblkd
	mva #$40 nmien
	cli

	lda #$ff			;Init graphics
	sta grafp0
	sta grafp1
	lda #192
	sta hposp0
	clc
	adc #10
	sta hposp1
	mva #1 gprior

restart	jsr motor.off

	lda #red
	sta pcolor0
	sta pcolor1

	lda #$ff
	sta ch
wait_key
	ldx $d40b
	txa
	sta $400,x
	lda #$ff
	cmp ch
	beq wait_key

	jsr motor.on
	mva #1 tape.active
	
loop	jsr tape.get_status
	seq
	lda #14
	sta colpm0
	jmp loop

;---------------------------------------------------------------
	.proc vbi

	jsr tape.read_frame
	jmp sysvbv
	.endp

	.proc deferred_vbi
	lda #8
	sta $d01a
	jsr tape.print_counters
	lda #0
	sta $d01a
	jsr handle_time
	jsr handle_keys
	jmp xitvbv
	.endp

	.proc handle_time
	lda tape.active
	beq skip
	lda tape.measure_time+1
	beq waiting
	
	cpw tape.state_time #75		;1.5 seconds
	bcc skip
	jmp do_restart

waiting	cpw tape.state_time #400	;8 seconds
	bcc skip

do_restart
	ldx #$ff
	txs
	jsr tape.init
	cli
	jmp restart
	
skip	rts
	.endp

	.proc handle_keys
	ldy ch
	cpy #$ff
	sne
	rts
	
	lda (121),y
	cmp #27
	beq esc
	rts

esc	jsr tape.init
	mva #$ff ch	
	rts
	.endp

;---------------------------------------------------------------
	icl "BadAppleHD-Tape.asm"

	run start
