/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;

public final class FileDrop {
    private static String ZERO_CHAR_STRING = String.valueOf('\u0000');
    DropTargetListener dropListener;
    Border normalBorder;

    public FileDrop(Component c, boolean recursive, Listener listener) {
        if (c == null) {
            throw new IllegalArgumentException("Parameter 'c' must not be null.");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Parameter 'listener' must not be null.");
        }
        Color borderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
        MatteBorder dragBorder = BorderFactory.createMatteBorder(2, 2, 2, 2, borderColor);
        this.dropListener = new FileDropTargetListener(dragBorder, c, listener);
        this.makeDropTarget(c, recursive);
    }

    private void makeDropTarget(final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            throw new RuntimeException(e);
        }
        c.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent event) {
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                } else {
                    new DropTarget(c, FileDrop.this.dropListener);
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            int i = 0;
            while (i < comps.length) {
                this.makeDropTarget(comps[i], recursive);
                ++i;
            }
        }
    }

    static File[] createFileArray(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            throw new IllegalArgumentException("Parameter 'bufferedReader' must not be null.");
        }
        try {
            ArrayList<File> list = new ArrayList<File>();
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    File file = new File(new URI(line));
                    list.add(file);
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
            }
            return list.toArray(new File[list.size()]);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    static boolean isDraggingFileList(DropTargetDragEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("Parameter 'event' must not be null.");
        }
        DataFlavor[] flavors = event.getCurrentDataFlavors();
        boolean ok = false;
        int i = 0;
        while (!ok && i < flavors.length) {
            DataFlavor curFlavor = flavors[i];
            if (curFlavor.equals(DataFlavor.javaFileListFlavor) || curFlavor.isRepresentationClassReader()) {
                ok = true;
            }
            ++i;
        }
        return ok;
    }

    private final class FileDropTargetListener
    implements DropTargetListener {
        private final Border dragBorder;
        private final Component c;
        private final Listener listener;

        public FileDropTargetListener(Border dragBorder, Component c, Listener listener) {
            this.dragBorder = dragBorder;
            this.c = c;
            this.listener = listener;
        }

        @Override
        public void dragEnter(DropTargetDragEvent event) {
            if (FileDrop.isDraggingFileList(event) && this.listener.isDropAllowed()) {
                if (this.c instanceof JComponent) {
                    JComponent jc = (JComponent)this.c;
                    FileDrop.this.normalBorder = jc.getBorder();
                    jc.setBorder(this.dragBorder);
                }
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent event) {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            try {
                try {
                    Transferable transferable = event.getTransferable();
                    if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        event.acceptDrop(1);
                        List fileList = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        File[] files = new File[fileList.size()];
                        fileList.toArray(files);
                        this.listener.filesDropped(files);
                        event.getDropTargetContext().dropComplete(true);
                    } else {
                        DataFlavor[] flavors = transferable.getTransferDataFlavors();
                        boolean handled = false;
                        int zz = 0;
                        while (zz < flavors.length) {
                            if (flavors[zz].isRepresentationClassReader()) {
                                event.acceptDrop(1);
                                Reader reader = flavors[zz].getReaderForText(transferable);
                                BufferedReader br = new BufferedReader(reader);
                                this.listener.filesDropped(FileDrop.createFileArray(br));
                                event.getDropTargetContext().dropComplete(true);
                                handled = true;
                                break;
                            }
                            ++zz;
                        }
                        if (!handled) {
                            event.rejectDrop();
                        }
                    }
                }
                catch (IOException io) {
                    throw new RuntimeException(io);
                }
                catch (UnsupportedFlavorException ufe) {
                    event.rejectDrop();
                    if (this.c instanceof JComponent) {
                        JComponent jc = (JComponent)this.c;
                        jc.setBorder(FileDrop.this.normalBorder);
                    }
                }
            }
            finally {
                if (this.c instanceof JComponent) {
                    JComponent jc = (JComponent)this.c;
                    jc.setBorder(FileDrop.this.normalBorder);
                }
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            if (this.c instanceof JComponent) {
                JComponent jc = (JComponent)this.c;
                jc.setBorder(FileDrop.this.normalBorder);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (FileDrop.isDraggingFileList(event)) {
                event.acceptDrag(1);
            } else {
                event.rejectDrag();
            }
        }
    }

    public static interface Listener {
        public boolean isDropAllowed();

        public void filesDropped(File[] var1);
    }
}

