/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.console;

import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.MessageQueueEntry;
import com.wudsn.tools.base.common.MessageQueueRenderer;

public final class Console
implements MessageQueueRenderer {
    @Override
    public void displayMessageQueue(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        for (MessageQueueEntry messageQueueEntry : messageQueue.getEntries()) {
            this.setStatus(messageQueueEntry);
        }
    }

    @Override
    public void displayStatusMessage(MessageQueueEntry messageQueueEntry) {
        if (messageQueueEntry == null) {
            throw new IllegalArgumentException("Parameter 'messageQueueEntry' must not be null.");
        }
        this.setStatus(messageQueueEntry);
    }

    private void setStatus(MessageQueueEntry messageQueueEntry) {
        int severity = messageQueueEntry.getMessage().getSeverity();
        String messageText = String.valueOf(messageQueueEntry.getMessage().getId()) + " - " + messageQueueEntry.getMessageText();
        switch (severity) {
            case 1: 
            case 2: {
                this.println("INFO:  " + messageText);
                break;
            }
            case 3: {
                System.err.println("ERROR: " + messageText);
                System.err.flush();
                break;
            }
            default: {
                throw new IllegalStateException("Field 'severity' has illegal value " + severity + ".");
            }
        }
    }

    public void println(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter 'string' must not be null.");
        }
        System.out.println(string);
        System.out.flush();
    }

    public void exit(boolean errorOccurred) {
        System.exit(errorOccurred ? 1 : 0);
    }
}

