/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.productions.atari800.atarirommaker.model;

import com.wudsn.productions.atari800.atarirommaker.DataTypes;
import com.wudsn.productions.atari800.atarirommaker.Messages;
import com.wudsn.productions.atari800.atarirommaker.model.CartridgeTypeWrapper;
import com.wudsn.tools.base.atari.CartridgeFileUtility;
import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.repository.Attribute;
import java.io.File;
import java.util.List;

public final class ROM {
    private byte[] content = new byte[0];

    public boolean load(File file, MessageQueue messageQueue) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        try {
            this.content = FileUtility.readBytes(file, 0x8000000L, true);
        }
        catch (CoreException ex) {
            messageQueue.sendMessage(ex.createMessageQueueEntry(this, Attributes.FILE_PATH));
            return false;
        }
        messageQueue.sendMessage(this, null, Messages.I100, file.getAbsolutePath(), TextUtility.formatAsMemorySize(file.length()));
        return true;
    }

    public boolean save(File file, MessageQueue messageQueue) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        try {
            FileUtility.writeBytes(file, this.content);
        }
        catch (CoreException ex) {
            messageQueue.sendMessage(ex.createMessageQueueEntry(this, Attributes.FILE_PATH));
            return false;
        }
        messageQueue.sendMessage(this, null, Messages.I101, file.getAbsolutePath(), TextUtility.formatAsMemorySize(file.length()));
        return true;
    }

    public boolean convertToCAR(String cartridgeTypeId, MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        CartridgeType cartridgeType = null;
        List<CartridgeType> cartridgeTypes = CartridgeType.getValues();
        int i = 0;
        while (i < cartridgeTypes.size() && cartridgeType == null) {
            if (Integer.toString(cartridgeTypes.get(i).getNumericId()).equals(cartridgeTypeId)) {
                cartridgeType = cartridgeTypes.get(i);
            }
            ++i;
        }
        if (cartridgeType == null) {
            messageQueue.sendMessage(this, Attributes.CARTRDIGE_TYPE, Messages.E103, cartridgeTypeId);
            return false;
        }
        return this.convertToCAR(cartridgeType, messageQueue);
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public boolean isValidCAR() {
        int cartridgeTypeNumericID = CartridgeFileUtility.getCartridgeTypeNumericId(this.content);
        if (cartridgeTypeNumericID == 0) {
            return false;
        }
        CartridgeType cartridgeType = CartridgeType.getInstance(cartridgeTypeNumericID);
        if (cartridgeType == null) {
            return false;
        }
        byte[] newContent = new byte[this.content.length - 16];
        System.arraycopy(this.content, 16, newContent, 0, newContent.length);
        byte[] newHeader = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeType.getNumericId(), newContent);
        int i = 0;
        while (i < newHeader.length) {
            if (this.content[i] != newHeader[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean convertToCAR(CartridgeType cartridgeType, MessageQueue messageQueue) {
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (this.isEmpty()) {
            messageQueue.sendMessage(this, Attributes.CONTENT, Messages.E209, new String[0]);
            return false;
        }
        String cartridgeTypeText = new CartridgeTypeWrapper(cartridgeType).toString();
        long sourceSize = this.content.length;
        long targetSize = cartridgeType.getSizeInKB() * 1024;
        if (sourceSize != targetSize) {
            messageQueue.sendMessage(this, Attributes.CARTRDIGE_TYPE, Messages.E104, TextUtility.formatAsMemorySize(sourceSize), TextUtility.formatAsMemorySize(targetSize), cartridgeTypeText);
            return false;
        }
        byte[] header = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(cartridgeType.getNumericId(), this.content);
        byte[] newContent = new byte[header.length + this.content.length];
        System.arraycopy(header, 0, newContent, 0, header.length);
        System.arraycopy(this.content, 0, newContent, header.length, this.content.length);
        this.content = newContent;
        messageQueue.sendMessage(this, null, Messages.I102, cartridgeTypeText);
        return true;
    }

    public boolean convertToROM(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        if (this.isEmpty()) {
            messageQueue.sendMessage(this, Attributes.CONTENT, Messages.E209, new String[0]);
            return false;
        }
        if (!this.isValidCAR()) {
            messageQueue.sendMessage(this, Attributes.CARTRDIGE_TYPE, Messages.E207, new String[0]);
            return false;
        }
        byte[] newContent = new byte[this.content.length - 16];
        System.arraycopy(this.content, 16, newContent, 0, newContent.length);
        this.content = newContent;
        messageQueue.sendMessage(this, null, Messages.I208, TextUtility.formatAsMemorySize(this.content.length));
        return true;
    }

    public static final class Attributes {
        public static final Attribute FILE_PATH = new Attribute("filePath", DataTypes.ROM_FilePath);
        public static final Attribute CARTRDIGE_TYPE = new Attribute("cartridgeType", DataTypes.ROM_CartridgeType);
        public static final Attribute CONTENT = new Attribute("content", DataTypes.ROM_Content);

        private Attributes() {
        }
    }
}

