/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.productions.atari800.atarirommaker;

import com.wudsn.productions.atari800.atarirommaker.AtariROMMakerConsole;
import com.wudsn.productions.atari800.atarirommaker.Messages;
import com.wudsn.productions.atari800.atarirommaker.Texts;
import com.wudsn.productions.atari800.atarirommaker.model.CartridgeTypeWrapper;
import com.wudsn.productions.atari800.atarirommaker.model.ROM;
import com.wudsn.tools.base.Actions;
import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.common.Application;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.Desktop;
import com.wudsn.tools.base.gui.ElementFactory;
import com.wudsn.tools.base.gui.FileDrop;
import com.wudsn.tools.base.gui.MainWindow;
import com.wudsn.tools.base.gui.StandardDialog;
import com.wudsn.tools.base.repository.Action;
import com.wudsn.tools.base.repository.Message;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;

public final class AtariROMMaker
implements FileDrop.Listener {
    static final int FOLDER_MODE_UNDEFINED = 0;
    static final int FOLDER_MODE_YES = 1;
    static final int FOLDER_MODE_NO = 2;
    static AtariROMMaker instance;
    private MessageQueue messageQueue;
    private ROM rom;
    private MainWindow mainWindow;
    private JFrame mainWindowFrame;
    private JLabel logLabel;
    private String logText;
    private FileDrop fileDrop;
    private boolean cancelled;

    public static void main(final String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.createInstance("http://www.wudsn.com/productions/atari800/atarirommaker/atarirommaker.zip", "AtariROMMaker.jar", "com/wudsn/tools/atarirommaker/AtariROMMaker.version");
                instance = new AtariROMMaker();
                instance.run(args);
            }
        });
    }

    AtariROMMaker() {
    }

    void run(String[] args) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        this.messageQueue = new MessageQueue();
        this.rom = new ROM();
        AtariROMMakerConsole console = new AtariROMMakerConsole();
        if (console.runConsoleCommands(args, false, this.rom, this.messageQueue)) {
            return;
        }
        this.createUI();
    }

    private void createUI() {
        this.mainWindow = new MainWindow();
        this.mainWindowFrame = this.mainWindow.getFrame();
        this.mainWindowFrame.setDefaultCloseOperation(3);
        this.mainWindowFrame.setTitle(TextUtility.format(Texts.MainWindow_Title, Application.getInstance().getLocalVersion()));
        ImageIcon imageIcon = ElementFactory.createImageIcon("icons/main-16x16.png");
        this.mainWindowFrame.setIconImage(imageIcon.getImage());
        this.mainWindowFrame.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel(new BorderLayout());
        EmptyBorder labelBorder = new EmptyBorder(0, 5, 5, 5);
        String content = Texts.MainWindow_Text;
        JLabel contentLabel = new JLabel(content);
        contentLabel.setBorder(labelBorder);
        topPanel.add((Component)contentLabel, "North");
        String link = Texts.MainWindow_Link.replace("$url$", Texts.MainWindow_URL);
        JLabel linkLabel = new JLabel(link);
        linkLabel.setBorder(labelBorder);
        linkLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    Desktop.openBrowser(Texts.MainWindow_URL);
                }
            }
        });
        topPanel.add((Component)linkLabel, "South");
        this.mainWindowFrame.add((Component)topPanel, "North");
        this.logLabel = new JLabel();
        this.logLabel.setBorder(labelBorder);
        this.logLabel.setVerticalAlignment(1);
        this.mainWindowFrame.add((Component)new JScrollPane(this.logLabel), "Center");
        this.mainWindowFrame.pack();
        this.mainWindowFrame.setLocationRelativeTo(null);
        this.mainWindowFrame.setVisible(true);
        this.fileDrop = new FileDrop(this.mainWindowFrame, true, this);
    }

    @Override
    public boolean isDropAllowed() {
        return true;
    }

    @Override
    public void filesDropped(File[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Parameter 'files' must not be null.");
        }
        this.clearLog();
        this.cancelled = false;
        this.convertToCAR(files, 0);
    }

    private void convertToCAR(File[] files, int folderMode) {
        if (files == null || files.length == 0) {
            return;
        }
        if (this.cancelled) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            this.convertToCAR(files[i], folderMode);
            ++i;
        }
    }

    private void convertFolderToCAR(File sourceFolder, int folderMode) {
        if (sourceFolder == null) {
            throw new IllegalArgumentException("Parameter 'sourceFolder' must not be null.");
        }
        File[] files = sourceFolder.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        this.logInfo(Messages.I204, TextUtility.formatAsDecimal(files.length), sourceFolder.getAbsolutePath());
        this.convertToCAR(files, folderMode);
    }

    /*
     * WARNING - void declaration
     */
    private void convertToCAR(File sourceFile, int folderMode) {
        void var6_12;
        if (sourceFile == null) {
            throw new IllegalArgumentException("Parameter 'sourceFile' must not be null.");
        }
        if (this.cancelled) {
            return;
        }
        if (sourceFile.isDirectory()) {
            switch (folderMode) {
                case 0: {
                    Action yesAction = Actions.ButtonBar_Yes;
                    Action noAction = Actions.ButtonBar_No;
                    Action result = StandardDialog.showConfirmation(this.mainWindowFrame, TextUtility.format(Texts.FolderDialog_Title, sourceFile.getAbsolutePath()), Texts.FolderDialog_Action, null, new Action[]{yesAction, noAction}, yesAction, noAction)[1];
                    if (result == yesAction) {
                        folderMode = 1;
                        this.convertFolderToCAR(sourceFile, 1);
                    } else {
                        this.logInfo(Messages.I205, sourceFile.getAbsolutePath());
                    }
                    return;
                }
                case 1: {
                    this.convertFolderToCAR(sourceFile, folderMode);
                    return;
                }
                case 2: {
                    return;
                }
            }
        }
        long fileSize = sourceFile.length();
        this.logInfo(Messages.I200, sourceFile.getAbsolutePath());
        this.messageQueue.clear();
        this.rom.load(sourceFile, this.messageQueue);
        if (this.messageQueue.containsError()) {
            this.logError(this.messageQueue.getFirstError().getMessage(), new String[0]);
            return;
        }
        if (this.rom.isValidCAR()) {
            this.logInfo(Messages.I206, new String[0]);
            return;
        }
        ArrayList<CartridgeTypeWrapper> possibleCartridgeTypes = new ArrayList<CartridgeTypeWrapper>();
        for (CartridgeType cartridgeType : CartridgeType.getValues()) {
            if ((long)(cartridgeType.getSizeInKB() * 1024) != fileSize) continue;
            possibleCartridgeTypes.add(new CartridgeTypeWrapper(cartridgeType));
        }
        if (possibleCartridgeTypes.isEmpty()) {
            this.logError(Messages.E201, TextUtility.formatAsMemorySize(fileSize));
            return;
        }
        if (possibleCartridgeTypes.size() == 1) {
            CartridgeTypeWrapper cartridgeTypeWrapper = (CartridgeTypeWrapper)possibleCartridgeTypes.get(0);
        } else {
            Object[] cartridgeTypesArray = possibleCartridgeTypes.toArray(new CartridgeTypeWrapper[possibleCartridgeTypes.size()]);
            String action = Texts.CartridgeTypeDialog_Action;
            String title = TextUtility.format(Texts.CartridgeTypeDialog_Title, sourceFile.getName());
            CartridgeTypeWrapper cartridgeTypeWrapper = (CartridgeTypeWrapper)JOptionPane.showInputDialog(null, action, title, 3, null, cartridgeTypesArray, cartridgeTypesArray[1]);
            if (cartridgeTypeWrapper == null) {
                this.cancelled = true;
                this.logError(Messages.E202, new String[0]);
                return;
            }
        }
        this.rom.convertToCAR(var6_12.GetCartridgeType(), this.messageQueue);
        if (this.messageQueue.containsError()) {
            this.logError(this.messageQueue.getFirstError().getMessage(), new String[0]);
            return;
        }
        File destinationFile = FileUtility.normalizeFileExtension(sourceFile, ".car");
        this.logInfo(Messages.I203, destinationFile.getAbsolutePath(), var6_12.toString());
        this.rom.save(destinationFile, this.messageQueue);
        if (this.messageQueue.containsError()) {
            this.logError(this.messageQueue.getFirstError().getMessage(), new String[0]);
            return;
        }
    }

    private void clearLog() {
        this.logText = "";
        this.logLabel.setText("");
    }

    private void logInternal(String line) {
        this.logText = String.valueOf(this.logText) + line + "<br>";
        this.logLabel.setText("<html>" + this.logText + "</html>");
        this.mainWindowFrame.pack();
    }

    private void logInfo(Message message, String ... parameters) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        this.logInternal(message.format(parameters));
    }

    private void logError(Message message, String ... parameters) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        this.logInternal("<font color='red'>" + message.format(parameters) + "</font>");
    }

    public final class Commands {
        public static final String LOAD = "load";
        public static final String CONVERT_TO_CAR = "convertToCAR";
        public static final String CONVERT_TO_ROM = "convertToROM";
        public static final String SAVE = "save";
    }
}

