/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import com.wudsn.tools.base.common.JDK;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.AttributeTableModel;
import com.wudsn.tools.base.gui.AttributeTablePanel;
import com.wudsn.tools.base.gui.ValueSetField;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.thecartstudio.Texts;
import com.wudsn.tools.thecartstudio.model.ContentType;
import com.wudsn.tools.thecartstudio.model.DisplayMode;
import com.wudsn.tools.thecartstudio.model.FileHeaderType;
import com.wudsn.tools.thecartstudio.model.Preferences;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookEntryType;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import com.wudsn.tools.thecartstudio.ui.ContentTypeComboxBoxModelFactory;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public final class WorkbookEntriesPanel
extends AttributeTablePanel {
    private Workbook workbook;

    public WorkbookEntriesPanel(Preferences preferences, Workbook workbook) {
        super(new TableModel(workbook), preferences, "workbookEntriesTable");
        this.workbook = workbook;
        workbook.setEntriesTableModel((AttributeTableModel)this.getTable().getModel());
    }

    public void setSelectedWorkbookEntry(WorkbookEntry workbookEntry, Attribute attribute) {
        if (workbookEntry == null) {
            throw new IllegalArgumentException("Parameter 'workbookEntry' must not be null.");
        }
        WorkbookRoot root = this.workbook.getRoot();
        int modelRowIndex = root.getUnmodifiableEntriesList().indexOf(workbookEntry);
        this.table.selectCell(modelRowIndex, attribute);
    }

    public void removeSelectedWorkbookEntries(MessageQueue messageQueue) {
        int size;
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        int[] selectedViewRowIndexes = this.table.getSelectedRows();
        int[] selectedModelRowIndexes = new int[selectedViewRowIndexes.length];
        int i = 0;
        while (i < selectedViewRowIndexes.length) {
            selectedModelRowIndexes[i] = this.table.convertRowIndexToModel(selectedViewRowIndexes[i]);
            ++i;
        }
        this.workbook.removeEntries(selectedModelRowIndexes, messageQueue);
        int minRow = 0;
        if (selectedViewRowIndexes.length > 0) {
            minRow = selectedViewRowIndexes[0];
        }
        if (minRow > (size = this.workbook.getRoot().getEntryCount()) - 1) {
            --minRow;
        }
        this.table.getSelectionModel().setSelectionInterval(minRow, minRow);
    }

    public void setSelectedWorkbookEntriesGenre(String genreName, MessageQueue messageQueue) {
        if (genreName == null) {
            throw new IllegalArgumentException("Parameter 'genreName' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        int[] selectedViewRowIndexes = this.table.getSelectedRows();
        int[] selectedModelRowIndexes = new int[selectedViewRowIndexes.length];
        int i = 0;
        while (i < selectedViewRowIndexes.length) {
            selectedModelRowIndexes[i] = this.table.convertRowIndexToModel(selectedViewRowIndexes[i]);
            ++i;
        }
        this.workbook.setEntriesGenreName(genreName, selectedModelRowIndexes, messageQueue);
    }

    @Override
    public void dataToUI() {
        ((TableModel)this.getTable().getModel()).updateFromWorkbook();
    }

    public static final class TableModel
    extends AttributeTableModel {
        private Workbook workbook;
        Font monoSpacedFont;
        ContentTypeComboxBoxModelFactory contentTypeComboxBoxModelFactory;
        private List<String> genreNamesList;
        private JDK.DefaultComboBoxModel<String> genreComboBoxModel;

        public TableModel(final Workbook workbook) {
            if (workbook == null) {
                throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
            }
            this.workbook = workbook;
            HashMap<TextAttribute, String> attributes = new HashMap<TextAttribute, String>();
            attributes.put(TextAttribute.FAMILY, "Monospaced");
            this.monoSpacedFont = Font.getFont(attributes);
            this.addColumn(WorkbookEntry.Attributes.ID, 2);
            this.addColumn(WorkbookEntry.Attributes.TYPE, 4);
            this.addColumn(WorkbookEntry.Attributes.TITLE, 5);
            this.genreNamesList = Collections.emptyList();
            this.genreComboBoxModel = new JDK.DefaultComboBoxModel();
            JDK.JComboBox<String> genreComboBox = new JDK.JComboBox<String>((JDK.ComboBoxModel<String>)this.genreComboBoxModel);
            genreComboBox.setEditable(true);
            this.addColumn(WorkbookEntry.Attributes.GENRE_NAME, 6, null, new DefaultCellEditor(genreComboBox));
            this.addColumn(WorkbookEntry.Attributes.FAVORITE_INDICATOR, 6);
            this.addColumn(WorkbookEntry.Attributes.FILE_PATH, 4);
            this.addColumn(WorkbookEntry.Attributes.FILE_NAME, 6);
            this.addColumn(WorkbookEntry.Attributes.FILE_SIZE, 4);
            this.addColumn(WorkbookEntry.Attributes.FILE_HEADER_TYPE, 4);
            this.addColumn(WorkbookEntry.Attributes.CONTENT_SIZE, 4);
            this.addColumn(WorkbookEntry.Attributes.CONTENT_CRC32, 4, new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    int crc32 = (Integer)value;
                    if (crc32 == 0) {
                        this.setText("");
                    } else {
                        this.setText(Long.toHexString((long)crc32 & 0xFFFFFFFFL).toUpperCase());
                    }
                    this.setFont(TableModel.this.monoSpacedFont);
                }
            }, null);
            this.addColumn(WorkbookEntry.Attributes.CONTENT_TYPE, 6, null, new DefaultCellEditor(new ValueSetField<ContentType>(ContentType.class)){

                @Override
                public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int viewRowIndex, int viewColumnIndex) {
                    Component component = super.getTableCellEditorComponent(table, value, isSelected, viewRowIndex, viewColumnIndex);
                    JDK.JComboBox comboBox = (JDK.JComboBox)component;
                    int modelRowIndex = table.convertRowIndexToModel(viewRowIndex);
                    WorkbookRoot root = workbook.getRoot();
                    WorkbookEntry entry = root.getEntry(modelRowIndex);
                    boolean filterByFileContentSize = entry.getType() == WorkbookEntryType.FILE_ENTRY;
                    int fileContentSize = entry.getRequiredBanksCount() * root.getBankSize();
                    ContentType currentValue = entry.getContentType();
                    comboBox.setModel(ContentTypeComboxBoxModelFactory.getModel(filterByFileContentSize, fileContentSize, root.getFlashTargetType(), currentValue));
                    comboBox.setSelectedItem(currentValue);
                    return component;
                }
            });
            this.addColumn(WorkbookEntry.Attributes.DISPLAY_MODE, 6, null, new DefaultCellEditor(new ValueSetField<DisplayMode>(DisplayMode.class)));
            this.addColumn(WorkbookEntry.Attributes.PARAMETERS, 4);
            this.addColumn(WorkbookEntry.Attributes.START_BANK_FIXED_INDICATOR, 4);
            this.addColumn(WorkbookEntry.Attributes.START_BANK, 4, new DefaultTableCellRenderer(){

                @Override
                protected void setValue(Object value) {
                    int startBank = (Integer)value;
                    if (startBank == -1) {
                        this.setText(Texts.WorkbookEntry_StartBankUndefined);
                        this.setHorizontalAlignment(4);
                    } else {
                        this.setText(TextUtility.formatAsDecimal(startBank));
                        this.setHorizontalAlignment(4);
                    }
                }
            }, null);
            this.addColumn(WorkbookEntry.Attributes.REQUIRED_BANKS_COUNT, 4);
            this.addColumn(WorkbookEntry.Attributes.BANKS_ASSIGNED_INDICATOR, 6);
        }

        public void updateFromWorkbook() {
            List<String> genreNamesList = this.workbook.getRoot().getSortedGenreNamesList();
            if (!genreNamesList.equals(this.genreNamesList)) {
                this.genreComboBoxModel.removeAllElements();
                for (String genreName : genreNamesList) {
                    this.genreComboBoxModel.addElement(genreName);
                }
                this.genreNamesList = genreNamesList;
            }
        }

        @Override
        public int getRowCount() {
            return this.workbook.getRoot().getEntryCount();
        }

        @Override
        public Object getValueAt(int row, int column) {
            WorkbookEntry entry = this.workbook.getRoot().getEntry(row);
            switch (column) {
                case 0: {
                    return this.table.convertRowIndexToView(row) + 1;
                }
                case 1: {
                    return entry.getType();
                }
                case 2: {
                    return entry.getTitle();
                }
                case 3: {
                    return entry.getGenreName();
                }
                case 4: {
                    return entry.getFavoriteIndicator();
                }
                case 5: {
                    return entry.getFilePath();
                }
                case 6: {
                    if (entry.getType() == WorkbookEntryType.FILE_ENTRY) {
                        return entry.getFileName();
                    }
                    return Texts.WorkbookEntry_FileNameUndefined;
                }
                case 7: {
                    return entry.getFileSize();
                }
                case 8: {
                    return entry.getFileHeaderType();
                }
                case 9: {
                    return entry.getContentSize();
                }
                case 10: {
                    return entry.getContentCRC32();
                }
                case 11: {
                    return entry.getContentType();
                }
                case 12: {
                    return entry.getDisplayMode();
                }
                case 13: {
                    return entry.getParameters();
                }
                case 14: {
                    return entry.isStartBankFixed();
                }
                case 15: {
                    return entry.getStartBankNumber();
                }
                case 16: {
                    return entry.getRequiredBanksCount();
                }
                case 17: {
                    return entry.areBanksAssigned();
                }
            }
            throw new IllegalArgumentException("Invalid column " + column + ".");
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            WorkbookEntry entry = this.workbook.getRoot().getEntry(row);
            switch (column) {
                case 1: {
                    return false;
                }
                case 2: {
                    return true;
                }
                case 3: {
                    return true;
                }
                case 4: {
                    return true;
                }
                case 11: {
                    return entry.getType().equals(WorkbookEntryType.FILE_ENTRY) && entry.getFileHeaderType() != FileHeaderType.CART || entry.getType().equals(WorkbookEntryType.USER_SPACE_ENTRY);
                }
                case 12: {
                    return true;
                }
                case 13: {
                    return true;
                }
                case 14: {
                    return entry.getType().equals(WorkbookEntryType.FILE_ENTRY);
                }
                case 15: {
                    return entry.isStartBankFixed();
                }
            }
            return false;
        }

        @Override
        public void setValueAt(Object value, int row, int column) {
            try {
                WorkbookEntry entry = this.workbook.getRoot().getEntry(row);
                switch (column) {
                    case 2: {
                        entry.setTitle(value.toString());
                        break;
                    }
                    case 3: {
                        entry.setGenreName(value.toString());
                        break;
                    }
                    case 4: {
                        entry.setFavoriteIndicator((Boolean)value);
                        break;
                    }
                    case 11: {
                        entry.setContentType((ContentType)value);
                        break;
                    }
                    case 12: {
                        entry.setDisplayMode((DisplayMode)value);
                        break;
                    }
                    case 13: {
                        entry.setParameters(value.toString());
                        break;
                    }
                    case 14: {
                        entry.setStartBankFixedIndicator((Boolean)value);
                        break;
                    }
                    case 15: {
                        if (entry.areBanksAssigned()) {
                            this.workbook.unassignBanks(entry);
                        }
                        entry.setStartBankNumber((Integer)value);
                        this.workbook.assignBanks(entry, entry.getStartBankNumber());
                        this.fireTableCellUpdated(row, 17);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid or not editable column " + column + ".");
                    }
                }
                this.fireTableCellUpdated(row, column);
            }
            catch (RuntimeException ignore) {
                Log.logError("Inconsistent workbook entries table", null, ignore);
            }
        }

        public final class Columns {
            public static final int ID = 0;
            public static final int TYPE = 1;
            public static final int TITLE = 2;
            public static final int GENRE_NAME = 3;
            public static final int FAVORITE = 4;
            public static final int FILE_PATH = 5;
            public static final int FILE_NAME = 6;
            public static final int FILE_SIZE = 7;
            public static final int FILE_HEADER_TYPE = 8;
            public static final int CONTENT_SIZE = 9;
            public static final int CONTENT_CRC32 = 10;
            public static final int CONTENT_TYPE = 11;
            public static final int DISPLAY_MODE = 12;
            public static final int PARAMETERS = 13;
            public static final int START_BANK_FIXED = 14;
            public static final int START_BANK = 15;
            public static final int BANKS_REQUIRED = 16;
            public static final int BANKS_ASSIGNED = 17;
        }
    }
}

