/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.thecartstudio.Texts;

public final class ExportFormat {
    public static final int BIN_IMAGE = 1;
    public static final int CAR_IMAGE = 2;
    public static final int ATR_IMAGE = 3;
    public static final int ATR_IMAGES = 4;

    private ExportFormat() {
    }

    public static String getFileExtension(int exportFormat) {
        switch (exportFormat) {
            case 1: {
                return ".bin";
            }
            case 2: {
                return ".car";
            }
            case 3: {
                return ".atr";
            }
            case 4: {
                return ".atr";
            }
        }
        throw new IllegalArgumentException("Unsupported export format " + exportFormat + ".");
    }

    public static String getFileFilterDescription(int exportFormat) {
        switch (exportFormat) {
            case 1: {
                return Texts.ExportFormat_BIN_IMAGE_FileFilterDescription;
            }
            case 2: {
                return Texts.ExportFormat_CAR_IMAGE_FileFilterDescription;
            }
            case 3: {
                return Texts.ExportFormat_ATR_IMAGE_FileFilterDescription;
            }
            case 4: {
                return Texts.ExportFormat_ATR_IMAGES_FileFilterDescription;
            }
        }
        throw new RuntimeException("Unknown export format " + exportFormat + ".");
    }

    public static final class FileExtensions {
        public static final String BIN_IMAGE = ".bin";
        public static final String CAR_IMAGE = ".car";
        public static final String ATR_IMAGE = ".atr";
        public static final String ATR_IMAGES = ".atr";
    }
}

