/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.directory;

import com.wudsn.tools.base.gui.HTMLWriter;
import com.wudsn.tools.thecartstudio.directory.Directory;
import com.wudsn.tools.thecartstudio.directory.DirectoryEntry;
import com.wudsn.tools.thecartstudio.directory.DirectoryRecord;
import com.wudsn.tools.thecartstudio.directory.DirectoryWriter;
import com.wudsn.tools.thecartstudio.directory.RecordIdComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class DirectoryLevel
extends DirectoryEntry {
    private String prefix = "";
    private char character = '\u0000';
    private List<String> words = new ArrayList<String>();
    private Map<String, DirectoryLevel> children = new TreeMap<String, DirectoryLevel>();
    private List<DirectoryRecord> records = new ArrayList<DirectoryRecord>();

    void setPrefix(String prefix) {
        if (prefix == null) {
            throw new IllegalArgumentException("Parameter 'prefix' must not be null.");
        }
        this.prefix = prefix;
        if (prefix.length() > 0) {
            this.character = prefix.charAt(prefix.length() - 1);
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public char getCharacter() {
        return this.character;
    }

    public List<DirectoryRecord> getRecords() {
        return this.records;
    }

    public List<String> getWords() {
        return this.words;
    }

    @Override
    public int getRawSize() {
        return 1 + this.children.size() * 3 + this.records.size() * 2 + 2;
    }

    void createChildren(Directory directory, int prefixLength) {
        if (directory == null) {
            throw new IllegalArgumentException("Parameter 'directory' must not be null.");
        }
        if (this.words.isEmpty()) {
            return;
        }
        String currentWord = null;
        String currentPrefix = null;
        DirectoryLevel child = null;
        String lastPrefix = null;
        int i = 1;
        while (i < this.words.size()) {
            currentWord = this.words.get(i);
            currentPrefix = currentWord.substring(0, prefixLength);
            if (i == 1 || !currentPrefix.equals(lastPrefix)) {
                child = directory.createLevel();
                this.children.put(currentPrefix.substring(prefixLength - 1), child);
                child.setPrefix(currentPrefix);
                child.words.add(currentWord);
                lastPrefix = currentPrefix;
            } else {
                child.words.add(currentWord);
            }
            for (DirectoryRecord record : this.records) {
                if (!record.getWords().contains(currentWord) || child.getRecords().contains(record)) continue;
                child.getRecords().add(record);
            }
            Collections.sort(child.getRecords(), new RecordIdComparator());
            ++i;
        }
        for (DirectoryLevel child2 : this.children.values()) {
            child2.createChildren(directory, prefixLength + 1);
        }
    }

    @Override
    void writeAsBinary(DirectoryWriter directoryWriter) {
        if (directoryWriter == null) {
            throw new IllegalArgumentException("Parameter 'directoryWriter' must not be null.");
        }
        directoryWriter.writeByte(this.children.size());
        for (DirectoryLevel child : this.children.values()) {
            directoryWriter.writeByte(child.character);
            directoryWriter.writeWord(child.getId());
        }
        for (DirectoryRecord record : this.records) {
            directoryWriter.writeWord(record.getId());
        }
        directoryWriter.writeWord(0);
        directoryWriter.writePaddingBytes(this.paddingBytes);
    }

    @Override
    void writeAsHTML(HTMLWriter htmlWriter) {
        if (htmlWriter == null) {
            throw new IllegalArgumentException("Parameter 'htmlWriter' must not be null.");
        }
        super.writeAsHTML(htmlWriter);
        htmlWriter.writeTableCell(this.prefix);
        StringBuilder cellBuilder = new StringBuilder();
        for (Map.Entry<String, DirectoryLevel> entry : this.children.entrySet()) {
            cellBuilder.append("<a href=\"#level_" + entry.getValue().getIdString() + "\">");
            cellBuilder.append(entry.getKey());
            cellBuilder.append("</a>");
            cellBuilder.append(" ");
        }
        htmlWriter.writeTableCell(cellBuilder.toString());
        htmlWriter.writeTableCell(Integer.toString(this.records.size()));
        cellBuilder.setLength(0);
        for (DirectoryRecord record : this.records) {
            cellBuilder.append("<a href=\"#record_" + record.getIdString() + "\">");
            cellBuilder.append(record.getIdString());
            cellBuilder.append("</a>");
            cellBuilder.append(" ");
        }
        htmlWriter.writeTableCell(cellBuilder.toString());
    }

    public String toString() {
        return "id=" + this.getIdString() + "prefix=" + this.prefix + "/words=" + this.words.size() + " " + this.words + " records=" + this.records + "/\nchildren=" + this.children + "\n";
    }
}

