/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio;

import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.atari.cartridge.CartridgeDatabase;
import com.wudsn.tools.base.common.Application;
import com.wudsn.tools.base.common.DateUtility;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.Log;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.MessageQueueEntry;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.AttributeTable;
import com.wudsn.tools.base.gui.Desktop;
import com.wudsn.tools.base.gui.ElementFactory;
import com.wudsn.tools.base.gui.FileChooser;
import com.wudsn.tools.base.gui.FileDrop;
import com.wudsn.tools.base.gui.HelpDialog;
import com.wudsn.tools.base.gui.MainWindow;
import com.wudsn.tools.base.gui.StandardDialog;
import com.wudsn.tools.base.gui.StatusBar;
import com.wudsn.tools.base.repository.Action;
import com.wudsn.tools.base.repository.Attribute;
import com.wudsn.tools.base.repository.Message;
import com.wudsn.tools.base.repository.NLS;
import com.wudsn.tools.thecartstudio.Actions;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.Texts;
import com.wudsn.tools.thecartstudio.model.ExportFormat;
import com.wudsn.tools.thecartstudio.model.Exporter;
import com.wudsn.tools.thecartstudio.model.FlashTargetType;
import com.wudsn.tools.thecartstudio.model.Preferences;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookAddEntriesCallback;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;
import com.wudsn.tools.thecartstudio.model.WorkbookExport;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;
import com.wudsn.tools.thecartstudio.ui.AboutDialog;
import com.wudsn.tools.thecartstudio.ui.ContentTypesDialog;
import com.wudsn.tools.thecartstudio.ui.MainMenu;
import com.wudsn.tools.thecartstudio.ui.OptionsDialog;
import com.wudsn.tools.thecartstudio.ui.TheCartStudioConsole;
import com.wudsn.tools.thecartstudio.ui.WorkbookBanksPanel;
import com.wudsn.tools.thecartstudio.ui.WorkbookBanksSummaryPanel;
import com.wudsn.tools.thecartstudio.ui.WorkbookEntriesPanel;
import com.wudsn.tools.thecartstudio.ui.WorkbookOptionsDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public final class TheCartStudio
implements ActionListener,
FileDrop.Listener {
    static TheCartStudio instance;
    private MessageQueue messageQueue = new MessageQueue();
    Preferences preferences;
    CartridgeDatabase cartridgeDatabase;
    Workbook workbook;
    boolean mainWindowReady;
    MainWindow mainWindow;
    JFrame mainWindowFrame;
    MainMenu mainMenu;
    JTabbedPane tabbedPane;
    private WorkbookEntriesPanel workbookEntriesPanel;
    private WorkbookBanksPanel workbookBanksPanel;
    private WorkbookBanksSummaryPanel workbookBanksSummaryPanel;
    private StatusBar statusBar;
    private FileChooser workbookFileChooser;
    private FileChooser entriesFileChooser;
    private FileChooser exportFileChooser;
    private WorkbookOptionsDialog workbookOptionsDialog;
    private OptionsDialog optionsDialog;
    private HelpDialog helpDialog;
    private ContentTypesDialog contentTypesDialog;
    private AboutDialog aboutDialog;
    private FileDrop fileDrop;

    public static void main(final String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Application.createInstance("http://www.wudsn.com/productions/atari800/thecartstudio/thecartstudio.zip", "TheCartStudio.jar", "com/wudsn/tools/thecartstudio/TheCartStudio.version");
                instance = new TheCartStudio();
                instance.run(args);
            }
        });
    }

    TheCartStudio() {
    }

    void run(String[] args) {
        TheCartStudioConsole console;
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        this.cartridgeDatabase = new CartridgeDatabase();
        this.cartridgeDatabase.load();
        this.workbook = new Workbook(this.cartridgeDatabase);
        this.workbook.create(this.messageQueue);
        if (this.messageQueue.containsError()) {
            StandardDialog.showErrorMessage(new JFrame(), this.messageQueue.getFirstError().getMessageText(), Texts.MainWindow_Title);
            this.messageQueue.clear();
        }
        if ((console = new TheCartStudioConsole()).runConsoleCommands(args, false, this.workbook, this.messageQueue)) {
            return;
        }
        this.preferences = new Preferences();
        this.preferences.open(this.messageQueue);
        if (this.messageQueue.containsError()) {
            StandardDialog.showErrorMessage(new JFrame(), this.messageQueue.getFirstError().getMessageText(), Texts.MainWindow_Title);
            this.messageQueue.clear();
        }
        this.createUI();
        this.createFileChoosers();
        this.mainWindowReady = true;
        this.sendMessage(Messages.I100, new String[0]);
        this.dataToUI();
        Application.getInstance().checkForUpdate();
    }

    private void createUI() {
        Locale locale = this.preferences.getLocale();
        Locale.setDefault(locale);
        NLS.initializeLocale(locale.toString());
        this.mainWindow = new MainWindow();
        this.mainWindowFrame = this.mainWindow.getFrame();
        this.mainWindowFrame.setDefaultCloseOperation(0);
        this.mainWindowFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TheCartStudio.this.actionPerformed(new ActionEvent(TheCartStudio.this.mainWindow, 0, "exit"));
            }
        });
        this.mainWindowFrame.setTitle(Texts.MainWindow_Title);
        ImageIcon imageIcon = ElementFactory.createImageIcon("icons/main-16x16.png");
        this.mainWindowFrame.setIconImage(imageIcon.getImage());
        this.mainWindow.setWindowFromPreferences(this.preferences);
        this.mainWindowFrame.setLayout(new BorderLayout());
        this.mainMenu = new MainMenu(this, this.preferences);
        this.mainWindowFrame.add((Component)this.mainMenu.menuBar, "North");
        this.tabbedPane = new JTabbedPane();
        this.workbookEntriesPanel = new WorkbookEntriesPanel(this.preferences, this.workbook);
        ElementFactory.createTab(this.tabbedPane, Actions.MainTabbedPane_EntriesTab, this.workbookEntriesPanel);
        this.workbookBanksPanel = new WorkbookBanksPanel(this, this.preferences, this.workbook);
        ElementFactory.createTab(this.tabbedPane, Actions.MainTabbedPane_BanksTab, this.workbookBanksPanel);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                TheCartStudio.this.actionPerformed(new ActionEvent(TheCartStudio.this.tabbedPane, 0, "dataFromAndToUI"));
            }
        });
        this.mainWindowFrame.add((Component)this.tabbedPane, "Center");
        this.workbookBanksSummaryPanel = new WorkbookBanksSummaryPanel(this.preferences, this.workbook);
        this.statusBar = new StatusBar();
        this.messageQueue.setMessageQueueRenderer(this.statusBar);
        Box bottomBox = Box.createVerticalBox();
        bottomBox.add(this.workbookBanksSummaryPanel);
        bottomBox.add(this.statusBar.getComponent());
        this.mainWindowFrame.add((Component)bottomBox, "South");
        this.workbookOptionsDialog = new WorkbookOptionsDialog(this.mainWindowFrame, this.preferences);
        this.optionsDialog = new OptionsDialog(this.mainWindowFrame);
        this.mainWindowFrame.setVisible(true);
        this.fileDrop = new FileDrop(this.mainWindowFrame, true, this);
    }

    private void createFileChoosers() {
        this.workbookFileChooser = FileChooser.createInstance();
        this.entriesFileChooser = FileChooser.createInstance();
        this.entriesFileChooser.setMultiSelectionEnabled(true);
        this.exportFileChooser = FileChooser.createInstance();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent == null) {
            throw new IllegalArgumentException("Parameter 'actionEvent' must not be null.");
        }
        this.dataFromUI();
        String command = actionEvent.getActionCommand();
        if (!command.equals("dataFromAndToUI")) {
            this.messageQueue.clear();
            this.statusBar.displayMessageQueue(this.messageQueue);
        }
        if (command.equals("new")) {
            this.performShowConfirmSaveDialog(this.mainMenu.newMenuItem, "newConfirmed");
        } else if (command.equals("newConfirmed")) {
            this.performNewFileConfirmed();
        } else if (command.equals("open")) {
            this.performShowConfirmSaveDialog(this.mainMenu.openMenuItem, "openConfirmed");
        } else if (command.startsWith("openRecent")) {
            String filePath = command.substring("openRecent".length() + 1);
            this.performShowConfirmSaveDialog(this.mainMenu.openMenuItem, "openConfirmed:" + filePath);
        } else if (command.startsWith("openConfirmed")) {
            File file;
            int prefixLength = "openConfirmed".length() + 1;
            if (command.length() > prefixLength) {
                String filePath = command.substring(prefixLength);
                file = new File(filePath);
            } else {
                file = null;
            }
            this.performOpenFileConfirmed(file);
        } else if (command.equals("openFolder") && this.mainMenu.openFolderMenuItem.isEnabled()) {
            this.performOpenFolder();
        } else if (command.equals("save") && this.mainMenu.saveMenuItem.isEnabled()) {
            this.performSaveFile(null);
        } else if (command.equals("saveAs") && this.mainMenu.saveAsMenuItem.isEnabled()) {
            this.performSaveFileAs(null);
        } else if (command.equals("close")) {
            this.performShowConfirmSaveDialog(this.mainMenu.closeMenuItem, "closeConfirmed");
        } else if (command.equals("closeConfirmed")) {
            this.performCloseConfirmed();
        } else if (command.equals("exportToBinImage")) {
            this.performExport(this.mainMenu.exportAsBinImageMenuItem, 1);
        } else if (command.equals("exportToCarImage")) {
            this.performExport(this.mainMenu.exportAsCarImageMenuItem, 2);
        } else if (command.equals("exportToAtrImage")) {
            this.performExport(this.mainMenu.exportAsAtrImageMenuItem, 3);
        } else if (command.equals("exportToAtrImages")) {
            this.performExport(this.mainMenu.exportAsAtrImagesMenuItem, 4);
        } else if (command.equals("print")) {
            this.performPrint();
        } else if (command.equals("exit")) {
            this.performShowConfirmSaveDialog(this.mainMenu.exitMenuItem, "exitConfirmed");
        } else if (command.equals("exitConfirmed")) {
            this.performExitConfirmed();
        } else if (command.equals("addEntries") && this.mainMenu.addEntriesMenuItem.isEnabled()) {
            this.performAddEntries();
        } else if (command.equals("addUserSpaceEntry") && this.mainMenu.addUserSpaceEntryMenuItem.isEnabled()) {
            this.performAddUserSpaceEntry();
        } else if (command.equals("removeEntries") && this.mainMenu.removeEntriesMenuItem.isEnabled()) {
            this.performRemoveEntries();
        } else if (command.equals("setGenre") && this.mainMenu.setGenreMenuItem.isEnabled()) {
            this.performSetGenre();
        } else if (command.equals("assignNewBanks") && this.mainMenu.assignNewBanksMenuItem.isEnabled()) {
            this.performAssignNewBanks();
        } else if (command.equals("workbookOptions") && this.mainMenu.workbookOptionsMenuItem.isEnabled()) {
            this.performWorkbookOptions();
        } else if (command.equals("preview") && this.mainMenu.previewMenuItem.isEnabled()) {
            this.performPreview();
        } else if (command.equals("test")) {
            TheCartStudio.performTest();
        } else if (command.equals("options")) {
            this.performOptions();
        } else if (command.equals("helpContents")) {
            this.performHelpDialog();
        } else if (command.equals("helpFileTypes")) {
            this.performFileTypesDialog();
        } else if (command.equals("helpAbout")) {
            this.performAboutDialog();
        }
        this.dataToUI();
    }

    private void performHelpDialog() {
        if (this.helpDialog == null) {
            this.helpDialog = new HelpDialog(this.mainWindowFrame, "help/TheCartStudio.html", 780, 320, null);
        }
        this.helpDialog.show();
    }

    private void performFileTypesDialog() {
        if (this.contentTypesDialog == null) {
            this.contentTypesDialog = new ContentTypesDialog(this.mainWindowFrame, this.preferences);
        }
        this.contentTypesDialog.show();
    }

    private void performAboutDialog() {
        if (this.aboutDialog == null) {
            this.aboutDialog = new AboutDialog(this.mainWindowFrame, this.cartridgeDatabase);
        }
        this.aboutDialog.show();
    }

    private boolean performNewFileConfirmed() {
        if (!this.workbook.create(this.messageQueue)) {
            return false;
        }
        if (this.workbookOptionsDialog.showModal(this.workbook, this.messageQueue)) {
            this.sendMessage(Messages.I104, new String[0]);
            return true;
        }
        this.workbook.close();
        return false;
    }

    private void performOpenFileConfirmed(File file) {
        if (file == null) {
            this.workbookFileChooser.setDialogTitle(Texts.WorkbookFileChooserDialog_Open_Title);
            FileFilter filefilter = FileUtility.createFileExtensionFileFilter(".tcw", Texts.WorkbookFileChooserDialog_FilterDescription);
            this.workbookFileChooser.setFileFilter(filefilter);
            this.workbookFileChooser.setCurrentDirectory(new File(this.preferences.getLastWorkbookFolderPath()));
            int option = this.workbookFileChooser.showOpenDialog(this.mainWindowFrame);
            this.preferences.setLastWorkbookFolderPath(this.workbookFileChooser.getCurrentDirectory().getAbsolutePath());
            if (option != 0) {
                return;
            }
            file = this.workbookFileChooser.getSelectedFile();
        }
        this.preferences.updateRecentWorkBookFileList(file);
        this.workbook.open(file, this.messageQueue);
        if (this.messageQueue.containsError()) {
            return;
        }
        this.sendMessage(Messages.I105, new String[0]);
    }

    private void performOpenFolder() {
        File folder = this.workbook.getFile().getParentFile();
        try {
            Desktop.openFile(folder);
        }
        catch (IOException ex) {
            this.sendMessage(com.wudsn.tools.base.Messages.E215, folder.getAbsolutePath(), ex.getMessage());
        }
    }

    private void performShowConfirmSaveDialog(JMenuItem menuItem, String confirmationCommand) {
        Action cancelAction;
        if (menuItem == null) {
            throw new IllegalArgumentException("Parameter 'menuItem' must not be null.");
        }
        if (confirmationCommand == null) {
            throw new IllegalArgumentException("Parameter 'confirmationCommand' must not be null.");
        }
        if (StringUtility.isEmpty(confirmationCommand)) {
            throw new IllegalArgumentException("Parameter 'confirmationCommand' must not be empty.");
        }
        Action yesAction = Actions.ButtonBar_Save;
        Action noAction = Actions.ButtonBar_DontSave;
        Action result = cancelAction = com.wudsn.tools.base.Actions.ButtonBar_Cancel;
        if (this.workbook.isChanged()) {
            String message = this.workbook.isPersistent() ? Messages.I102.format(this.workbook.getFile().getName()) : Messages.I101.format(this.workbook.getRoot().getTitle());
            Action[] actions = new Action[]{yesAction, noAction, cancelAction};
            result = StandardDialog.showConfirmation(this.mainWindowFrame, menuItem.getToolTipText(), message, null, actions, yesAction, cancelAction)[1];
            if (result == cancelAction) {
                this.sendOperationCancelled(menuItem);
                return;
            }
            if (result == yesAction) {
                this.performSaveFile(confirmationCommand);
                return;
            }
        }
        this.actionPerformed(new ActionEvent(this, 0, confirmationCommand));
    }

    private void performSaveFile(String confirmationCommand) {
        if (!this.workbook.isPersistent()) {
            this.performSaveFileAs(confirmationCommand);
            return;
        }
        this.performSaveFile(this.workbook.getFile(), confirmationCommand);
    }

    private void performSaveFile(final File file, final String confirmationCommand) {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        CommandWorker commandWorker = new CommandWorker(this){

            @Override
            protected void performWork() throws Exception {
                workbook.save(file, messageQueue);
            }

            @Override
            protected void performDone() {
                if (messageQueue.containsError()) {
                    return;
                }
                preferences.updateRecentWorkBookFileList(file);
                this.sendMessage(Messages.I106, new String[0]);
                if (confirmationCommand != null) {
                    this.actionPerformed(new ActionEvent(this, 0, confirmationCommand));
                }
            }
        };
        commandWorker.start();
    }

    private void performSaveFileAs(String confirmationCommand) {
        this.workbookFileChooser.setCurrentDirectory(new File(this.preferences.getLastWorkbookFolderPath()));
        File file = this.workbook.getFile();
        if (file == null) {
            file = new File(this.workbookFileChooser.getCurrentDirectory(), this.workbook.getRoot().getTitle());
        }
        file = FileUtility.normalizeFileExtension(file, ".tcw");
        this.workbookFileChooser.setSelectedFile(file);
        this.workbookFileChooser.setDialogTitle(Texts.WorkbookFileChooserDialog_SaveAs_Title);
        FileFilter filefilter = FileUtility.createFileExtensionFileFilter(".tcw", Texts.WorkbookFileChooserDialog_FilterDescription);
        this.workbookFileChooser.setFileFilter(filefilter);
        int option = this.workbookFileChooser.showSaveDialog(this.mainWindowFrame);
        this.preferences.setLastWorkbookFolderPath(this.workbookFileChooser.getCurrentDirectory().getAbsolutePath());
        if (option != 0) {
            this.sendOperationCancelled(this.mainMenu.saveAsMenuItem);
            return;
        }
        file = this.workbookFileChooser.getSelectedFile();
        file = FileUtility.normalizeFileExtension(file, ".tcw");
        this.performSaveFile(file, confirmationCommand);
    }

    private void performCloseConfirmed() {
        this.workbook.close();
        this.sendMessage(Messages.I107, new String[0]);
    }

    private void performPrint() {
        AttributeTable table = this.workbookEntriesPanel.getTable();
        try {
            String headerText = Messages.I117.format(this.workbook.getRoot().getTitle());
            String subHeaderText = this.workbook.isPersistent() ? this.workbook.getFile().getAbsolutePath() : "";
            String footerText = Messages.I118.format("{0}", DateUtility.getCurrentDateTimeString());
            if (table.print(headerText, subHeaderText, footerText)) {
                this.sendMessage(Messages.I116, new String[0]);
                return;
            }
            this.sendOperationCancelled(this.mainMenu.printMenuItem);
        }
        catch (PrinterException ex) {
            this.sendMessage(Messages.E115, ex.getMessage());
            return;
        }
    }

    private void performExitConfirmed() {
        this.workbook.close();
        this.mainWindow.setPreferencesFromWindow(this.preferences);
        if (this.contentTypesDialog != null) {
            this.contentTypesDialog.getTable().saveLayout();
        }
        this.workbookEntriesPanel.getTable().saveLayout();
        this.preferences.save(this.messageQueue);
        if (this.messageQueue.containsError()) {
            StandardDialog.showErrorMessage(this.mainWindowFrame, this.messageQueue.getFirstError().getMessageText(), Texts.MainWindow_Title);
        }
        System.exit(0);
    }

    private void performExport(final JMenuItem menuItem, final int exportFormat) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Parameter 'menuItem' must not be null.");
        }
        CommandWorker commandWorker = new CommandWorker(this){
            private WorkbookExport workbookExport;

            @Override
            protected void performWork() throws Exception {
                this.workbookExport = workbook.export(exportFormat, messageQueue);
            }

            @Override
            protected void performDone() {
                this.performExportToFile(menuItem, exportFormat, this.workbookExport);
            }
        };
        commandWorker.start();
    }

    private void performExportToFile(JMenuItem menuItem, int exportFormat, WorkbookExport workbookExport) {
        if (this.messageQueue.containsError() || workbookExport == null) {
            return;
        }
        Exporter exporter = new Exporter(workbookExport, this.messageQueue);
        String dialogTitle = menuItem.getText();
        switch (exportFormat) {
            case 1: {
                File file = this.performSelectExportFile(exportFormat, dialogTitle);
                if (file == null) {
                    return;
                }
                exporter.exportAsBinImage(file);
                break;
            }
            case 2: {
                File file = this.performSelectExportFile(exportFormat, dialogTitle);
                if (file == null) {
                    return;
                }
                exporter.exportAsCarImage(file);
                break;
            }
            case 3: {
                File file = this.performSelectExportFile(exportFormat, dialogTitle);
                if (file == null) {
                    return;
                }
                exporter.exportAsAtrImage(file);
                break;
            }
            case 4: {
                File file = this.performSelectExportFile(exportFormat, dialogTitle);
                if (file == null) {
                    return;
                }
                exporter.exportAsAtrImages(file);
                break;
            }
            default: {
                throw new RuntimeException("Unknown export format " + exportFormat + ".");
            }
        }
    }

    private File performSelectExportFile(int exportFormat, String dialogTitle) {
        this.exportFileChooser.setDialogTitle(dialogTitle);
        String fileExtension = ExportFormat.getFileExtension(exportFormat);
        String filterDescription = ExportFormat.getFileFilterDescription(exportFormat);
        FileFilter filefilter = FileUtility.createFileExtensionFileFilter(fileExtension, filterDescription);
        File file = this.exportFileChooser.getSelectedFile();
        if (file == null && (file = this.workbook.getFile()) == null) {
            file = new File(this.workbook.getRoot().getTitle());
        }
        file = FileUtility.normalizeFileExtension(file, fileExtension);
        this.exportFileChooser.setSelectedFile(file);
        this.exportFileChooser.setFileFilter(filefilter);
        this.exportFileChooser.setCurrentDirectory(new File(this.preferences.getLastExportFolderPath()));
        int option = this.exportFileChooser.showSaveDialog(this.mainWindowFrame);
        this.preferences.setLastExportFolderPath(this.exportFileChooser.getCurrentDirectory().getAbsolutePath());
        if (option != 0) {
            this.sendMessage(Messages.I103, dialogTitle);
            return null;
        }
        file = this.exportFileChooser.getSelectedFile();
        file = FileUtility.normalizeFileExtension(file, fileExtension);
        return file;
    }

    private void performAddEntries() {
        this.entriesFileChooser.setDialogTitle(Texts.EntriesFileChooserDialog_AddEntries_Title);
        this.entriesFileChooser.setCurrentDirectory(new File(this.preferences.getLastEntryFolderPath()));
        int option = this.entriesFileChooser.showOpenDialog(this.mainWindowFrame);
        this.preferences.setLastEntryFolderPath(this.entriesFileChooser.getCurrentDirectory().getAbsolutePath());
        if (option != 0) {
            return;
        }
        File[] selectedFiles = this.entriesFileChooser.getSelectedFiles();
        this.performAddEntries(selectedFiles);
    }

    private void performAddEntries(final File[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Parameter 'files' must not be null.");
        }
        this.tabbedPane.setSelectedComponent(this.workbookEntriesPanel);
        final WorkbookAddEntriesCallback callback = new WorkbookAddEntriesCallback(){

            @Override
            public int confirmAdd(String existingEntryTitle, String existingFileName, String newFilePath, String renamedFileName) {
                if (this.addAll) {
                    return this.lastAddResult;
                }
                Action overwriteAction = Actions.ButtonBar_Overwrite;
                Action renameAction = new Action(TextUtility.format(Actions.ButtonBar_Rename.getLabel(), renamedFileName), Actions.ButtonBar_Rename.getToolTip(), null);
                Action skipAction = Actions.ButtonBar_Skip;
                Action yesAllAction = com.wudsn.tools.base.Actions.ButtonBar_YesAll;
                Action yesAction = com.wudsn.tools.base.Actions.ButtonBar_Yes;
                Action cancelAction = com.wudsn.tools.base.Actions.ButtonBar_Cancel;
                String message = Messages.I114.format(existingEntryTitle, existingFileName, newFilePath);
                Action[] result = StandardDialog.showConfirmation(TheCartStudio.this.mainWindowFrame, TheCartStudio.this.mainMenu.addEntriesMenuItem.getText(), message, new Action[]{overwriteAction, renameAction, skipAction}, new Action[]{yesAllAction, yesAction, cancelAction}, overwriteAction, cancelAction);
                Action choiceAction = result[0];
                Action buttonAction = result[1];
                this.lastAddResult = choiceAction == overwriteAction ? 1 : (choiceAction == renameAction ? 2 : 3);
                if (buttonAction == yesAllAction) {
                    this.addAll = true;
                } else if (buttonAction == cancelAction) {
                    this.lastAddResult = -1;
                    this.addAll = true;
                }
                return this.lastAddResult;
            }

            @Override
            public int confirmUseTitleFromCartridgeDatabase(String entryFileName, String cartridgeDatabaseEntryTitle) {
                if (this.useTitleAll) {
                    return this.lastUseTitleResult;
                }
                Action yesAllAction = com.wudsn.tools.base.Actions.ButtonBar_YesAll;
                Action yesAction = com.wudsn.tools.base.Actions.ButtonBar_Yes;
                Action noAction = com.wudsn.tools.base.Actions.ButtonBar_No;
                Action noAllAction = com.wudsn.tools.base.Actions.ButtonBar_NoAll;
                Action cancelAction = com.wudsn.tools.base.Actions.ButtonBar_Cancel;
                String message = Messages.I138.format(cartridgeDatabaseEntryTitle, entryFileName);
                Action[] result = StandardDialog.showConfirmation(TheCartStudio.this.mainWindowFrame, TheCartStudio.this.mainMenu.addEntriesMenuItem.getText(), message, null, new Action[]{yesAllAction, yesAction, noAction, noAllAction, cancelAction}, yesAllAction, cancelAction);
                Action buttonAction = result[1];
                if (buttonAction == yesAction || buttonAction == yesAllAction) {
                    this.lastUseTitleResult = 1;
                    this.useTitleAll = buttonAction == yesAllAction;
                } else if (buttonAction == noAction || buttonAction == noAllAction) {
                    this.lastUseTitleResult = 2;
                    this.useTitleAll = buttonAction == noAllAction;
                } else if (buttonAction == cancelAction) {
                    this.lastUseTitleResult = -1;
                    this.useTitleAll = true;
                }
                return this.lastUseTitleResult;
            }
        };
        CommandWorker commandWorker = new CommandWorker(this){
            private WorkbookEntry firstEntry;

            @Override
            protected void performWork() throws Exception {
                this.firstEntry = workbook.addEntries(files, callback, messageQueue);
            }

            @Override
            protected void performDone() {
                if (!messageQueue.containsError()) {
                    messageQueue.sendMessage(workbook, null, Messages.I108, TextUtility.formatAsDecimal(callback.getAddedEntriesCount()), TextUtility.formatAsDecimal(callback.getUpdatesEntriesCount()), TextUtility.formatAsDecimal(callback.getSkippedEntriesCount()));
                    if (this.firstEntry != null) {
                        this.performShowWorkbookEntry(this.firstEntry, WorkbookEntry.Attributes.ID);
                    }
                    if (callback.isCancelled()) {
                        this.sendOperationCancelled(mainMenu.addEntriesMenuItem);
                    }
                }
            }
        };
        this.messageQueue.clear();
        commandWorker.start();
    }

    private void performAddUserSpaceEntry() {
        this.tabbedPane.setSelectedComponent(this.workbookEntriesPanel);
        this.workbookEntriesPanel.getTable().setColumnVisible(11, true);
        this.workbookEntriesPanel.getTable().setColumnVisible(15, true);
        WorkbookEntry firstEntry = this.workbook.addUserSpaceEntry();
        this.messageQueue.sendMessage(this.workbook, null, Messages.I132, new String[0]);
        this.performShowWorkbookEntry(firstEntry, WorkbookEntry.Attributes.ID);
    }

    @Override
    public boolean isDropAllowed() {
        return this.mainWindowReady;
    }

    @Override
    public void filesDropped(File[] files) {
        if (files == null) {
            throw new IllegalArgumentException("Parameter 'files' must not be null.");
        }
        if (files.length == 0) {
            return;
        }
        this.dataFromUI();
        if (!this.workbook.isValid() && !this.performNewFileConfirmed()) {
            return;
        }
        this.performAddEntries(files);
        this.preferences.setLastEntryFolderPath(files[files.length - 1].getParentFile().getAbsolutePath());
    }

    private void performRemoveEntries() {
        this.workbookEntriesPanel.removeSelectedWorkbookEntries(this.messageQueue);
    }

    public void performShowWorkbookEntry(WorkbookEntry workbookEntry, Attribute attribute) {
        if (workbookEntry == null) {
            throw new IllegalArgumentException("Parameter 'workbookEntry' must not be null.");
        }
        this.tabbedPane.setSelectedComponent(this.workbookEntriesPanel);
        this.workbookEntriesPanel.setSelectedWorkbookEntry(workbookEntry, attribute);
    }

    public void performSetGenre() {
        if (this.workbookEntriesPanel.getTable().getSelectedRowCount() == 0) {
            this.sendMessage(Messages.E129, this.mainMenu.setGenreMenuItem.getText());
            return;
        }
        ArrayList<String> genreNames = new ArrayList<String>(this.workbook.getRoot().getSortedGenreNamesList());
        String none = Texts.GenreName_None;
        genreNames.add(0, none);
        String genreName = (String)JOptionPane.showInputDialog(this.mainWindowFrame, Messages.I119.getShortText(), this.mainMenu.setGenreMenuItem.getText(), -1, null, genreNames.toArray(), none);
        if (genreName == null || StringUtility.isEmpty(genreName)) {
            this.sendOperationCancelled(this.mainMenu.setGenreMenuItem);
            return;
        }
        if (genreName.equals(none)) {
            genreName = "";
        }
        this.workbookEntriesPanel.setSelectedWorkbookEntriesGenre(genreName, this.messageQueue);
    }

    private void performAssignNewBanks() {
        if (this.workbook.getRoot().getCartridgeType().isIncrementalFlashingSupported()) {
            Action yesAction = com.wudsn.tools.base.Actions.ButtonBar_Yes;
            Action noAction = com.wudsn.tools.base.Actions.ButtonBar_No;
            Action result = StandardDialog.showConfirmation(this.mainWindowFrame, this.mainMenu.assignNewBanksMenuItem.getText(), Messages.I124.getShortText(), null, new Action[]{yesAction, noAction}, yesAction, noAction)[1];
            if (result != yesAction) {
                this.sendOperationCancelled(this.mainMenu.assignNewBanksMenuItem);
                return;
            }
        }
        this.workbook.assignNewBanks(this.messageQueue);
        if (!this.messageQueue.containsError()) {
            this.sendMessage(Messages.I125, new String[0]);
        }
    }

    private void performWorkbookOptions() {
        this.workbookOptionsDialog.showModal(this.workbook, this.messageQueue);
    }

    private void performPreview() {
        CommandWorker commandWorker = new CommandWorker(this){
            private WorkbookExport workbookExport;

            /*
             * Unable to fully structure code
             */
            @Override
            protected void performWork() throws Exception {
                this.workbookExport = workbook.export(2, TheCartStudio.access$0(this));
                if (TheCartStudio.access$0(this).containsError()) {
                    return;
                }
                tempFolder = new File(System.getProperty("java.io.tmpdir"));
                file = new File(tempFolder, "TheCartStudio-Preview.car");
                exporter = new Exporter(this.workbookExport, TheCartStudio.access$0(this));
                exporter.exportAsCarImage(file);
                if (TheCartStudio.access$0(this).containsError()) {
                    return;
                }
                emulatorExecutablePath = preferences.getEmulatorExecutablePath();
                if (!StringUtility.isEmpty(emulatorExecutablePath)) ** GOTO lbl-1000
                try {
                    Desktop.openFile(file);
                    return;
                }
                catch (IOException var5_5) lbl-1000:
                // 3 sources

                {
                    ** while (StringUtility.isEmpty((String)emulatorExecutablePath) || !new File((String)emulatorExecutablePath).canExecute())
                }
lbl-1000:
                // 1 sources

                {
                    fileChooser = FileChooser.createInstance();
                    fileChooser.setDialogTitle(Texts.OptionsEmulatorExecutablePathDialog_Title);
                    result = fileChooser.showOpenDialog(mainWindowFrame);
                    if (result == 1) {
                        TheCartStudio.access$0(this).sendMessage(workbook, null, Messages.E428, new String[0]);
                        return;
                    }
                    emulatorExecutablePath = fileChooser.getSelectedFile().getAbsolutePath();
                    continue;
                }
lbl25:
                // 1 sources

                preferences.setEmulatorExecutablePath(emulatorExecutablePath);
                try {
                    Runtime.getRuntime().exec(new String[]{emulatorExecutablePath, file.getAbsolutePath()}, null, new File(emulatorExecutablePath).getParentFile());
                }
                catch (IOException ex) {
                    message = ex.getMessage();
                    TheCartStudio.access$0(this).sendMessage(workbook, null, Messages.E429, new String[]{message});
                    return;
                }
            }

            @Override
            protected void performDone() {
            }
        };
        commandWorker.start();
    }

    private static void performTest() {
        System.out.println(new Date());
    }

    private void performOptions() {
        Locale oldLocale = this.preferences.getLocale();
        this.optionsDialog.showModal(this.preferences);
        if (!oldLocale.equals(this.preferences.getLocale())) {
            this.mainWindowReady = false;
            this.mainWindow.dispose();
            this.createUI();
            this.mainWindowReady = true;
        }
    }

    private void sendMessage(Message message, String ... parameters) {
        if (message == null) {
            throw new IllegalArgumentException("Parameter 'message' must not be null.");
        }
        this.messageQueue.sendMessage(this, null, message, parameters);
    }

    private void sendOperationCancelled(JMenuItem menuItem) {
        if (menuItem == null) {
            throw new IllegalArgumentException("Parameter 'menuItem' must not be null.");
        }
        this.sendMessage(Messages.I103, menuItem.getText());
    }

    private void dataFromUI() {
        this.workbookEntriesPanel.dataFromUI();
    }

    private void dataToUI() {
        boolean hasEntries;
        boolean valid = this.workbook.isValid();
        boolean persistent = this.workbook.isPersistent();
        boolean entriesVisible = this.tabbedPane.getSelectedComponent() == this.workbookEntriesPanel;
        boolean banksVisible = this.tabbedPane.getSelectedComponent() == this.workbookBanksPanel;
        WorkbookRoot root = this.workbook.getRoot();
        boolean bl = hasEntries = root.getEntryCount() > 0;
        String title = valid ? (persistent ? TextUtility.format(Texts.MainWindow_Title_Persistent, root.getTitle(), this.workbook.getFile().getAbsolutePath()) : TextUtility.format(Texts.MainWindow_Title_New, root.getTitle())) : Texts.MainWindow_Title;
        this.mainWindowFrame.setTitle(title);
        this.mainMenu.newMenuItem.setEnabled(this.mainWindowReady);
        this.mainMenu.openMenuItem.setEnabled(this.mainWindowReady);
        this.mainMenu.openFolderMenuItem.setEnabled(this.mainWindowReady && valid && persistent);
        this.mainMenu.saveMenuItem.setEnabled(this.mainWindowReady && valid);
        this.mainMenu.saveAsMenuItem.setEnabled(this.mainWindowReady && valid && persistent);
        this.mainMenu.closeMenuItem.setEnabled(this.mainWindowReady && valid);
        this.mainMenu.printMenuItem.setEnabled(this.mainWindowReady && valid && hasEntries);
        this.mainMenu.exitMenuItem.setEnabled(this.mainWindowReady);
        boolean exportEnabled = this.mainWindowReady && valid && root.getEntryCount() > 0;
        FlashTargetType flashTargetType = root.getFlashTargetType();
        this.mainMenu.exportMenu.setEnabled(exportEnabled);
        this.mainMenu.exportAsBinImageMenuItem.setEnabled(exportEnabled && flashTargetType.isExportFormatSupported(1));
        this.mainMenu.exportAsCarImageMenuItem.setEnabled(exportEnabled && flashTargetType.isExportFormatSupported(2) && root.getCartridgeType() != CartridgeType.UNKNOWN);
        this.mainMenu.exportAsAtrImageMenuItem.setEnabled(exportEnabled && flashTargetType.isExportFormatSupported(3));
        this.mainMenu.exportAsAtrImagesMenuItem.setEnabled(exportEnabled && flashTargetType.isExportFormatSupported(4));
        this.mainMenu.addEntriesMenuItem.setEnabled(this.mainWindowReady && valid);
        this.mainMenu.addUserSpaceEntryMenuItem.setEnabled(this.mainWindowReady && valid && root.getUserSpaceSize() > 0);
        this.mainMenu.removeEntriesMenuItem.setEnabled(this.mainWindowReady && valid && entriesVisible && hasEntries);
        this.mainMenu.setGenreMenuItem.setEnabled(this.mainWindowReady && valid && entriesVisible && hasEntries);
        this.mainMenu.assignNewBanksMenuItem.setEnabled(this.mainWindowReady && valid && hasEntries);
        this.mainMenu.workbookOptionsMenuItem.setEnabled(this.mainWindowReady && valid);
        this.mainMenu.previewMenuItem.setEnabled(this.mainWindowReady && valid && hasEntries);
        this.mainMenu.optionsMenuItem.setEnabled(this.mainWindowReady);
        this.workbookEntriesPanel.dataToUI();
        if (banksVisible) {
            this.workbookBanksPanel.repaint();
        }
        this.workbookBanksSummaryPanel.repaint();
        this.statusBar.displayMessageQueue(this.messageQueue);
        MessageQueueEntry messageQueueEntry = this.messageQueue.getFirstError();
        if (messageQueueEntry == null) {
            messageQueueEntry = this.messageQueue.getFirstInfo();
        }
        if (this.messageQueue.areEntriesChanged() && messageQueueEntry != null) {
            Object owner = messageQueueEntry.getOwner();
            if (owner instanceof WorkbookRoot) {
                this.performWorkbookOptions();
                this.messageQueue.clear();
                this.statusBar.displayMessageQueue(this.messageQueue);
            } else if (owner instanceof WorkbookEntry) {
                if (!entriesVisible) {
                    this.tabbedPane.setSelectedComponent(this.workbookEntriesPanel);
                }
                this.workbookEntriesPanel.setSelectedWorkbookEntry((WorkbookEntry)owner, messageQueueEntry.getAttribute());
            }
        }
    }

    private abstract class CommandWorker
    extends SwingWorker<Void, Void> {
        private Cursor oldCursor;
        private Throwable throwable;

        private CommandWorker() {
        }

        public final void start() {
            this.oldCursor = TheCartStudio.this.mainWindowFrame.getCursor();
            TheCartStudio.this.mainWindowReady = false;
            TheCartStudio.this.mainWindowFrame.setCursor(Cursor.getPredefinedCursor(3));
            this.throwable = null;
            this.execute();
        }

        @Override
        protected final Void doInBackground() throws Exception {
            try {
                this.performWork();
            }
            catch (Throwable th) {
                Log.logError("Exception while executing {0} in background.", new Object[]{this}, th);
                this.throwable = th;
            }
            return null;
        }

        protected abstract void performWork() throws Exception;

        @Override
        protected final void done() {
            TheCartStudio.this.mainWindowFrame.setCursor(this.oldCursor);
            TheCartStudio.this.mainWindowReady = true;
            if (this.throwable == null) {
                this.performDone();
            } else if (this.throwable instanceof OutOfMemoryError) {
                String maximumMemory = Application.getInstance().getMemoryInfo().getMaximumMemoryMB();
                long imageSize = TheCartStudio.this.workbook.getRoot().getImageSize();
                imageSize = (imageSize + 0x100000L - 1L) / 0x100000L * 0x100000L;
                String jvmParameters = "java -Xmx" + imageSize * 2L / 0x100000L + "M -jar TheCartStudio.jar";
                String imageSizeMB = TextUtility.formatAsMemorySize(imageSize);
                TheCartStudio.this.messageQueue.sendMessage(TheCartStudio.this.workbook, null, Messages.E137, maximumMemory, jvmParameters, imageSizeMB);
            } else {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                this.throwable.printStackTrace(printWriter);
                printWriter.close();
                JOptionPane.showMessageDialog(TheCartStudio.this.mainWindowFrame, String.valueOf(stringWriter.toString()) + "\nStart the program from the console to see more details.", this.throwable.getClass().getName(), 0);
            }
            TheCartStudio.this.dataToUI();
        }

        protected abstract void performDone();
    }

    public final class Commands {
        public static final String NEW_FILE = "new";
        public static final String NEW_FILE_CONFIRMED = "newConfirmed";
        public static final String OPEN_FILE = "open";
        public static final String OPEN_FILE_CONFIRMED = "openConfirmed";
        public static final String OPEN_RECENT_FILE = "openRecent";
        public static final String OPEN_FOLDER = "openFolder";
        public static final String SAVE_FILE = "save";
        public static final String SAVE_FILE_AS = "saveAs";
        public static final String CLOSE_FILE = "close";
        public static final String CLOSE_FILE_CONFIRMED = "closeConfirmed";
        public static final String EXPORT_TO_BIN_IMAGE = "exportToBinImage";
        public static final String EXPORT_TO_CAR_IMAGE = "exportToCarImage";
        public static final String EXPORT_TO_ATR_IMAGE = "exportToAtrImage";
        public static final String EXPORT_TO_ATR_IMAGES = "exportToAtrImages";
        public static final String PRINT = "print";
        public static final String EXIT = "exit";
        public static final String EXIT_CONFIRMED = "exitConfirmed";
        public static final String ADD_ENTRIES = "addEntries";
        public static final String ADD_USER_SPACE_ENTRY = "addUserSpaceEntry";
        public static final String REMOVE_ENTRIES = "removeEntries";
        public static final String SET_GENRE = "setGenre";
        public static final String ASSIGN_NEW_BANKS = "assignNewBanks";
        public static final String WORKBOOK_OPTIONS = "workbookOptions";
        public static final String PREVIEW = "preview";
        public static final String TEST = "test";
        public static final String OPTIONS = "options";
        public static final String HELP_CONTENTS = "helpContents";
        public static final String HELP_FILE_CONTENT_TYPES = "helpFileTypes";
        public static final String HELP_ABOUT = "helpAbout";
        public static final String DATA_FROM_AND_TO_UI = "dataFromAndToUI";
        public static final String CREATE_SAMPLE_FILES = "createSampleFiles";
    }
}

