/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.gui;

import com.wudsn.tools.base.Actions;
import com.wudsn.tools.base.gui.ElementFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;

public abstract class SimpleDialog {
    public static final String ACTION_COMMAND_OK = "OK";
    public static final String ACTION_COMMAND_CANCEL = "CANCEL";
    private final JFrame parent;
    private final String title;
    private final boolean modal;
    JDialog dialog;
    private JButton okButton;
    private Action cancelAction;

    protected SimpleDialog(JFrame parent, String title, boolean modal) {
        if (parent == null) {
            throw new IllegalArgumentException("Parameter 'parent' must not be null.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        this.parent = parent;
        this.title = title;
        this.modal = modal;
    }

    public void show() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent, this.title, this.modal);
            this.dialog.setIconImage(this.parent.getIconImage());
            this.initComponents(this.dialog);
        }
        this.dataToUI();
        this.dialog.getRootPane().getDefaultButton().requestFocusInWindow();
        this.dialog.setVisible(true);
    }

    protected void initComponents(JDialog dialog) {
    }

    protected void dataToUI() {
    }

    protected final void initButtonBar() {
        Container pane = this.dialog.getContentPane();
        this.okButton = ElementFactory.createButton(Actions.ButtonBar_OK, false);
        Box buttonBar = ElementFactory.createButtonBar();
        buttonBar.add(this.okButton);
        pane.add((Component)buttonBar, "South");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SimpleDialog.this.dialog.setVisible(false);
            }
        });
        this.cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SimpleDialog.this.dialog.setVisible(false);
            }
        };
        ElementFactory.setDialogDefaultButtons(this.dialog.getRootPane(), this.okButton, this.cancelAction);
        this.okButton.requestFocus();
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(this.dialog.getParent());
    }
}

