/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.console;

import com.wudsn.tools.base.Messages;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.base.common.StringUtility;
import com.wudsn.tools.base.console.Console;
import com.wudsn.tools.base.console.ConsoleCommand;
import com.wudsn.tools.base.console.ConsoleCommandExecution;
import com.wudsn.tools.base.console.ConsoleCommandParameter;
import com.wudsn.tools.base.repository.Action;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JOptionPane;

public final class ConsoleCommandParser {
    private String mainClassPath;
    private Console console;
    private List<ConsoleCommand> commands;
    private List<ConsoleCommandExecution> parseResult;

    public ConsoleCommandParser(String mainClassPath) {
        if (mainClassPath == null) {
            throw new IllegalArgumentException("Parameter 'mainClassPath' must not be null.");
        }
        this.mainClassPath = mainClassPath;
        this.commands = new ArrayList<ConsoleCommand>();
    }

    public ConsoleCommand addCommand(Action action, String actionCommand) {
        if (action == null) {
            throw new IllegalArgumentException("Parameter 'action' must not be null.");
        }
        if (actionCommand == null) {
            throw new IllegalArgumentException("Parameter 'actionCommand' must not be null.");
        }
        ConsoleCommand result = new ConsoleCommand(action, actionCommand);
        this.commands.add(result);
        return result;
    }

    public void parse(String[] args, boolean mandatory, MessageQueue messageQueue) {
        if (args == null) {
            throw new IllegalArgumentException("Parameter 'args' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        this.console = new Console();
        boolean printHelp = false;
        this.parseResult = new ArrayList<ConsoleCommandExecution>();
        if (args.length == 0 && mandatory) {
            printHelp = true;
        } else {
            int i = 0;
            while (i < args.length) {
                String arg = args[i];
                if (arg.length() > 0) {
                    if (arg.startsWith("-")) {
                        if ((arg = arg.substring(1)).equalsIgnoreCase("help")) {
                            printHelp = true;
                        } else {
                            boolean parametersSpecified;
                            String commandName;
                            int index = arg.indexOf(":");
                            if (index >= 0) {
                                commandName = arg.substring(0, index);
                                parametersSpecified = true;
                            } else {
                                commandName = arg;
                                parametersSpecified = false;
                            }
                            ConsoleCommand command = null;
                            int j = 0;
                            while (j < this.commands.size() && command == null) {
                                ConsoleCommand possibleCommand = this.commands.get(j);
                                if (possibleCommand.getActionCommand().equalsIgnoreCase(commandName)) {
                                    command = possibleCommand;
                                }
                                ++j;
                            }
                            if (command == null) {
                                messageQueue.sendMessage(this, null, Messages.E251, commandName);
                            } else {
                                TreeMap<String, List<String>> parameterValues = new TreeMap<String, List<String>>();
                                if (command.getParameters().isEmpty()) {
                                    if (parametersSpecified) {
                                        messageQueue.sendMessage(this, null, Messages.E252, commandName);
                                    }
                                } else if (!parametersSpecified) {
                                    messageQueue.sendMessage(this, null, Messages.E253, commandName);
                                } else {
                                    ConsoleCommandParameter parameter = command.getParameters().get(0);
                                    String parameterValue = arg.substring(index + 1).trim();
                                    ArrayList<String> parameterValueStrings = new ArrayList<String>();
                                    if (parameterValue.length() >= 2 && parameterValue.startsWith("\"") && parameterValue.endsWith("\"")) {
                                        parameterValue = parameterValue.substring(1, parameterValue.length() - 1);
                                    }
                                    if (StringUtility.isSpecified(parameterValue)) {
                                        parameterValueStrings.add(parameterValue);
                                        parameterValues.put(parameter.getAttribute().getName(), parameterValueStrings);
                                    }
                                }
                                if (!printHelp) {
                                    this.parseResult.add(new ConsoleCommandExecution(command, parameterValues));
                                }
                            }
                        }
                    } else {
                        messageQueue.sendMessage(this, null, Messages.E250, arg);
                        printHelp = true;
                    }
                }
                ++i;
            }
        }
        this.console.displayMessageQueue(messageQueue);
        if (printHelp |= messageQueue.containsError()) {
            this.printHelp();
            this.console.exit(false);
        }
    }

    public Console getConsole() {
        if (this.console == null) {
            throw new IllegalStateException("No console present. Parse arguments first.");
        }
        return this.console;
    }

    public List<ConsoleCommandExecution> getParseResult() {
        if (this.parseResult == null) {
            throw new IllegalStateException("Nothing parsed yet");
        }
        return this.parseResult;
    }

    public void printHelp() {
        StringBuilder helpBuilder = new StringBuilder();
        helpBuilder.append("Usage: java ").append(this.mainClassPath).append(" [-command_1] ... [-command_n]\n\n");
        int maximumActionCommandLength = 0;
        for (ConsoleCommand command : this.commands) {
            int length = command.getActionCommand().length();
            for (ConsoleCommandParameter parameter : command.getParameters()) {
                length += parameter.getAttribute().getName().length() + 3;
            }
            maximumActionCommandLength = Math.max(maximumActionCommandLength, length);
        }
        StringBuilder builder = new StringBuilder(maximumActionCommandLength);
        for (ConsoleCommand command : this.commands) {
            builder.setLength(0);
            builder.append(command.getActionCommand());
            for (ConsoleCommandParameter parameter : command.getParameters()) {
                builder.append(":<");
                builder.append(parameter.getAttribute().getName());
                builder.append(">");
            }
            while (builder.length() < maximumActionCommandLength + 1) {
                builder.append(' ');
            }
            String helpText = command.getAction().getToolTip();
            if (StringUtility.isEmpty(helpText)) {
                helpText = command.getAction().getLabelWithoutMnemonics();
            }
            helpBuilder.append("-").append(builder.toString()).append(helpText).append("\n");
        }
        if (System.console() == null) {
            JOptionPane.showMessageDialog(null, helpBuilder.toString());
        } else {
            this.console.println(helpBuilder.toString());
        }
    }
}

