/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.atari.cartridge;

import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.atari.cartridge.DataTypes;
import com.wudsn.tools.base.common.HexUtility;
import com.wudsn.tools.base.repository.Attribute;

public final class CartridgeDatabaseEntry {
    private int sizeInKB;
    private long crc32;
    private String md5HexString;
    private String title;
    private String publisher;
    private String date;
    private CartridgeType cartridgeType;
    private String source;

    CartridgeDatabaseEntry(int sizeInKB, long crc32, String md5, String title, String publisher, String date, CartridgeType cartridgeType, String source) {
        if (sizeInKB < 0) {
            throw new IllegalArgumentException("Parameter 'sizeInK' must not be negative. Specified value is " + sizeInKB + ".");
        }
        if (md5 == null) {
            throw new IllegalArgumentException("Parameter 'md5' must not be null.");
        }
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        if (publisher == null) {
            throw new IllegalArgumentException("Parameter 'publisher' must not be null.");
        }
        if (date == null) {
            throw new IllegalArgumentException("Parameter 'date' must not be null.");
        }
        if (cartridgeType == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeType' must not be null.");
        }
        if (source == null) {
            throw new IllegalArgumentException("Parameter 'source' must not be null.");
        }
        this.sizeInKB = sizeInKB;
        this.crc32 = crc32;
        this.md5HexString = md5;
        this.title = title;
        this.publisher = publisher;
        this.date = date;
        this.cartridgeType = cartridgeType;
        this.source = source;
    }

    public int getSizeInKB() {
        return this.sizeInKB;
    }

    public long getCRC32() {
        return this.crc32;
    }

    public Key getKey() {
        return new Key(this.sizeInKB, this.crc32);
    }

    public String getCRC32HexString() {
        return "0x" + HexUtility.getLongValueHexString(this.crc32, 8);
    }

    public String getMD5HexString() {
        return this.md5HexString;
    }

    public String getTitle() {
        return this.title;
    }

    public String getPublisher() {
        return this.publisher;
    }

    public String getDate() {
        return this.date;
    }

    public CartridgeType getCartridgeType() {
        return this.cartridgeType;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "sizeInKB=" + this.sizeInKB + " crc32=" + this.getCRC32HexString() + " md5=" + this.md5HexString + " title=" + this.title + " cartridgeType=" + this.cartridgeType.getId() + " source=" + this.source;
    }

    public static final class Attributes {
        public static final String ELEMENT_NAME = "entry";
        public static final Attribute TITLE = new Attribute("title", DataTypes.CartridgeDatabaseEntry_Title);

        private Attributes() {
        }
    }

    public static final class Key
    implements Comparable<Key> {
        private final int sizeInKB;
        private final long crc32;

        public Key(int sizeInKB, long crc32) {
            this.sizeInKB = sizeInKB;
            this.crc32 = crc32;
        }

        public int hashCode() {
            return this.sizeInKB + (int)this.crc32;
        }

        @Override
        public int compareTo(Key o) {
            int result = this.sizeInKB - o.sizeInKB;
            if (result == 0) {
                if (this.crc32 != o.crc32) {
                    result = this.crc32 > o.crc32 ? 1 : -1;
                } else {
                    return 0;
                }
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key other = (Key)o;
                return this.sizeInKB == other.sizeInKB && this.crc32 == other.crc32;
            }
            return false;
        }

        public String toString() {
            return "sizeInKB=" + this.sizeInKB + " crc32=0x" + HexUtility.getLongValueHexString(this.crc32, 8);
        }
    }
}

