/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.atari.cartridge;

import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.atari.cartridge.CartridgeDatabaseEntry;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.base.common.ResourceUtility;
import com.wudsn.tools.base.common.StringUtility;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;

public final class CartridgeDatabase {
    private static final char QUOTE_CHAR = '\"';
    public static final String FILE_PATH = "data/CartridgeDatabase.csv";
    private static final char SEPARATOR_CHAR = ';';
    private static final String NEW_LINE_CHARS = "\r\n";
    private List<CartridgeDatabaseEntry> entries = new ArrayList<CartridgeDatabaseEntry>();
    private TreeMap<CartridgeDatabaseEntry.Key, List<CartridgeDatabaseEntry>> entriesBySizeAndCRC32 = new TreeMap();
    private TreeMap<String, CartridgeDatabaseEntry> entriesByMD5 = new TreeMap();
    private int knownCartridgeTypesCount;

    private void clear() {
        this.entries.clear();
        this.entriesBySizeAndCRC32.clear();
        this.entriesByMD5.clear();
        this.knownCartridgeTypesCount = 0;
    }

    public List<CartridgeDatabaseEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int getKnownTitelsCount() {
        return this.entries.size();
    }

    public int getKnownCartridgeTypesCount() {
        return this.knownCartridgeTypesCount;
    }

    public List<CartridgeDatabaseEntry> getEntriesBySizeAndCRC32(int sizeInKB, long crc32) {
        CartridgeDatabaseEntry.Key key = new CartridgeDatabaseEntry.Key(sizeInKB, crc32);
        List<CartridgeDatabaseEntry> result = this.entriesBySizeAndCRC32.get(key);
        result = result != null ? Collections.unmodifiableList(result) : Collections.emptyList();
        return result;
    }

    public CartridgeDatabaseEntry getEntryByMD5(String md5) {
        if (md5 == null) {
            throw new IllegalArgumentException("Parameter 'md5' must not be null.");
        }
        return this.entriesByMD5.get(md5);
    }

    public CartridgeDatabaseEntry addEntry(int sizeInKB, boolean hasCRC32, long crc32, String md5, String title, String publisher, String date, CartridgeType cartridgeType, String source) {
        CartridgeDatabaseEntry entry = new CartridgeDatabaseEntry(sizeInKB, crc32, md5, title, publisher, date, cartridgeType, source);
        this.entries.add(entry);
        if (hasCRC32) {
            CartridgeDatabaseEntry.Key key = entry.getKey();
            List<CartridgeDatabaseEntry> entries = this.entriesBySizeAndCRC32.get(key);
            if (entries == null) {
                entries = new ArrayList<CartridgeDatabaseEntry>();
                this.entriesBySizeAndCRC32.put(key, entries);
            }
            entries.add(entry);
        }
        if (StringUtility.isSpecified(md5)) {
            this.entriesByMD5.put(entry.getMD5HexString(), entry);
        }
        if (entry.getCartridgeType() != CartridgeType.UNKNOWN) {
            ++this.knownCartridgeTypesCount;
        }
        return entry;
    }

    public void load() {
        this.clear();
        String content = ResourceUtility.loadResourceAsString(FILE_PATH);
        if (content == null) {
            return;
        }
        BufferedReader reader = new BufferedReader(new StringReader(content));
        String line = "";
        try {
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                int index1 = line.indexOf(59);
                int index2 = line.indexOf(59, index1 + 1);
                int index3 = line.indexOf(59, index2 + 1);
                int index4 = line.indexOf(34, index3 + 2);
                int index5 = line.indexOf(34, index4 + 3);
                int index6 = line.indexOf(34, index5 + 3);
                int index7 = line.indexOf(59, index6 + 2);
                String sizeInKBValue = line.substring(0, index1);
                int sizeInKB = Integer.parseInt(sizeInKBValue);
                String crc32Value = line.substring(index1 + 2, index2);
                boolean hasCRC32 = StringUtility.isSpecified(crc32Value) && crc32Value.startsWith("0x");
                long crc32 = 0L;
                if (hasCRC32) {
                    crc32 = Long.parseLong(crc32Value.substring(2), 16);
                }
                String md5 = line.substring(index2 + 2, index3);
                String title = line.substring(index3 + 2, index4);
                String publisher = line.substring(index4 + 3, index5);
                String date = line.substring(index5 + 3, index6);
                String cartridgeTypeId = line.substring(index6 + 2, index7);
                CartridgeType cartridgeType = CartridgeType.getInstance(cartridgeTypeId);
                if (cartridgeType == null) {
                    throw new IllegalStateException("No cartrigde type for numeric ID " + cartridgeTypeId);
                }
                String source = line.substring(index5 + 1);
                this.addEntry(sizeInKB, hasCRC32, crc32, md5, title, publisher, date, cartridgeType, source);
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            throw new RuntimeException("Error while processing line: '" + line + "'", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public void save(File file) throws CoreException {
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        printWriter.println("sep=;");
        try {
            for (CartridgeDatabaseEntry entry : this.entries) {
                printWriter.print(entry.getSizeInKB());
                printWriter.print(';');
                printWriter.print("'");
                printWriter.print(entry.getCRC32HexString());
                printWriter.print(';');
                printWriter.print("'");
                printWriter.print(entry.getMD5HexString());
                printWriter.print(';');
                printWriter.print('\"');
                printWriter.print(entry.getTitle());
                printWriter.print('\"');
                printWriter.print(';');
                printWriter.print('\"');
                printWriter.print(entry.getPublisher());
                printWriter.print('\"');
                printWriter.print(';');
                printWriter.print('\"');
                printWriter.print(entry.getDate());
                printWriter.print('\"');
                printWriter.print(';');
                printWriter.print(entry.getCartridgeType().getId());
                printWriter.print(';');
                printWriter.print(entry.getSource());
                printWriter.print(NEW_LINE_CHARS);
            }
            writer.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error during serialization", ex);
        }
        FileUtility.writeString(file, writer.toString());
    }
}

