// The!Cart V2 Shell - Top half
// Version 2015-01-04 by Sven Pink based in the previous version of The!Cart V1
// Version 2015-10-25 by Sven Pink, Peter Dell
// Version 2017-10-29 by Peter Dell, Bernhard Kirsch
// All values in milimeters.

// Changelog
// 2017-01-04 Increase Y-Size of internal space at 0.2mm to better fit PCB in top of cart and avoid manual adaption after print: translate([4,-6,2]) cube(size=[56,76.6,15.5]); -> translate([4,-6,2]) cube(size=[56,76.8,15.5]);
// 2017-10-29 Source formatting, front side text label
// 2018-01-27 Make inside 0.4mm wider to fit into Atari 400
// 2018-01-30 Remove 4th handle left and right
// 2018-02-03 Add additional cut out for PCB on upper edge

// Define Resolution
$fn=50;

difference() {

// Volume cartridge with rounded corners
minkowski() {
translate([3,-2,3]) cube(size=[58, 73, 18]);
    
// Rounded corners
sphere(3);
}

// "Handles" left
translate([0,55,-3]) cube(size=[2,2.8,17]);
translate([0,61,-3]) cube(size=[2,2.8,17]);
translate([0,49,-3]) cube(size=[2,2.8,17]);

// "Handles" right
translate([62.2,55,-3]) cube(size=[2,2.8,17]);
translate([62.2,61,-3]) cube(size=[2,2.8,17]);
translate([62.2,49,-3]) cube(size=[2,2.8,17]);

// Inside, l/r = 3mm
translate([3.8,-6,2]) cube(size=[56.4,76.8,15.5]);

// Additional cut out for PCB on upper edge
translate([3.8,-6,8]) cube(size=[56.4,77.5,15.5]);

// Cut cartridge in half
translate([0,-6,10.5]) cube(size=[66,90,13.5]);

// Holes for LEDs
translate([24.5,67,-3]) cylinder(h=10, r=0.8);
translate([24.5,69,-3]) cylinder(h=10, r=0.8);

translate([30,67,-3]) cylinder(h=10, r=0.8);
translate([30,69,-3]) cylinder(h=10, r=0.8);

// Cut for slot, must be same as inside above
translate([3.8,-6,0]) cube(size=[56.4,9.5,15.5]);

// Front side text label
translate([60,37,-3.5]) { 
    mirror([1,0,0]) {
        linear_extrude(height = 4) {
              text("the!cart", font = ".Helvetica Neue DeskInterface:style=Regular", size = 12);
         }
     }
 }
}

// Additional fit
translate([ 3.7,16,2]) cube(size=[0.6,56,8.5]); // left
translate([59.7,16,2]) cube(size=[0.6,56,8.5]); // right

difference() {
    
// Base for PCB
translate([3,12.5,2]) cube(size=[58,3.5,8.5]); 

// Thickness of PCB
translate([3,12.5,8.5]) cube(size=[58,5,2]);

}

// Middle base
// translate([8,22,2]) cube(size=[48,5,6.5]); 

module fillet(r, h) {
    translate([r / 2, r / 2, 0])

        difference() {
            cube([r + 0.01, r + 0.01, h], center = true);

            translate([r/2, r/2, 0])
                cylinder(r = r, h = h + 1, center = true, $fn=50);
        }
}