// The!Cart V2 Shell - Bottom half
// Version 2015-01-04 by Sven Pink based in the previous version of The!Cart V1
// Version 2015-10-25 by Sven Pink, Peter Dell
// Version 2017-10-29 by Peter Dell, Bernhard Kirsch
// All values in milimeters.

// Changelog
// 2017-01-04 Increase Y-Size of internal space at 0.2mm to better fit PCB in top of cart and avoid manual adaption after print: translate([4,-6,2]) cube(size=[56,76.6,15.5]); -> translate([4,-6,2]) cube(size=[56,76.8,15.5]);
// 2017-10-29 Source formatting
// 2018-01-27 Make inside 0.4mm wider to fit into Atari 400
// 2018-01-30 Remove 4th handle left and right

// Define Resolution
$fn=50;

difference() {

// Volume cartridge with rounded corners
minkowski() {
translate([3,-2,3]) cube(size=[58, 73, 18]);
    
// Rounded corners
sphere(3);
}

// "Handles" left
translate([0,55,-3]) cube(size=[2,2.8,17]);
translate([0,61,-3]) cube(size=[2,2.8,17]);
translate([0,49,-3]) cube(size=[2,2.8,17]);

// "Handles" right
translate([62.2,55,-3]) cube(size=[2,2.8,17]);
translate([62.2,61,-3]) cube(size=[2,2.8,17]);
translate([62.2,49,-3]) cube(size=[2,2.8,17]);

// Inside, l/r = 3mm
translate([3.8,-6,2]) cube(size=[56.4,76.8,15.5]);

// Cut cartridge in half
translate([0,-6,10.5]) cube(size=[66,90,13.5]);

// Upper left corner
translate ([0,86,0]) rotate(270,0,0) fillet(7,21); 
// Upper right corner
translate ([66,86,0]) rotate(180,0,0) fillet(7,21);

// Hole for push button
translate([51,70,6.5]) rotate([270,0,0]) cylinder(h=4,r1=2.5,r2=2.5,$fn=50);
}


// Base for PCB
translate([3,12,2]) cube(size=[58,5.5,8.5]);

// PCB fixation, large parts
translate([4.6,17,2]) cube(size=[1.6,53.6,14.5]);  // left
translate([3.8,17,2]) cube(size=[0.8,53.8,8.5]);  // left
translate([58,17,2]) cube(size=[1.6,53.6,14.5]);  // right
translate([59.6,17,2]) cube(size=[0.8,53.8,8.5]);  // right
// Middle base
// translate([8,46,2]) cube(size=[48,5,8.5]);

// PCB fixation, small parts
translate([4.6,16,2]) cube(size=[7.2,1.5,14.5]);  // left
translate([52.4,16,2]) cube(size=[7.2,1.5,14.5]);  // right

module fillet(r, h) {
    translate([r / 2, r / 2, 0])

        difference() {
            cube([r + 0.01, r + 0.01, h], center = true);

            translate([r/2, r/2, 0])
                cylinder(r = r, h = h + 1, center = true, $fn=50);
        }
}