// Define Resolution
$fn=20;

difference() {

// Volume cartridge with rounded corners
minkowski() {
  translate([3,3,3]) cube(size=[60, 80, 18]);
  // Rounded corners
  sphere(3);
}


// "Handles" left
translate([0,55,-3]) cube(size=[2,3,17]);
translate([0,61,-3]) cube(size=[2,3,17]);
translate([0,67,-3]) cube(size=[2,3,17]);
translate([0,49,-3]) cube(size=[2,3,17]);

// "Handles" right
translate([64.2,55,-3]) cube(size=[2,3,17]);
translate([64.2,61,-3]) cube(size=[2,3,17]);
translate([64.2,67,-3]) cube(size=[2,3,17]);
translate([64.2,49,-3]) cube(size=[2,3,17]);

// Inside, l/r = 3mm
translate([3,0,4]) cube(size=[60,80,15.5]);
translate([3,2,2]) cube(size=[60,80.6,15.5]);

// Cut free for the contacts
translate([3,0,0]) cube(size=[60,12.5,4]);

// Cut cartridge in half
translate([0,0,10.5]) cube(size=[66,90,13.5]);

// Holes for LEDs
translate([38,80,-3]) cylinder(h=10, r=0.8);
translate([38,78,-3]) cylinder(h=10, r=0.8);

translate([43,80,-3]) cylinder(h=10, r=0.8);
translate([43,78,-3]) cylinder(h=10, r=0.8);

translate([46.5,79.5,-3]) cylinder(h=10, r=0.8);

}

difference() {

// Base for PCB
translate([3,12.5,2]) cube(size=[60,5,8.5]); //change bug

// Thickness of PCB
translate([5,12.5,8.5]) cube(size=[56,5,2]);

}

// Middle base
translate([8,46,2]) cube(size=[50,5,6.5]);

module fillet(r, h) {
    translate([r / 2, r / 2, 0])

        difference() {
            cube([r + 0.01, r + 0.01, h], center = true);

            translate([r/2, r/2, 0])
                cylinder(r = r, h = h + 1, center = true, $fn=20);
        }
}