// Define Resolution
$fn=50;

difference() {

// Volume cartridge with rounded corners
minkowski() {
  // translate([3,3,3]) cube(size=[60,74,17]);
  translate([3,3,3]) cube(size=[60, 80, 18]);
  // Rounded corners
  sphere(3);
}

// Upper left corner
translate ([0,86,0]) rotate(270,0,0) fillet(7,21);

// Upper right corner
translate ([66,86,0]) rotate(180,0,0) fillet(7,21);

// "Handles" left
translate([0,55,-3]) cube(size=[2,3,17]);
translate([0,61,-3]) cube(size=[2,3,17]);
translate([0,67,-3]) cube(size=[2,3,17]);
translate([0,49,-3]) cube(size=[2,3,17]);

// "Handles" right
translate([64.2,55,-3]) cube(size=[2,3,17]);
translate([64.2,61,-3]) cube(size=[2,3,17]);
translate([64.2,67,-3]) cube(size=[2,3,17]);
translate([64.2,49,-3]) cube(size=[2,3,17]);

// Inside, l/r = 3mm
translate([3,0,4]) cube(size=[60,80,15.5]);
translate([3,2,2]) cube(size=[60,80.6,15.5]);

// Cut cartridge in half
translate([0,0,10.5]) cube(size=[66,90,13.5]);

// Hole for push button
translate([47,81,7]) rotate([270,0,0]) cylinder(h=6,r=2.2, $fn=40);
}

// Base for PCB
translate([3,12,2]) cube(size=[60,5.5,8.5]);

// PCB fixation, large parts
translate([3,17,2]) cube(size=[2.2,65.6,12.5]); // left
translate([60.8,17,2]) cube(size=[2.2,65.6,12.5]); // right
translate([8,48,2]) cube(size=[50,5,8.5]); // middle base
translate([3,16,2]) cube(size=[9.2,1.5,12.5]); // left
translate([53.8,16,2]) cube(size=[9.2,1.5,12.5]);  // right

module fillet(r, h) {
    translate([r / 2, r / 2, 0])

        difference() {
            cube([r + 0.01, r + 0.01, h], center = true);

            translate([r/2, r/2, 0])
                cylinder(r = r, h = h + 1, center = true, $fn=100);
        }
}