/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model.williams;

import com.wudsn.tools.base.atari.CartridgeFileUtility;
import com.wudsn.tools.base.atari.CartridgeType;
import com.wudsn.tools.base.atari.cartridge.CartridgeDatabaseEntry;
import com.wudsn.tools.base.common.ByteArrayUtility;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.FileUtility;
import com.wudsn.tools.thecartstudio.model.ContentType;
import com.wudsn.tools.thecartstudio.model.FlashTargetType;
import com.wudsn.tools.thecartstudio.model.Importer;
import com.wudsn.tools.thecartstudio.model.Workbook;
import java.io.File;
import java.io.OutputStream;
import java.util.List;

public final class WilliamsImporter
extends Importer {
    private static final int CARTRIDGE_WILL_32_SIZE = CartridgeType.CARTRIDGE_WILL_32.getSizeInKB() * 1024;
    private static final int CARTRIDGE_WILL_32_CAR_SIZE = 16 + CARTRIDGE_WILL_32_SIZE;
    private static final int CARTRIDGE_WILL_64_SIZE = CartridgeType.CARTRIDGE_WILL_64.getSizeInKB() * 1024;

    @Override
    public void importFile(Workbook workbook, File file, Importer.ImportResult result) {
        boolean relevant;
        if (workbook == null) {
            throw new IllegalArgumentException("workbook must not be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter file must not be null.");
        }
        if (result == null) {
            throw new IllegalArgumentException("Parameter result must not be null.");
        }
        FlashTargetType flashTargetType = workbook.getRoot().getFlashTargetType();
        if (flashTargetType.isContentTypeSupported(ContentType.CARTRIDGE_WILL_32)) {
            return;
        }
        if (!flashTargetType.isContentTypeSupported(ContentType.CARTRIDGE_WILL_64)) {
            return;
        }
        String fileName = file.getName();
        long fileLength = file.length();
        boolean bl = relevant = fileName.toLowerCase().endsWith(".car") && fileLength == (long)CARTRIDGE_WILL_32_CAR_SIZE || fileLength == (long)CARTRIDGE_WILL_32_SIZE;
        if (!relevant) {
            return;
        }
        File sourceFile = file;
        int index = fileName.lastIndexOf(46);
        if (index == -1) {
            index = fileName.length();
        }
        File targetFile = new File(sourceFile.getParentFile(), String.valueOf(fileName.substring(0, index)) + "-Converted" + ".car");
        CartridgeDatabaseEntry cartridgeDatabaseEntry = null;
        try {
            int numericId = 0;
            int startOffset = -1;
            byte[] content = FileUtility.readBytes(sourceFile, CARTRIDGE_WILL_32_CAR_SIZE, true);
            if (content.length == CARTRIDGE_WILL_32_SIZE) {
                int crc32 = ByteArrayUtility.getCRC32(content);
                List<CartridgeDatabaseEntry> cartridgeDatabaseEntries = workbook.getCartridgeDatabase().getEntriesBySizeAndCRC32(content.length / 1024, crc32);
                if (cartridgeDatabaseEntries.size() == 1) {
                    cartridgeDatabaseEntry = cartridgeDatabaseEntries.get(0);
                    numericId = cartridgeDatabaseEntry.getCartridgeType().getNumericId();
                    startOffset = 0;
                }
            } else if (content.length == CARTRIDGE_WILL_32_CAR_SIZE) {
                numericId = CartridgeFileUtility.getCartridgeTypeNumericId(content);
                startOffset = 16;
            }
            if (numericId != CartridgeType.CARTRIDGE_WILL_32.getNumericId()) {
                return;
            }
            byte[] cartridgeContent = new byte[CARTRIDGE_WILL_64_SIZE];
            System.arraycopy(content, startOffset, cartridgeContent, 0, CARTRIDGE_WILL_32_SIZE);
            byte[] cartridgeHeader = CartridgeFileUtility.createCartridgeHeaderWithCheckSum(CartridgeType.CARTRIDGE_WILL_64.getNumericId(), cartridgeContent);
            OutputStream outputStream = null;
            try {
                outputStream = FileUtility.openOutputStream(targetFile);
                FileUtility.writeBytes(targetFile, outputStream, cartridgeHeader, 0, cartridgeHeader.length);
                FileUtility.writeBytes(targetFile, outputStream, cartridgeContent, 0, cartridgeContent.length);
                result.cartridgeDatabaseEntry = cartridgeDatabaseEntry;
                result.convertedFile = targetFile;
            }
            finally {
                try {
                    if (outputStream != null) {
                        FileUtility.closeOutputStream(targetFile, outputStream);
                    }
                }
                catch (CoreException coreException) {}
            }
        }
        catch (CoreException ex) {
            result.convertedFileException = ex;
        }
    }
}

