/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.WorkbookExport;
import com.wudsn.tools.thecartstudio.model.WorkbookRoot;

public abstract class ReservedContentProvider {
    private String title = "";
    private int requiredBankSize;
    private int startBankNumber = 0;
    protected int requiredBanksCount = 0;
    private boolean reservedForSystem = false;

    ReservedContentProvider() {
    }

    protected void init(String title, int requiredBankSize, int startBankNumber, int requiredBanksCount, boolean reservedForSystem) {
        if (title == null) {
            throw new IllegalArgumentException("Parameter 'title' must not be null.");
        }
        if (requiredBankSize < 0) {
            throw new IllegalArgumentException("Parameter 'requiredBankSize' must not be negative. Specifed value is " + requiredBankSize + ".");
        }
        if (startBankNumber < 0) {
            throw new IllegalArgumentException("Parameter 'startBankNumber' must not be negative. Specifed value is " + startBankNumber + ".");
        }
        if (requiredBanksCount < 0) {
            throw new IllegalArgumentException("Parameter 'requiredBanksCount' must not be negative. Specifed value is " + requiredBanksCount + ".");
        }
        this.title = title;
        this.requiredBankSize = requiredBankSize;
        this.startBankNumber = startBankNumber;
        this.requiredBanksCount = requiredBanksCount;
        this.reservedForSystem = reservedForSystem;
    }

    public abstract void init(WorkbookRoot var1);

    public String getTitle() {
        return this.title;
    }

    public int getRequiredBankSize() {
        return this.requiredBankSize;
    }

    public int getStartBankNumber() {
        return this.startBankNumber;
    }

    public int getRequiredBanksCount() {
        return this.requiredBanksCount;
    }

    public boolean isReservedForSystem() {
        return this.reservedForSystem;
    }

    public abstract byte[] createContent(Workbook var1, WorkbookExport var2, MessageQueue var3);

    public String toString() {
        return "title=" + this.title + " startBankNumber=" + this.startBankNumber + " requiredBanksCount=" + this.requiredBanksCount + "reservedForSystem=" + this.reservedForSystem;
    }
}

