/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model;

import com.wudsn.tools.base.atari.cartridge.CartridgeDatabaseEntry;
import com.wudsn.tools.base.common.CoreException;
import com.wudsn.tools.base.common.MessageQueue;
import com.wudsn.tools.thecartstudio.model.Workbook;
import com.wudsn.tools.thecartstudio.model.maxflash.MaxflashImporter;
import com.wudsn.tools.thecartstudio.model.williams.WilliamsImporter;
import java.io.File;
import java.util.ArrayList;

public abstract class Importer {
    protected Importer() {
    }

    public abstract void importFile(Workbook var1, File var2, ImportResult var3);

    public static ImportResult autoConvertFile(Workbook workbook, File file, MessageQueue messageQueue) {
        if (workbook == null) {
            throw new IllegalArgumentException("Parameter 'workbook' must not be null.");
        }
        if (file == null) {
            throw new IllegalArgumentException("Parameter 'file' must not be null.");
        }
        if (messageQueue == null) {
            throw new IllegalArgumentException("Parameter 'messageQueue' must not be null.");
        }
        ArrayList<Importer> importers = new ArrayList<Importer>();
        importers.add(new MaxflashImporter());
        importers.add(new WilliamsImporter());
        ImportResult result = new ImportResult();
        for (Importer importer : importers) {
            importer.importFile(workbook, file, result);
            if (result.convertedFile == null && result.convertedFileException == null) continue;
            return result;
        }
        return result;
    }

    public static final class ImportResult {
        public CartridgeDatabaseEntry cartridgeDatabaseEntry;
        public File convertedFile;
        public CoreException convertedFileException;
    }
}

