/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.repository;

import com.wudsn.tools.base.ValueSets;
import com.wudsn.tools.base.repository.NLS;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class ValueSet
extends NLS
implements Comparable<ValueSet> {
    protected final String id;
    protected String text;
    protected final int sortKey;

    protected static void initializeClass(Class<? extends ValueSet> clazz, Class<? extends ValueSets> containerClazz) {
        NLS.initializeClass(clazz, containerClazz);
    }

    protected ValueSet(String id, int sortKey) {
        this(id, id, sortKey);
    }

    protected ValueSet(String id, String text, int sortKey) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.id = id;
        this.text = text;
        this.sortKey = sortKey;
    }

    public final String getId() {
        return this.id;
    }

    public final String getText() {
        return this.text;
    }

    final void setText(String text) {
        if (text == null) {
            throw new IllegalArgumentException("Parameter 'text' must not be null.");
        }
        this.text = text;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String toString() {
        return this.text;
    }

    @Override
    public final int compareTo(ValueSet o) {
        int result = this.sortKey - o.sortKey;
        if (result == 0) {
            result = this.text.compareToIgnoreCase(o.text);
        }
        return result;
    }

    public static final <T extends ValueSet> List<T> getValues(Class<T> valueSetClass) {
        try {
            Method method = valueSetClass.getMethod("getValues", new Class[0]);
            Object object = method.invoke(null, new Object[0]);
            ArrayList result = (ArrayList)object;
            result = new ArrayList(result);
            ValueSet.sort(result);
            return result;
        }
        catch (NoSuchMethodException ex) {
            throw new RuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static final void sort(List<? extends ValueSet> list) {
        Collections.sort(list);
    }
}

