/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.common;

import java.util.Comparator;

public final class StringUtility {
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new CaseInsensitiveComparator();

    private StringUtility() {
    }

    public static boolean isEmpty(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' must not be null.");
        }
        return value.trim().length() == 0;
    }

    public static boolean isSpecified(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Parameter 'value' must not be null.");
        }
        return value.trim().length() > 0;
    }

    private static final class CaseInsensitiveComparator
    implements Comparator<String> {
        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            return s1.toUpperCase().compareTo(s2.toUpperCase());
        }
    }
}

