/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.base.atari;

import com.wudsn.tools.base.atari.Platform;
import com.wudsn.tools.base.atari.ValueSets;
import com.wudsn.tools.base.repository.ValueSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class CartridgeType
extends ValueSet {
    public static final CartridgeType UNKNOWN;
    public static final CartridgeType CARTRIDGE_STD_8;
    public static final CartridgeType CARTRIDGE_STD_16;
    public static final CartridgeType CARTRIDGE_OSS_034M_16;
    public static final CartridgeType CARTRIDGE_5200_32;
    public static final CartridgeType CARTRIDGE_DB_32;
    public static final CartridgeType CARTRIDGE_5200_EE_16;
    public static final CartridgeType CARTRIDGE_5200_40;
    public static final CartridgeType CARTRIDGE_WILL_64;
    public static final CartridgeType CARTRIDGE_EXP_64;
    public static final CartridgeType CARTRIDGE_DIAMOND_64;
    public static final CartridgeType CARTRIDGE_SDX_64;
    public static final CartridgeType CARTRIDGE_XEGS_32;
    public static final CartridgeType CARTRIDGE_XEGS_64;
    public static final CartridgeType CARTRIDGE_XEGS_128;
    public static final CartridgeType CARTRIDGE_OSS_M091_16;
    public static final CartridgeType CARTRIDGE_5200_NS_16;
    public static final CartridgeType CARTRIDGE_ATRAX_DEC_128;
    public static final CartridgeType CARTRIDGE_BBSB_40;
    public static final CartridgeType CARTRIDGE_5200_8;
    public static final CartridgeType CARTRIDGE_5200_4;
    public static final CartridgeType CARTRIDGE_RIGHT_8;
    public static final CartridgeType CARTRIDGE_WILL_32;
    public static final CartridgeType CARTRIDGE_XEGS_256;
    public static final CartridgeType CARTRIDGE_XEGS_512;
    public static final CartridgeType CARTRIDGE_XEGS_1024;
    public static final CartridgeType CARTRIDGE_MEGA_16;
    public static final CartridgeType CARTRIDGE_MEGA_32;
    public static final CartridgeType CARTRIDGE_MEGA_64;
    public static final CartridgeType CARTRIDGE_MEGA_128;
    public static final CartridgeType CARTRIDGE_MEGA_256;
    public static final CartridgeType CARTRIDGE_MEGA_512;
    public static final CartridgeType CARTRIDGE_MEGA_1024;
    public static final CartridgeType CARTRIDGE_SWXEGS_32;
    public static final CartridgeType CARTRIDGE_SWXEGS_64;
    public static final CartridgeType CARTRIDGE_SWXEGS_128;
    public static final CartridgeType CARTRIDGE_SWXEGS_256;
    public static final CartridgeType CARTRIDGE_SWXEGS_512;
    public static final CartridgeType CARTRIDGE_SWXEGS_1024;
    public static final CartridgeType CARTRIDGE_PHOENIX_8;
    public static final CartridgeType CARTRIDGE_BLIZZARD_16;
    public static final CartridgeType CARTRIDGE_ATMAX_128;
    public static final CartridgeType CARTRIDGE_ATMAX_1024;
    public static final CartridgeType CARTRIDGE_SDX_128;
    public static final CartridgeType CARTRIDGE_OSS_8;
    public static final CartridgeType CARTRIDGE_OSS_043M_16;
    public static final CartridgeType CARTRIDGE_BLIZZARD_4;
    public static final CartridgeType CARTRIDGE_AST_32;
    public static final CartridgeType CARTRIDGE_ATRAX_SDX_64;
    public static final CartridgeType CARTRIDGE_ATRAX_SDX_128;
    public static final CartridgeType CARTRIDGE_TURBOSOFT_64;
    public static final CartridgeType CARTRIDGE_TURBOSOFT_128;
    public static final CartridgeType CARTRIDGE_ULTRACART_32;
    public static final CartridgeType CARTRIDGE_LOW_BANK_8;
    public static final CartridgeType CARTRIDGE_SIC_128;
    public static final CartridgeType CARTRIDGE_SIC_256;
    public static final CartridgeType CARTRIDGE_SIC_512;
    public static final CartridgeType CARTRIDGE_STD_2;
    public static final CartridgeType CARTRIDGE_STD_4;
    public static final CartridgeType CARTRIDGE_RIGHT_4;
    public static final CartridgeType CARTRIDGE_BLIZZARD_32;
    public static final CartridgeType CARTRIDGE_MEGAMAX_2048;
    public static final CartridgeType CARTRIDGE_THECART_128M;
    public static final CartridgeType CARTRIDGE_MEGA_4096;
    public static final CartridgeType CARTRIDGE_MEGA_2048;
    public static final CartridgeType CARTRIDGE_THECART_32M;
    public static final CartridgeType CARTRIDGE_THECART_64M;
    public static final CartridgeType CARTRIDGE_XEGS_8F_64;
    public static final CartridgeType CARTRIDGE_ATRAX_128;
    public static final CartridgeType CARTRIDGE_ADAWLIAH_32;
    public static final CartridgeType CARTRIDGE_ADAWLIAH_64;
    public static final CartridgeType CARTRIDGE_5200_SUPER_64;
    public static final CartridgeType CARTRIDGE_5200_SUPER_128;
    public static final CartridgeType CARTRIDGE_5200_SUPER_256;
    public static final CartridgeType CARTRIDGE_5200_SUPER_512;
    public static final CartridgeType CARTRIDGE_ATMAX_NEW_1024;
    private static final Map<String, CartridgeType> values;
    private Platform platform;
    private int numericId;
    private int sizeInKB;
    private int bankSize;
    private int initialBankOffset;
    private int initialBankAddress;
    private int initialBankNumber;
    private int flashBlockSize;

    static {
        boolean offset_0000 = false;
        int offset_2000 = 8192;
        int offset_3000 = 12288;
        int offset_6000 = 24576;
        int offset_8000 = 32768;
        int offset_e000 = 57344;
        int offset_1e000 = 122880;
        int offset_3e000 = 253952;
        int offset_7e000 = 516096;
        int offset_fe000 = 1040384;
        int offset_3F8000 = 4161536;
        int adr_4000 = 16384;
        int adr_8000 = 32768;
        int adr_9000 = 36864;
        int adr_a000 = 40960;
        int adr_b000 = 45056;
        int adr_b800 = 47104;
        int bank_size_0100 = 256;
        int bank_size_0800 = 2048;
        int bank_size_1000 = 4096;
        int bank_size_2000 = 8192;
        int bank_size_4000 = 16384;
        int bank_size_8000 = 32768;
        boolean initial_bank_0 = false;
        boolean initial_bank_1 = true;
        int initial_bank_3 = 3;
        int initial_bank_7 = 7;
        int initial_bank_15 = 15;
        int initial_bank_127 = 127;
        int initial_bank_254 = 254;
        boolean block_size_none = false;
        int block_size_10000 = 65536;
        int block_size_20000 = 131072;
        values = new TreeMap<String, CartridgeType>();
        UNKNOWN = CartridgeType.add(0, "UNKNOWN", Platform.UNKNOWN, 0, 0, 0, 0, 0, 0);
        CARTRIDGE_STD_8 = CartridgeType.add(1, "CARTRIDGE_STD_8", Platform.ATARI_800, 8, 8192, 0, 40960, 0, 0);
        CARTRIDGE_STD_16 = CartridgeType.add(2, "CARTRIDGE_STD_16", Platform.ATARI_800, 16, 16384, 0, 32768, 0, 0);
        CARTRIDGE_OSS_034M_16 = CartridgeType.add(3, "CARTRIDGE_OSS_034M_16", Platform.ATARI_800, 16, 4096, 12288, 45056, 1, 0);
        CARTRIDGE_5200_32 = CartridgeType.add(4, "CARTRIDGE_5200_32", Platform.ATARI_5200, 32, 32768, 0, 16384, 0, 0);
        CARTRIDGE_DB_32 = CartridgeType.add(5, "CARTRIDGE_DB_32", Platform.ATARI_800, 32, 8192, 24576, 40960, 0, 0);
        CARTRIDGE_5200_EE_16 = CartridgeType.add(6, "CARTRIDGE_5200_EE_16", Platform.ATARI_5200, 16, 16384, 0, 16384, 0, 0);
        CARTRIDGE_5200_40 = CartridgeType.add(7, "CARTRIDGE_5200_40", Platform.ATARI_5200, 40, 8192, 32768, 40960, 0, 0);
        CARTRIDGE_WILL_64 = CartridgeType.add(8, "CARTRIDGE_WILL_64", Platform.ATARI_800, 64, 8192, 0, 40960, 0, 0);
        CARTRIDGE_EXP_64 = CartridgeType.add(9, "CARTRIDGE_EXP_64", Platform.ATARI_800, 64, 8192, 0, 40960, 0, 0);
        CARTRIDGE_DIAMOND_64 = CartridgeType.add(10, "CARTRIDGE_DIAMOND_64", Platform.ATARI_800, 64, 8192, 0, 40960, 0, 0);
        CARTRIDGE_SDX_64 = CartridgeType.add(11, "CARTRIDGE_SDX_64", Platform.ATARI_800, 64, 8192, 0, 40960, 0, 0);
        CARTRIDGE_XEGS_32 = CartridgeType.add(12, "CARTRIDGE_XEGS_32", Platform.ATARI_800, 32, 8192, 24576, 40960, 0, 0);
        CARTRIDGE_XEGS_64 = CartridgeType.add(13, "CARTRIDGE_XEGS_64", Platform.ATARI_800, 64, 8192, 57344, 40960, 0, 0);
        CARTRIDGE_XEGS_128 = CartridgeType.add(14, "CARTRIDGE_XEGS_128", Platform.ATARI_800, 128, 8192, 122880, 40960, 0, 0);
        CARTRIDGE_OSS_M091_16 = CartridgeType.add(15, "CARTRIDGE_OSS_M091_16", Platform.ATARI_800, 16, 4096, 0, 45056, 0, 0);
        CARTRIDGE_5200_NS_16 = CartridgeType.add(16, "CARTRIDGE_5200_NS_16", Platform.ATARI_5200, 16, 16384, 0, 32768, 0, 0);
        CARTRIDGE_ATRAX_DEC_128 = CartridgeType.add(17, "CARTRIDGE_ATRAX_DEC_128", Platform.ATARI_800, 128, 8192, 0, 40960, 0, 0);
        CARTRIDGE_BBSB_40 = CartridgeType.add(18, "CARTRIDGE_BBSB_40", Platform.ATARI_800, 40, 8192, 32768, 40960, 0, 0);
        CARTRIDGE_5200_8 = CartridgeType.add(19, "CARTRIDGE_5200_8", Platform.ATARI_5200, 8, 8192, 0, 40960, 0, 0);
        CARTRIDGE_5200_4 = CartridgeType.add(20, "CARTRIDGE_5200_4", Platform.ATARI_5200, 4, 4096, 0, 40960, 0, 0);
        CARTRIDGE_RIGHT_8 = CartridgeType.add(21, "CARTRIDGE_RIGHT_8", Platform.ATARI_800, 8, 8192, 0, 32768, 0, 0);
        CARTRIDGE_WILL_32 = CartridgeType.add(22, "CARTRIDGE_WILL_32", Platform.ATARI_800, 32, 8192, 0, 40960, 0, 0);
        CARTRIDGE_XEGS_256 = CartridgeType.add(23, "CARTRIDGE_XEGS_256", Platform.ATARI_800, 256, 8192, 253952, 40960, 0, 0);
        CARTRIDGE_XEGS_512 = CartridgeType.add(24, "CARTRIDGE_XEGS_512", Platform.ATARI_800, 512, 8192, 516096, 40960, 0, 0);
        CARTRIDGE_XEGS_1024 = CartridgeType.add(25, "CARTRIDGE_XEGS_1024", Platform.ATARI_800, 1024, 8192, 1040384, 40960, 0, 0);
        CARTRIDGE_MEGA_16 = CartridgeType.add(26, "CARTRIDGE_MEGA_16", Platform.ATARI_800, 16, 16384, 0, 32768, 0, 0);
        CARTRIDGE_MEGA_32 = CartridgeType.add(27, "CARTRIDGE_MEGA_32", Platform.ATARI_800, 32, 16384, 0, 32768, 0, 0);
        CARTRIDGE_MEGA_64 = CartridgeType.add(28, "CARTRIDGE_MEGA_64", Platform.ATARI_800, 64, 16384, 0, 32768, 0, 0);
        CARTRIDGE_MEGA_128 = CartridgeType.add(29, "CARTRIDGE_MEGA_128", Platform.ATARI_800, 128, 16384, 0, 32768, 0, 0);
        CARTRIDGE_MEGA_256 = CartridgeType.add(30, "CARTRIDGE_MEGA_256", Platform.ATARI_800, 256, 16384, 0, 32768, 0, 0);
        CARTRIDGE_MEGA_512 = CartridgeType.add(31, "CARTRIDGE_MEGA_512", Platform.ATARI_800, 512, 16384, 0, 32768, 0, 0);
        CARTRIDGE_MEGA_1024 = CartridgeType.add(32, "CARTRIDGE_MEGA_1024", Platform.ATARI_800, 1024, 16384, 0, 32768, 0, 0);
        CARTRIDGE_SWXEGS_32 = CartridgeType.add(33, "CARTRIDGE_SWXEGS_32", Platform.ATARI_800, 32, 8192, 24576, 40960, 0, 0);
        CARTRIDGE_SWXEGS_64 = CartridgeType.add(34, "CARTRIDGE_SWXEGS_64", Platform.ATARI_800, 64, 8192, 57344, 40960, 0, 0);
        CARTRIDGE_SWXEGS_128 = CartridgeType.add(35, "CARTRIDGE_SWXEGS_128", Platform.ATARI_800, 128, 8192, 122880, 40960, 0, 0);
        CARTRIDGE_SWXEGS_256 = CartridgeType.add(36, "CARTRIDGE_SWXEGS_256", Platform.ATARI_800, 256, 8192, 253952, 40960, 0, 0);
        CARTRIDGE_SWXEGS_512 = CartridgeType.add(37, "CARTRIDGE_SWXEGS_512", Platform.ATARI_800, 512, 8192, 516096, 40960, 0, 0);
        CARTRIDGE_SWXEGS_1024 = CartridgeType.add(38, "CARTRIDGE_SWXEGS_1024", Platform.ATARI_800, 1024, 8192, 1040384, 40960, 0, 0);
        CARTRIDGE_PHOENIX_8 = CartridgeType.add(39, "CARTRIDGE_PHOENIX_8", Platform.ATARI_800, 8, 8192, 0, 40960, 0, 0);
        CARTRIDGE_BLIZZARD_16 = CartridgeType.add(40, "CARTRIDGE_BLIZZARD_16", Platform.ATARI_800, 16, 16384, 0, 32768, 0, 0);
        CARTRIDGE_ATMAX_128 = CartridgeType.add(41, "CARTRIDGE_ATMAX_128", Platform.ATARI_800, 128, 8192, 0, 40960, 0, 65536);
        CARTRIDGE_ATMAX_1024 = CartridgeType.add(42, "CARTRIDGE_ATMAX_1024", Platform.ATARI_800, 1024, 8192, 1040384, 40960, 127, 65536);
        CARTRIDGE_SDX_128 = CartridgeType.add(43, "CARTRIDGE_SDX_128", Platform.ATARI_800, 128, 8192, 0, 40960, 0, 0);
        CARTRIDGE_OSS_8 = CartridgeType.add(44, "CARTRIDGE_OSS_8", Platform.ATARI_800, 8, 4096, 0, 45056, 0, 0);
        CARTRIDGE_OSS_043M_16 = CartridgeType.add(45, "CARTRIDGE_OSS_043M_16", Platform.ATARI_800, 16, 4096, 12288, 45056, 0, 0);
        CARTRIDGE_BLIZZARD_4 = CartridgeType.add(46, "CARTRIDGE_BLIZZARD_4", Platform.ATARI_800, 4, 4096, 0, 40960, 0, 0);
        CARTRIDGE_AST_32 = CartridgeType.add(47, "CARTRIDGE_AST_32", Platform.ATARI_800, 32, 256, 0, 40960, 0, 0);
        CARTRIDGE_ATRAX_SDX_64 = CartridgeType.add(48, "CARTRIDGE_ATRAX_SDX_64", Platform.ATARI_800, 64, 8192, 0, 40960, 0, 0);
        CARTRIDGE_ATRAX_SDX_128 = CartridgeType.add(49, "CARTRIDGE_ATRAX_SDX_128", Platform.ATARI_800, 128, 8192, 0, 40960, 0, 0);
        CARTRIDGE_TURBOSOFT_64 = CartridgeType.add(50, "CARTRIDGE_TURBOSOFT_64", Platform.ATARI_800, 64, 8192, 0, 40960, 0, 0);
        CARTRIDGE_TURBOSOFT_128 = CartridgeType.add(51, "CARTRIDGE_TURBOSOFT_128", Platform.ATARI_800, 128, 8192, 0, 40960, 0, 0);
        CARTRIDGE_ULTRACART_32 = CartridgeType.add(52, "CARTRIDGE_ULTRACART_32", Platform.ATARI_800, 32, 8192, 0, 40960, 0, 0);
        CARTRIDGE_LOW_BANK_8 = CartridgeType.add(53, "CARTRIDGE_LOW_BANK_8", Platform.ATARI_800, 8, 8192, 0, 32768, 0, 0);
        CARTRIDGE_SIC_128 = CartridgeType.add(54, "CARTRIDGE_SIC_128", Platform.ATARI_800, 128, 8192, 8192, 40960, 0, 0);
        CARTRIDGE_SIC_256 = CartridgeType.add(55, "CARTRIDGE_SIC_256", Platform.ATARI_800, 256, 8192, 8192, 40960, 0, 0);
        CARTRIDGE_SIC_512 = CartridgeType.add(56, "CARTRIDGE_SIC_512", Platform.ATARI_800, 512, 8192, 8192, 40960, 0, 0);
        CARTRIDGE_STD_2 = CartridgeType.add(57, "CARTRIDGE_STD_2", Platform.ATARI_800, 2, 2048, 0, 47104, 0, 0);
        CARTRIDGE_STD_4 = CartridgeType.add(58, "CARTRIDGE_STD_4", Platform.ATARI_800, 4, 4096, 0, 45056, 0, 0);
        CARTRIDGE_RIGHT_4 = CartridgeType.add(59, "CARTRIDGE_RIGHT_4", Platform.ATARI_800, 4, 4096, 0, 36864, 0, 0);
        CARTRIDGE_BLIZZARD_32 = CartridgeType.add(60, "CARTRIDGE_BLIZZARD_32", Platform.ATARI_800, 32, 8192, 0, 40960, 0, 0);
        CARTRIDGE_MEGAMAX_2048 = CartridgeType.add(61, "CARTRIDGE_MEGAMAX_2048", Platform.ATARI_800, 2048, 16384, 0, 32768, 0, 0);
        CARTRIDGE_THECART_128M = CartridgeType.add(62, "CARTRIDGE_THECART_128M", Platform.ATARI_800, 131072, 8192, 0, 40960, 0, 131072);
        CARTRIDGE_MEGA_4096 = CartridgeType.add(63, "CARTRIDGE_MEGA_4096", Platform.ATARI_800, 4096, 16384, 4161536, 32768, 254, 65536);
        CARTRIDGE_MEGA_2048 = CartridgeType.add(64, "CARTRIDGE_MEGA_2048", Platform.ATARI_800, 2048, 16384, 0, 32768, 0, 65536);
        CARTRIDGE_THECART_32M = CartridgeType.add(65, "CARTRIDGE_THECART_32M", Platform.ATARI_800, 32768, 8192, 0, 40960, 0, 131072);
        CARTRIDGE_THECART_64M = CartridgeType.add(66, "CARTRIDGE_THECART_64M", Platform.ATARI_800, 65536, 8192, 0, 40960, 0, 131072);
        CARTRIDGE_XEGS_8F_64 = CartridgeType.add(67, "CARTRIDGE_XEGS_8F_64", Platform.ATARI_800, 64, 8192, 57344, 40960, 0, 0);
        CARTRIDGE_ATRAX_128 = CartridgeType.add(68, "CARTRIDGE_ATRAX_128", Platform.ATARI_800, 128, 8192, 0, 40960, 0, 0);
        CARTRIDGE_ADAWLIAH_32 = CartridgeType.add(69, "CARTRIDGE_ADAWLIAH_32", Platform.ATARI_800, 32, 8192, 0, 40960, 0, 0);
        CARTRIDGE_ADAWLIAH_64 = CartridgeType.add(70, "CARTRIDGE_ADAWLIAH_64", Platform.ATARI_800, 64, 8192, 0, 40960, 0, 0);
        CARTRIDGE_5200_SUPER_64 = CartridgeType.add(71, "CARTRIDGE_5200_SUPER_64", Platform.ATARI_5200, 64, 32768, 32768, 16384, 1, 0);
        CARTRIDGE_5200_SUPER_128 = CartridgeType.add(72, "CARTRIDGE_5200_SUPER_128", Platform.ATARI_5200, 128, 32768, 98304, 16384, 3, 0);
        CARTRIDGE_5200_SUPER_256 = CartridgeType.add(73, "CARTRIDGE_5200_SUPER_256", Platform.ATARI_5200, 256, 32768, 229376, 16384, 7, 0);
        CARTRIDGE_5200_SUPER_512 = CartridgeType.add(74, "CARTRIDGE_5200_SUPER_512", Platform.ATARI_5200, 512, 32768, 491520, 16384, 15, 0);
        CARTRIDGE_ATMAX_NEW_1024 = CartridgeType.add(75, "CARTRIDGE_ATMAX_NEW_1024", Platform.ATARI_800, 1024, 8192, 0, 40960, 0, 65536);
        CartridgeType.initializeClass(CartridgeType.class, ValueSets.class);
    }

    private CartridgeType(int numericId, String id, Platform platform, int sizeInK, int bankSize, int initialBankOffset, int initialBankAddress, int initialBankNumber, int flashBlockSize) {
        super(id, 0);
        if (platform == null) {
            throw new IllegalArgumentException("Parameter 'platform' must not be null.");
        }
        this.platform = platform;
        this.numericId = numericId;
        this.sizeInKB = sizeInK;
        this.bankSize = bankSize;
        this.initialBankOffset = initialBankOffset;
        this.initialBankAddress = initialBankAddress;
        this.initialBankNumber = initialBankNumber;
        this.flashBlockSize = flashBlockSize;
    }

    private static CartridgeType add(int numericId, String id, Platform platform, int sizeInKB, int bankSize, int initialBankOffset, int initialBankAddress, int initialBankNumber, int flashBlockSize) {
        if (numericId < 0) {
            throw new IllegalArgumentException("Parameter 'numericId' must not be negative. Specified values is " + numericId + ".");
        }
        if (sizeInKB < 0) {
            throw new IllegalArgumentException("Parameter 'sizeInKB' must not be negative. Specified values is " + sizeInKB + ".");
        }
        CartridgeType result = new CartridgeType(numericId, id, platform, sizeInKB, bankSize, initialBankOffset, initialBankAddress, initialBankNumber, flashBlockSize);
        values.put(id, result);
        return result;
    }

    public static List<CartridgeType> getValues() {
        return Collections.unmodifiableList(new ArrayList<CartridgeType>(values.values()));
    }

    public static CartridgeType getInstance(int numbericId) {
        for (CartridgeType i : CartridgeType.getValues()) {
            if (i.getNumericId() != numbericId) continue;
            return i;
        }
        return null;
    }

    public static CartridgeType getInstance(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Parameter 'id' must not be null.");
        }
        return values.get(id);
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public int getNumericId() {
        return this.numericId;
    }

    public int getSizeInKB() {
        return this.sizeInKB;
    }

    public int getBankSize() {
        return this.bankSize;
    }

    public int getInitialBankOffset() {
        return this.initialBankOffset;
    }

    public int getInitialBankNumber() {
        return this.initialBankNumber;
    }

    public int getInitialBankAddress() {
        return this.initialBankAddress;
    }

    public int getFlashBlockSize() {
        return this.flashBlockSize;
    }

    public boolean isTheCart() {
        return this.equals(CARTRIDGE_THECART_32M) || this.equals(CARTRIDGE_THECART_64M) || this.equals(CARTRIDGE_THECART_128M);
    }

    public boolean isIncrementalFlashingSupported() {
        return this.isTheCart();
    }
}

