/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.ui;

import com.wudsn.tools.base.atari.cartridge.CartridgeDatabase;
import com.wudsn.tools.base.common.Application;
import com.wudsn.tools.base.common.TextUtility;
import com.wudsn.tools.base.gui.Desktop;
import com.wudsn.tools.base.gui.SimpleDialog;
import com.wudsn.tools.thecartstudio.Messages;
import com.wudsn.tools.thecartstudio.Texts;
import com.wudsn.tools.thecartstudio.model.CartridgeMenu;
import com.wudsn.tools.thecartstudio.model.CartridgeMenuType;
import com.wudsn.tools.thecartstudio.model.ContentType;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class AboutDialog
extends SimpleDialog {
    private CartridgeDatabase cartridgeDatabase;
    private JLabel contentLabel;

    public AboutDialog(JFrame parent, CartridgeDatabase cartridgeDatabase) {
        super(parent, Texts.MainWindow_Title, true);
        if (cartridgeDatabase == null) {
            throw new IllegalArgumentException("Parameter 'cartridgeDatabase' must not be null.");
        }
        this.cartridgeDatabase = cartridgeDatabase;
    }

    @Override
    protected void initComponents(JDialog dialog) {
        Container pane = dialog.getContentPane();
        this.contentLabel = new JLabel();
        JPanel panel = new JPanel();
        panel.add(this.contentLabel);
        pane.add((Component)panel, "Center");
        this.contentLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 0) {
                    String url = Texts.AboutDialog_URL;
                    Desktop.openBrowser(url);
                }
            }
        });
        this.dataToUI();
        dialog.setSize(230, 200);
        this.initButtonBar();
    }

    @Override
    protected void dataToUI() {
        String content = Texts.AboutDialog_Content;
        Application application = Application.getInstance();
        String localVersion = application.getLocalVersion();
        String webVersion = application.getWebVersion();
        content = content.replace("$localVersion$", localVersion);
        CartridgeMenu cartridgeMenu = CartridgeMenu.createInstance(CartridgeMenuType.SIMPLE);
        String cartridgeMenuVersion = cartridgeMenu.getVersion();
        cartridgeMenuVersion = !cartridgeMenu.isExternal() ? Messages.I130.format(cartridgeMenuVersion) : Messages.I131.format(cartridgeMenuVersion, cartridgeMenu.getExternalFilePath());
        content = content.replace("$cartridgeMenuVersion$", cartridgeMenuVersion);
        content = content.replace("$definedContentTypesCount$", TextUtility.formatAsDecimal(ContentType.getValues().size()));
        content = content.replace("$knownTitlesCount$", TextUtility.formatAsDecimal(this.cartridgeDatabase.getKnownTitelsCount()));
        content = content.replace("$knownContentTypesCount$", TextUtility.formatAsDecimal(this.cartridgeDatabase.getKnownCartridgeTypesCount()));
        String javaRuntimeVersion = String.valueOf(System.getProperty("java.runtime.name")) + " " + System.getProperty("java.runtime.version");
        String osVersion = String.valueOf(System.getProperty("os.name")) + " (" + System.getProperty("os.version") + ", " + System.getProperty("os.arch") + ")";
        String maximumMemory = application.getMemoryInfo().getMaximumMemoryMB();
        content = content.replace("$javaRuntimeVersion$", javaRuntimeVersion);
        content = content.replace("$osVersion$", osVersion);
        content = content.replace("$maximumMemory$", maximumMemory);
        String update = localVersion.equals(webVersion) ? Messages.I133.format(new String[0]) : (!localVersion.equals("????-??-?? ??:??:??") && !webVersion.equals("????-??-?? ??:??:??") ? (localVersion.compareTo(webVersion) < 0 ? Messages.I134.format(webVersion) : Messages.I135.format(webVersion)) : Messages.I136.format(webVersion));
        content = content.replace("$update", update);
        this.contentLabel.setText(content);
    }
}

