/*
 * Decompiled with CFR 0.152.
 */
package com.wudsn.tools.thecartstudio.model.megacart;

import com.wudsn.tools.base.common.ASCIIString;
import com.wudsn.tools.base.common.ByteArrayUtility;
import com.wudsn.tools.thecartstudio.model.ImportableMenu;
import com.wudsn.tools.thecartstudio.model.WorkbookEntry;

public final class MegacartMenu
extends ImportableMenu {
    private static final int MENU_CONTENT_LENGTH = 16384;
    private static final byte[] MENU_TEXT_BYTES = ASCIIString.getBytes("BY BERND HERALE - VERSION");

    public MegacartMenu(byte[] content) {
        super(content, "MegaCart Studio");
    }

    @Override
    public boolean hasMenuEntries() {
        return ByteArrayUtility.getIndexOf(this.content, 0, MENU_CONTENT_LENGTH, MENU_TEXT_BYTES) >= 0;
    }

    @Override
    public int collectMenuEntries(Object owner, ImportableMenu.Collector collector) {
        if (owner == null) {
            throw new IllegalArgumentException("Parameter 'owner' must not be null.");
        }
        if (collector == null) {
            throw new IllegalArgumentException("Parameter 'collector' must not be null.");
        }
        if (this.content.length > MENU_CONTENT_LENGTH) {
            byte[] signature = MENU_TEXT_BYTES;
            int signatureIndex = ByteArrayUtility.getIndexOf(this.content, 0, MENU_CONTENT_LENGTH, signature);
            if (signatureIndex == -1) {
                return 2;
            }
            int menuEntriesCount = 0;
            signature = new byte[]{-82, 32, 124, -114, 32, 124};
            signatureIndex = ByteArrayUtility.getIndexOf(this.content, 0, MENU_CONTENT_LENGTH, signature);
            int menuVersion = signatureIndex == 14314 ? 3 : 0;
            int offset = 7;
            collector.collectMenu(owner, "MegacartMenu: signatureIndex=" + Integer.toHexString(signatureIndex));
            int j = 0;
            while (j < 254) {
                menuEntriesCount = j;
                if (this.getByte(offset) == 255) break;
                StringBuilder titleBuilder = new StringBuilder(WorkbookEntry.TITLE_LENGTH);
                int i = 0;
                while (i < 33) {
                    char c = ATASCII[this.getByte(offset + i)];
                    titleBuilder.append(c);
                    ++i;
                }
                collector.collectMenuEntry(owner, menuVersion, j, titleBuilder.toString());
                offset += 40;
                ++j;
            }
            if (menuEntriesCount > 0) {
                if (menuVersion != 0) {
                    return 5;
                }
                return 4;
            }
            return 3;
        }
        return 1;
    }
}

